/*
 * @(#)MetalSliderUI.java	1.18 98/05/06
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.java.swing.plaf.mac;

import javax.swing.plaf.basic.BasicSliderUI;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Point;
import java.awt.Insets;
import java.awt.Color;
import java.io.Serializable;
import java.awt.IllegalComponentStateException;
import java.awt.Polygon;
import java.beans.*;
import java.awt.event.*;

import javax.swing.border.AbstractBorder;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.plaf.*;

/**
 * A Mac OS implementation of SliderUI.  
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.18 05/06/98
 * @author Tom Santos
 */
public class MacSliderUI extends BasicSliderUI {

    protected boolean filledSlider = false;
    protected static Color thumbColor;
    protected static Color highlightColor;
    protected static Color darkShadowColor;
    protected static int trackWidth;
    protected int majorTickLength;
    protected int minorTickLength;
    protected static Icon horizThumbIcon;
    protected static Icon vertThumbIcon;

    MouseListener thumbPressedListener;
    boolean thumbPressed = false;

    protected final String SLIDER_FILL = "JSlider.isFilled";

    public static ComponentUI createUI(JComponent c)    {
        return new MacSliderUI();
    }

    public MacSliderUI() {
        super( null );
    }

    public void installUI( JComponent c ) {
        trackWidth = ((Integer)UIManager.get( "Slider.trackWidth" )).intValue();
        majorTickLength = ((Integer)UIManager.get( "Slider.majorTickLength" )).intValue();
        minorTickLength = ((Integer)UIManager.get( "Slider.minorTickLength" )).intValue();
        horizThumbIcon = UIManager.getIcon( "Slider.horizontalThumbIcon" );
        vertThumbIcon = UIManager.getIcon( "Slider.verticalThumbIcon" );

        super.installUI( c );

        thumbColor = UIManager.getColor("Slider.thumb");
        highlightColor = UIManager.getColor("Slider.highlight");
        darkShadowColor = UIManager.getColor("Slider.darkShadow");

        scrollListener.setScrollByBlock( false );

        Object sliderFillProp = c.getClientProperty( SLIDER_FILL );
        if ( sliderFillProp != null ) {
            filledSlider = ((Boolean)sliderFillProp).booleanValue();
        }
    }

    protected void installListeners( JSlider slider ) {
        super.installListeners( slider );
        if ( (thumbPressedListener = createThumbPressedListener() ) != null ) {
            slider.addMouseListener( thumbPressedListener );
        }
    }

    protected void uninstallListeners( JSlider slider ) {
        if ( thumbPressedListener != null ) {
            slider.removeMouseListener( thumbPressedListener );
            thumbPressedListener = null;
        }
        super.uninstallListeners( slider );
    }

    protected MouseListener createThumbPressedListener() {
       return new ThumbListener();
    }

    protected PropertyChangeListener createPropertyChangeListener( JSlider slider ) {
        return new MetalPropertyListener();
    }

    protected class MetalPropertyListener extends BasicSliderUI.PropertyChangeHandler {
        public void propertyChange( PropertyChangeEvent e ) {  // listen for slider fill
            super.propertyChange( e );

            String name = e.getPropertyName();
            if ( name.equals( SLIDER_FILL ) ) {
                if ( e.getNewValue() != null ) {
                    filledSlider = ((Boolean)e.getNewValue()).booleanValue();
                }
                else {
                    filledSlider = false;
                }
            }
        }
    }

    public void paintThumb(Graphics g)  {
        Rectangle knobBounds = thumbRect;

        g.translate( knobBounds.x, knobBounds.y );

        if ( slider.getOrientation() == JSlider.HORIZONTAL ) {
            horizThumbIcon.paintIcon( slider, g, 0, 0 );
        }
        else {
            vertThumbIcon.paintIcon( slider, g, 0, 0 );
        }

        g.translate( -knobBounds.x, -knobBounds.y );
    }

    public void paintTrack(Graphics g)  {
        Color trackColor = MacLookAndFeel.getGray4();
        Color trackShadow = MacLookAndFeel.getGray11();
        Color trackAccent = MacLookAndFeel.getWhite();

        g.translate( trackRect.x, trackRect.y );

        int trackLeft = 0;
        int trackTop = 0;
        int trackRight = 0;
        int trackBottom = 0;

        // Draw the track
        if ( slider.getOrientation() == JSlider.HORIZONTAL ) {
            trackBottom = (trackRect.height - 1) - getThumbOverhang();
            trackTop = trackBottom - (getTrackWidth() - 1);
            trackRight = trackRect.width - 1;

            //if ( slider.isEnabled() ) {
            g.setColor( trackAccent );
            g.drawLine( trackLeft + 1, trackBottom - 1, trackLeft + 1, trackBottom - 1 );
            g.drawLine( trackLeft + 2, trackBottom, trackRight - 2, trackBottom );
            g.drawLine( trackRight - 1, trackTop + 1, trackRight - 1, trackBottom );
            g.drawLine( trackRight, trackTop + 2, trackRight, trackBottom - 1 );

            g.setColor( slider.isEnabled() ? trackColor : MacLookAndFeel.getGray2() );
            g.fillRect( trackLeft + 1, trackTop, getTrackLength() - 3, getTrackWidth() - 2 );
            g.drawLine( trackLeft, trackTop + 1, trackLeft, trackBottom - 2 );

            g.setColor( trackShadow );
            g.drawLine( trackLeft + 2, trackTop + 1, trackRight - 2, trackTop + 1 );
            g.drawLine( trackLeft + 2, trackBottom - 1, trackRight - 2, trackBottom - 1 );
            g.drawLine( trackLeft + 1, trackTop + 2, trackLeft + 1, trackBottom - 2 );
            g.drawLine( trackRight - 1, trackTop + 2, trackRight - 1, trackBottom - 2 );
            /*
                }
            else {
               
                g.setColor( trackColor );
                g.drawRect( trackLeft, trackTop, getTrackLength(), getTrackWidth() - 2 );

                if ( filledSlider ) {
                    int middleOfThumb = thumbRect.x + (thumbRect.width / 2);
                    middleOfThumb -= trackRect.x; // To compensate for the g.translate()

                    if ( slider.isEnabled() ) {
                        g.fillRect( trackLeft, trackTop, middleOfThumb, getTrackWidth() - 2 );
                    }
                    else {
                        g.fillRect( middleOfThumb, trackTop, trackRight - middleOfThumb, getTrackWidth() - 2 );
                    }
                }
            }
*/
        }
        else {
            trackLeft = (trackRect.width - getThumbOverhang()) - getTrackWidth();
            trackRight = (trackRect.width - getThumbOverhang()) - 1;
            trackBottom = trackRect.height - 1;

            //if ( slider.isEnabled() ) {
            g.setColor( trackAccent );
            g.drawLine( trackLeft + 1, trackBottom - 1, trackLeft + 1, trackBottom - 1 );
            g.drawLine( trackLeft + 2, trackBottom, trackRight - 2, trackBottom );
            g.drawLine( trackRight - 1, trackTop + 1, trackRight - 1, trackBottom );
            g.drawLine( trackRight, trackTop + 2, trackRight, trackBottom - 1 );

            g.setColor( slider.isEnabled() ? trackColor : MacLookAndFeel.getGray2() );
            g.fillRect( trackLeft + 1, trackTop, getTrackWidth() - 2, getTrackLength() - 2 );
            g.drawLine( trackLeft, trackTop + 1, trackLeft, trackBottom - 2 );

            g.setColor( trackShadow );
            g.drawLine( trackLeft + 2, trackTop + 1, trackRight - 2, trackTop + 1 );
            g.drawLine( trackLeft + 2, trackBottom - 1, trackRight - 2, trackBottom - 1 );
            g.drawLine( trackLeft + 1, trackTop + 2, trackLeft + 1, trackBottom - 2 );
            g.drawLine( trackRight - 1, trackTop + 2, trackRight - 1, trackBottom - 2 );
            /*
               }
            else {
                g.setColor( trackColor );
                g.drawRect( trackLeft, trackTop, getTrackWidth() - 2, getTrackLength() );

                if ( filledSlider ) {
                    int middleOfThumb = thumbRect.y + (thumbRect.height / 2);
                    middleOfThumb -= trackRect.y; // To compensate for the g.translate()

                    if ( slider.isEnabled() ) {
                        g.fillRect( trackLeft, middleOfThumb, getTrackWidth() - 2, trackBottom - middleOfThumb );
                    }
                    else {
                        g.fillRect( trackLeft, trackTop, getTrackWidth() - 2, middleOfThumb - trackLeft );
                    }
                }
            }
               */
        }
/*
        // Draw the fill
        if ( !filledSlider ) {
            if ( slider.isEnabled() ) {
                g.setColor( slider.getForeground() );

                if ( slider.getOrientation() == JSlider.HORIZONTAL ) {
                    g.fillRect( trackLeft + 2, trackTop + 2, getTrackLength() - 4, getTrackWidth() - 4 );

                    g.setColor( MacLookAndFeel.getGray4() );
                    g.drawLine( trackLeft + 1, trackTop + 1, trackLeft + 1, trackBottom - 2 );
                    g.drawLine( trackLeft + 1, trackTop + 1, trackRight - 2, trackTop + 1 );

                    g.setColor( MacLookAndFeel.getGray5() );
                    g.drawLine( trackLeft + 2, trackBottom - 1, trackRight - 1, trackBottom - 1 );
                    g.drawLine( trackRight - 1, trackTop + 2, trackRight - 1, trackBottom - 1 );
                }
                else {
                    g.fillRect( trackLeft + 2, trackTop + 2, getTrackWidth() - 4, getTrackLength() - 4 );

                    g.setColor( MacLookAndFeel.getGray6() );
                    g.drawLine( trackLeft + 1, trackTop + 1, trackLeft + 1, trackBottom - 2 );
                    g.drawLine( trackLeft + 1, trackTop + 1, trackRight - 2, trackTop + 1 );

                    g.setColor( MacLookAndFeel.getGray7() );
                    g.drawLine( trackRight - 1, trackTop + 2, trackRight - 1, trackBottom - 1 );
                    g.drawLine( trackLeft + 2, trackBottom - 1, trackRight - 1, trackBottom - 1 );
                }       
            }
        }
        else {
            Color lightColor = MacLookAndFeel.getGray5();
            Color darkColor = MacLookAndFeel.getGray6();

            g.setColor( slider.getForeground() );

            if ( slider.getOrientation() == JSlider.HORIZONTAL ) {
                Rectangle thumbBounds = thumbRect;
                int middleOfThumb = thumbBounds.x + (thumbBounds.width / 2);
                middleOfThumb -= trackRect.x; // To compensate for the g.translate()

                if ( !slider.getInverted() ) {
                    g.fillRect( trackLeft + 2, trackTop + 2,
                                (middleOfThumb - (trackLeft + 2)), getTrackWidth() - 4 );
                    g.setColor( lightColor );
                    g.drawLine( trackLeft + 2, trackTop + 1, middleOfThumb, trackTop + 1 );
                    g.drawLine( trackLeft + 1, trackTop + 1, trackLeft + 1, trackBottom - 1 );
                    g.setColor( darkColor );
                    g.drawLine( trackLeft + 2, trackBottom - 1, middleOfThumb, trackBottom - 1 );
                }
                else {
                    g.fillRect( middleOfThumb, trackTop + 2,
                                (trackRight - 1) - middleOfThumb, getTrackWidth() - 4 );
                    g.setColor( lightColor );
                    g.drawLine( middleOfThumb, trackTop + 1, trackRight - 2, trackTop + 1 );
                    g.drawLine( trackRight - 1, trackTop + 1, trackRight - 1, trackBottom - 1 );
                    g.setColor( darkColor );
                    g.drawLine( middleOfThumb, trackBottom - 1, trackRight - 2, trackBottom - 1 );
                }
            }
            else {
                Rectangle thumbBounds = thumbRect;
                int middleOfThumb = thumbBounds.y + (thumbBounds.height / 2);
                middleOfThumb -= trackRect.y;

                if ( !slider.getInverted() ) {
                    g.fillRect( trackLeft + 2, middleOfThumb,
                                getTrackWidth() - 4, (trackBottom - 1) - middleOfThumb );
                    g.setColor( lightColor );
                    g.drawLine( trackLeft + 1, middleOfThumb, trackLeft + 1, trackBottom - 2 );
                    g.drawLine( trackLeft + 1, trackBottom - 1, trackRight - 1, trackBottom - 1 );
                    g.setColor( darkColor );
                    g.drawLine( trackRight - 1, middleOfThumb, trackRight - 1, trackBottom - 2 );
                }
                else {
                    g.fillRect( trackLeft + 2, trackTop + 2,
                                getTrackWidth() - 4, middleOfThumb - (trackTop + 2) );
                    g.setColor( lightColor );
                    g.drawLine( trackLeft + 1, trackTop + 2, trackLeft + 1, middleOfThumb );
                    g.drawLine( trackLeft + 1, trackTop + 1, trackRight - 1, trackTop + 1 );
                    g.setColor( darkColor );
                    g.drawLine( trackRight - 1, trackTop + 2, trackRight - 1, middleOfThumb );
                }
            }
        }
*/
        g.translate( -trackRect.x, -trackRect.y );
    }

    public void paintFocus(Graphics g)  {        
        //g.setColor( getFocusColor() );
        //g.drawRect( focusRect.x, focusRect.y, focusRect.width - 1, focusRect.height - 1 );
    }

    protected Dimension getThumbSize() {
        Dimension size = new Dimension();

        if ( slider.getOrientation() == JSlider.VERTICAL ) {
            size.width = vertThumbIcon.getIconWidth();
            size.height = vertThumbIcon.getIconHeight();
        }
        else {
            size.width = horizThumbIcon.getIconWidth();
            size.height = horizThumbIcon.getIconHeight();
        }

        return size;
    }

    /**
     * Gets the height of the tick area for horizontal sliders and the width of the
     * tick area for vertical sliders.  BasicSliderUI uses the returned value to
     * determine the tick area rectangle.
     */
    public int getTickLength() {
        final int bufferBetweenTicksAndLabels = 4;
        int length = 0;
        int majorSpacing = slider.getMajorTickSpacing();
        int minorSpacing = slider.getMinorTickSpacing();

        if ( slider.getPaintTicks() && (majorSpacing != 0 || minorSpacing != 0) ) {
            length += majorSpacing != 0 ? majorTickLength : minorTickLength;
        }

        if ( slider.getPaintLabels() ) {
            length += bufferBetweenTicksAndLabels;
        }

        return length;
    }

    /**
     * Returns the shorter dimension of the track.
     */
    protected int getTrackWidth() {
        return 7;
    }

    /**
     * Returns the longer dimension of the slide bar.  (The slide bar is only the
     * part that runs directly under the thumb)
     */
    protected int getTrackLength() {   
        if ( slider.getOrientation() == JSlider.HORIZONTAL ) {
            return trackRect.width; 
        }
        return trackRect.height;
    }

    /**
     * Returns the amount that the thumb goes past the slide bar.
     */
    protected int getThumbOverhang() {
        return 6;
    }

    protected void paintMinorTickForHorizSlider( Graphics g, Rectangle tickBounds, int x ) {
        paintTickForHorizSlider( g, x, minorTickLength );
    }

    protected void paintMajorTickForHorizSlider( Graphics g, Rectangle tickBounds, int x ) {
        paintTickForHorizSlider( g, x, majorTickLength );
    }

    protected void paintMinorTickForVertSlider( Graphics g, Rectangle tickBounds, int y ) {
        paintTickForVertSlider( g, y, minorTickLength );
    }

    protected void paintMajorTickForVertSlider( Graphics g, Rectangle tickBounds, int y ) {
        paintTickForVertSlider( g, y, majorTickLength );
    }

    protected void paintTickForHorizSlider( Graphics g, int x, int length ) {
        g.translate( x, 0 );

        g.setColor( MacLookAndFeel.getWhite() );
        g.drawLine( -1, 0, 0, 0 );
        g.drawLine( -1, 0, -1, length - 2 );

        g.setColor( slider.isEnabled() ? MacLookAndFeel.getBlack() : MacLookAndFeel.getGray5() );
        g.drawLine( 0, 1, 0, length - 2 );

        g.setColor( slider.isEnabled() ? MacLookAndFeel.getGray4() : MacLookAndFeel.getGray2() );
        g.drawLine( 1, 1, 1, length - 1 );
        g.drawLine( 0, length - 1, 1, length - 1 );

        g.translate( -x, 0 );

    }

    protected void paintTickForVertSlider( Graphics g, int y, int length ) {
        g.translate( 0, y );

        g.setColor( MacLookAndFeel.getWhite() );
        g.drawLine( 0, -1, 0, 0 );
        g.drawLine( 0, -1, length - 2, -1 );

        g.setColor( slider.isEnabled() ? MacLookAndFeel.getBlack() : MacLookAndFeel.getGray5() );
        g.drawLine( 1, 0, length - 2, 0 );

        g.setColor( slider.isEnabled() ? MacLookAndFeel.getGray4() : MacLookAndFeel.getGray2() );
        g.drawLine( 1, 1, length - 1, 1 );
        g.drawLine( length - 1, 0, length - 1, 1 );

        g.translate( 0, -y );

    }

    class ThumbListener extends MouseAdapter {
        public void mousePressed( MouseEvent e ) {
            if ( macGetThumbBounds().contains( e.getX(), e.getY() ) ) {
                thumbPressed = true;
                macGetSlider().repaint();
            }
        }

        public void mouseReleased( MouseEvent e ) {
            thumbPressed = false;
            macGetSlider().repaint();
        }
    }

    Rectangle macGetThumbBounds() {
        return thumbRect;
    }

    JSlider macGetSlider() {
        return slider;
    }
}
