/*
 * @(#)MacTreeUI.java	1.12 98/05/14
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.java.swing.plaf.mac;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.DefaultTextUI;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.util.*;
import javax.swing.plaf.*;
import javax.swing.tree.*;

import javax.swing.plaf.basic.*;

/**
 * MacTreeUI is the Mac OS version of JFC trees.
 *
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.12 05/14/98
 * @author Tom Santos
 */
public class MacTreeUI extends BasicTreeUI {

    protected boolean pressedOnControl = false;
    protected boolean highlightControl = false;
    protected Icon darkExpandedIcon;
    protected Icon darkCollapsedIcon;
    protected TreePath firstPath;
    protected MouseMotionListener mouseMotionHandler;

    // Boilerplate
    public static ComponentUI createUI(JComponent x) {
        return new MacTreeUI();
    }

    public MacTreeUI()
    {
        super();
    }

    public void installUI( JComponent c ) {
        super.installUI( c );
        darkExpandedIcon = UIManager.getIcon( "Tree.darkExpandedIcon" );
        darkCollapsedIcon = UIManager.getIcon( "Tree.darkCollapsedIcon" );
    }

    protected void installListeners() {
        super.installListeners();
        if ( (mouseMotionHandler = createMouseMotionListener()) != null ) {
            tree.addMouseMotionListener( mouseMotionHandler );
        }
    }

    protected void uninstallListeners() {
        if ( mouseMotionHandler != null ) {
            tree.removeMouseMotionListener( mouseMotionHandler );
            mouseMotionHandler = null;
        }
        super.uninstallListeners();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new MouseMotionHandler();
    }

    protected boolean isLocationInExpandControl(TreePath path, 
                                                int mouseX, int mouseY) {
        int row = getRowForPath( tree, path );

        int depth = path.getPathCount() - 1;
        boolean mightHaveExpandControl = depth > 0 || (depth == 0 && getShowsRootHandles());

        if ( tree != null && !isLeaf( row ) && mightHaveExpandControl ) {
            Icon icon;

            if ( tree.isExpanded( path ) ) {
                icon = getExpandedIcon();
            }
            else {
                icon = getCollapsedIcon();
            }

            Rectangle rowBounds = tree.getPathBounds( path );
            Insets insets = tree.getInsets();
            int rowMiddle = rowBounds.y + (rowBounds.height / 2);
            int top = rowMiddle - (icon.getIconHeight() / 2);
            int bottom = rowMiddle + (icon.getIconHeight() / 2);
            int right = insets.left + icon.getIconWidth() - 1;

            if ( mouseY >= top && mouseY <= bottom &&
                 mouseX >= insets.left && mouseX <= right ) {
                return true;
            }
        }
        return false;
    }

    public void paint(Graphics g, JComponent c) {
        super.paint( g, c );
    }

    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds,
                                          Insets insets, TreePath path) {
    }

    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds,
                                            Insets insets, Rectangle bounds,
                                            TreePath path, int row,
                                            boolean isExpanded,
                                            boolean hasBeenExpanded, boolean
                                            isLeaf) {
    }


    protected boolean shouldPaintExpandControl(TreePath path, int row,
                                               boolean isExpanded,
                                               boolean hasBeenExpanded,
                                               boolean isLeaf) {
        if ( !getShowsRootHandles() && isRootVisible() && path.getPathCount() == 1 ) {
            return false;
        }
        else {
            return super.shouldPaintExpandControl( path, row, isExpanded, hasBeenExpanded, isLeaf );
        }
    }

    protected void paintExpandControl(Graphics g,
                                      Rectangle clipBounds, Insets insets,
                                      Rectangle bounds, TreePath path,
                                      int row, boolean isExpanded,
                                      boolean hasBeenExpanded,
                                      boolean isLeaf) {
        g.translate( insets.left, 0 );

        Object value = path.getLastPathComponent();

        // Draw icons if not a leaf and either hasn't been loaded,
        // or the model child count is > 0.
        if ( !isLeaf && (!hasBeenExpanded ||
                         treeModel.getChildCount(value) > 0) ) {
            int middleXOfKnob;
            int middleYOfKnob = bounds.y + (bounds.height / 2);

            if ( isExpanded ) {
                Icon expandedIcon = getExpandedIcon();
                middleXOfKnob = expandedIcon.getIconWidth() / 2;
                if ( expandedIcon != null )
                    drawCentered(tree, g, expandedIcon, middleXOfKnob,
                                 middleYOfKnob );
            }
            else {
                Icon collapsedIcon = getCollapsedIcon();
                middleXOfKnob = collapsedIcon.getIconWidth() / 2;
                if ( collapsedIcon != null )
                    drawCentered(tree, g, collapsedIcon, middleXOfKnob,
                                 middleYOfKnob);
            }
        }

        g.translate( -insets.left, 0 );
    }

    public Icon getExpandedIcon() {
        if ( highlightControl ) {
            return darkExpandedIcon;
        }
        else {
            return super.getExpandedIcon();
        }
    }

    public Icon getCollapsedIcon() {
        if ( highlightControl ) {
            return darkCollapsedIcon;
        }
        else {
            return super.getCollapsedIcon();
        }
    }

    protected JTree getTree() {
        return tree;
    }

    protected void handleExpandControlClick(TreePath path, int mouseX,
                                            int mouseY) {
        super.handleExpandControlClick( path, mouseX, mouseY );
    }

    protected void repaintControl( TreePath path ) {
        Rectangle bounds = getPathBounds( tree, path );
        bounds.x = tree.getInsets().left;
        bounds.width = getExpandedIcon().getIconWidth();
        tree.repaint( bounds );
    }

    public class MouseHandler extends BasicTreeUI.MouseHandler {
        public void mousePressed( MouseEvent e ) {
            int x = e.getX();
            int y = e.getY();

            TreePath path = getClosestPathForLocation( getTree(), x, y );
            firstPath = path;

            if ( isLocationInExpandControl( path, x, y ) ) {
                pressedOnControl = true;
                highlightControl = true;
                repaintControl( path );
            }
            else {
                super.mousePressed( e );
            }
        }

        public void mouseReleased( MouseEvent e ) {
            int x = e.getX();
            int y = e.getY();

            TreePath path = getClosestPathForLocation( getTree(), x, y );

            highlightControl = false;

            if ( pressedOnControl && path == firstPath && isLocationInExpandControl( path, x, y ) ) {
                pressedOnControl = false;

                handleExpandControlClick( path, x, y );
            }
            else {
                pressedOnControl = false;

                super.mouseReleased( e );
            }
        }
    }

    public class MouseMotionHandler extends MouseMotionAdapter {
        public void mouseDragged( MouseEvent e ) {
            if ( pressedOnControl ) {
                int x = e.getX();
                int y = e.getY();
                TreePath path = getClosestPathForLocation( getTree(), x, y );
                boolean locationInControl = isLocationInExpandControl( path, x, y );

                if ( !highlightControl && path == firstPath && locationInControl ) {
                    highlightControl = true;
                    repaintControl( firstPath );
                }
                else if ( highlightControl && !locationInControl ) {
                    highlightControl = false;
                    repaintControl( firstPath );
                }
            }
        }
    }
}
