// (* ========================================================= *)
// (**	Interface to the Jasmin Byte-code assembler.		*)
// (*	K John Gough, 10th June 1999				*)
// (*	Modifications:						*)
// (*		Version for GPCP V0.3 April 2000 (kjg)		*)
// (* ========================================================= *)
// (*	The real code is in JasminAsm.java			*)	
// (* ========================================================= *)
//
// MODULE JasminAsm;
// 
//   PROCEDURE Init*(); BEGIN END Init;
// 
//   PROCEDURE Assemble*(IN fil : ARRAY OF CHAR); BEGIN END Assemble;
// 
// END JasminAsm.
// 
//  NOTE: this needs (as at 13-Jun-2000) to be compiled using
//
//  $ csc /t:library /r:System.Diagnostics.dll /r:RTS.dll JasminAsm.cs
//
//  later versions need instead:
//
//  $ csc /t:library /r:RTS.dll JasminAsm.cs
// 
//  because System.Diagnostics is now found in mscorlib.dll
// 
using System.Diagnostics;

namespace JasminAsm {
public class JasminAsm {


    private static Process asm = null;
  
    public static void Init() {
	if (asm == null) {
	    asm = new Process();
	    asm.StartInfo.FileName = "jasmin";
	    asm.StartInfo.WindowStyle = ProcessWindowStyle.Minimized;
	}
    }

    public static void Assemble(char[] fil) {
	int retCode;
	if (asm == null)
	    Init();
	System.String fName = CP_rts.mkStr(fil);
	asm.StartInfo.Arguments = fName;
	asm.Start();
	asm.WaitForExit();
	retCode = asm.ExitCode;
	if (retCode != 0)
	    System.Console.WriteLine("#gpcp: jasmin FAILED " + retCode);
    }
  }
}
