
/** This is part of the body of the GPCP runtime support.
 *
 *  Written November 1998, John Gough.
 *
 *  CP*rts contains the runtime helpers, this class has 
 *  adapters for hooking into the various Native libraries.
 *  These are the user accessible parts of the runtime.  The 
 *  facilities in CP*rts are known to each code-emitter, but have
 *  no CP-accessible functions.  The interface is defined in RTS.cp
 *
 *  Version of 29 March 2000 (kjg) --
 *  There is a swindle involved here, for the bootstrap version
 *  of the compiler: any functions with OUT scalars will have
 *  a different signature in the old and new versions.  This 
 *  module implements both, by overloading the methods.
 */

package CP.RTS;

import java.io.*;
import CP.CPJrts.*;

/* ------------------------------------------------------------ */
/* 		        Support for RTS.cp			*/
/* ------------------------------------------------------------ */

public final class RTS
{
	
	public static char[] defaultTarget = {'j','v','m','\0'};

	public static char[] getStr(java.lang.Exception x) {
	    String str = x.toString();
	    return CPJrts.JavaStrToChrOpen(str);
	}

	/* Java language version */
	public static void StrToReal(char[] str,
					double[] o, 	// OUT param
					boolean[] r)	// OUT param
	{
	    String jstr = new String(str);
	    try {
		o[0] = Double.valueOf(jstr.trim()).doubleValue();
		r[0] = true;
	    } catch(Exception e) {
		r[0] = false;
	    }
	}

	/* Component Pascal language version */
	public static double StrToReal(char[] str,
					boolean[] r)	// OUT param
	{
	    String jstr = new String(str);
	    try {
		r[0] = true;
		return Double.valueOf(jstr.trim()).doubleValue();
	    } catch(Exception e) {
		r[0] = false;
		return 0.0;
	    }
	}

	/* Java language version */
	public static void StrToInt(char[] str,
					int[] o,	// OUT param
					boolean[] r)	// OUT param
	{
	    String jstr = new String(str);
	    try {
		o[0] = Integer.parseInt(jstr.trim());
		r[0] = true;
	    } catch(Exception e) {
		r[0] = false;
	    }
	}

	/* Component Pascal language version */
	public static int StrToInt(char[] str,
					boolean[] r)	// OUT param
	{
	    String jstr = new String(str);
	    try {
		r[0] = true;
		return Integer.parseInt(jstr.trim());
	    } catch(Exception e) {
		r[0] = false;
	        return 0;
	    }
	}

	/* Java language version */
	public static void StrToLong(char[] str,
					long[] o,	// OUT param
					boolean[] r)	// OUT param
	{
	    String jstr = new String(str);
	    try {
		o[0] = Long.parseLong(jstr.trim());
		r[0] = true;
	    } catch(Exception e) {
		r[0] = false;
	    }
	}

	/* Component Pascal language version */
	public static long StrToLong(char[] str,
					boolean[] r)	// OUT param
	{
	    String jstr = new String(str);
	    try {
		r[0] = true;
		return Long.parseLong(jstr.trim());
	    } catch(Exception e) {
		r[0] = false;
	        return 0;
	    }
	}

	public static byte HexStrToUByte(char[] str,
				 	 boolean[] r)	// OUT param
        {
	    String jstr = new String(str);
	    try {
		r[0] = true;
		return Byte.decode(jstr.trim()).byteValue();
	    } catch(Exception e) {
		r[0] = false;
	        return 0;
	    }
        }

/* ------------------------------------------------------------ */
//  PROCEDURE IntToStr*(i : INTEGER; OUT s : ARRAY OF CHAR);
//  (** Decode a CP INTEGER into an array *)
//  BEGIN END IntToStr;
//
	public static void IntToStr(int num,
				    char[] str)
	{
	    String jls = String.valueOf(num);
            int    len = jls.length();
            if (len >= str.length)
                len = str.length - 1;
            jls.getChars(0, len, str, 0);
            str[len] = '\0';
	}

/* ------------------------------------------------------------ */
//  PROCEDURE LongToStr*(i : LONGINT; OUT s : ARRAY OF CHAR);
//  (** Decode a CP INTEGER into an array *)
//  BEGIN END LongToStr;
//
	public static void LongToStr(long num,
				    char[] str)
	{
	    String jls = String.valueOf(num);
            int    len = jls.length();
            if (len >= str.length)
                len = str.length - 1;
            jls.getChars(0, len, str, 0);
            str[len] = '\0';
	}

/* ------------------------------------------------------------ */
//  PROCEDURE RealToStr*(r : REAL; OUT s : ARRAY OF CHAR);
//  (** Decode a CP REAL into an array *)
//  BEGIN END RealToStr;
//
	public static void RealToStr(double num,
				     char[] str)
	{
	    String jls = String.valueOf(num);
            int    len = jls.length();
            if (len >= str.length)
                len = str.length - 1;
            jls.getChars(0, len, str, 0);
            str[len] = '\0';
	}

/* ------------------------------------------------------------ */
//
//  PROCEDURE realToLongBits(r : REAL) : LONGINT;
//  (** Convert an ieee double into a longint with same bit pattern *)
//
	public static long realToLongBits(double r)
	{
	    return java.lang.Double.doubleToLongBits(r);
	}
//
//  PROCEDURE longBitsToReal(l : LONGINT) : REAL;
//  (** Convert an ieee double into a longint with same bit pattern *)
//
	public static double longBitsToReal(long l)
	{
	    return java.lang.Double.longBitsToDouble(l);
	}
//
//  PROCEDURE shortRealToIntBits(r : SHORTREAL) : INTEGER;
//  (** Convert an ieee float into an int with same bit pattern *)
//
	public static int shortRealToIntBits(float f)
	{
	    return Float.floatToIntBits(f);
	}
//
//  PROCEDURE intBitsToshortReal(i : INTEGER) : SHORTREAL;
//  (** Convert an int into an ieee float with same bit pattern *)
//
	public static float intBitsToShortReal(int i)
	{
	    return Float.intBitsToFloat(i);
	}
//
//  PROCEDURE hiByte(l : SHORTINT) : BYTE;
//  (** Get hi-significant byte of short integer *)
//
	public static int hiByte(short s)
	{
	    return (byte) (s >> 8);
	}
//
//  PROCEDURE loByte(l : SHORTINT) : BYTE;
//  (** Get lo-significant byte of short integer *)
//
	public static int loByte(short s)
	{
	    return (byte) s;
	}
//
//  PROCEDURE hiShort(l : INTEGER) : SHORTINT;
//  (** Get hi-significant short int of integer *)
//
	public static int hiShort(int i)
	{
	    return (short) (i >> 16);
	}
//
//  PROCEDURE loShort(l : INTEGER) : SHORTINT;
//  (** Get lo-significant short int of integer *)
//
	public static int loShort(int i)
	{
	    return (short) i;
	}
//
//  PROCEDURE hiInt(l : LONGINT) : INTEGER;
//  (** Get hi-significant word of long integer *)
//
	public static int hiInt(long l)
	{
	    return (int) (l >> 32);
	}
//
//  PROCEDURE loInt(l : LONGINT) : INTEGER;
//  (** Get lo-significant word of long integer *)
//
	public static int loInt(long l)
	{
	    return (int) l;
	}
//
//  PROCEDURE Throw(IN s : ARRAY OF CHAR);
//  (** Abort execution with an error *)
//
	public static void Throw(char[] s)
		throws Exception
	{
		throw new Exception(new String(s));
	}

	public static void ClassMarker(Object o)
	{
	    System.out.print(o.getClass().getName());
	}
//
//  PROCEDURE GetMillis*() : LONGINT;
//  (** Get time in milliseconds *)
//  BEGIN RETURN 0 END GetMillis;
//
	public static long GetMillis() {
	    return System.currentTimeMillis();
	}
//
//  PROCEDURE GetDateString*(OUT str : ARRAY OF CHAR);
//  (** Get a date string in some native format *)
//  BEGIN END GetDateString;
//
	public static void GetDateString(char[] str) {
	    String date = new java.util.Date().toString();
	    int len = date.length();
	    date.getChars(0, len, str, 0);
	    str[len] = '\0';
	}

}

/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */

