/* ------------------------------------------------------------ */
// Body of GPFiles interface.
// This file implements the code of the GPFiles.cp file.
// dwc August 1999. COOL version kjg May 2000
// kjg September 2000.  Stripped version as abstract base class.
// kjg March 2001.  Version for Beta-2 libraries.
/* ------------------------------------------------------------ */

#if !BETA1
  #define BETA2
#endif

namespace GPFiles {
public abstract class GPFiles {

  public static char pathSep = ';';
  public static char fileSep = '\\';
  public static char optChar = '/';

  /* ----------------------------------	*/

  private static System.String mkStr(char[] arr) {
    int  ix = 0;
    char ch;
    do {
	ch = arr[ix]; ix++;
    } while (ch != '\0');
    return new System.String(arr,0,ix-1);
  }

  /* ----------------------------------	*/

  public static bool isOlder(FILE first, FILE second) {
#if BETA1
        int comp = System.DateTime.Compare(
		    first.file.LastWriteTime,
		    second.file.LastWriteTime
		);
#else //BETA2
	int comp = System.DateTime.Compare(
		     System.IO.File.GetLastWriteTime(first.path),
		     System.IO.File.GetLastWriteTime(second.path)
		);
#endif
	return comp == -1;
    }

  public static void MakeDirectory(char[] dirName) {
	System.String path = mkStr(dirName);
        System.IO.Directory.CreateDirectory(path);
    }

  public static char[] CurrentDirectory() {
#if BETA1
        return System.IO.Directory.CurrentDirectory.ToCharArray();
#else //BETA2
        return System.IO.Directory.GetCurrentDirectory().ToCharArray();
#endif
  }
  
  public static bool exists(char[] filName) {
#if BETA1
	System.IO.File file = new System.IO.File(mkStr(filName));
	return file.Exists;
#else //BETA2
	System.String path  = mkStr(filName);
	return System.IO.File.Exists(path);
#endif
    }

  } // end of class GPFiles

/* ------------------------------------------------------------ */

public abstract class FILE {
  
#if BETA1
	public System.IO.File file;
#else //BETA2
	public System.String path;
#endif

  }  // end of class GPFiles.FILE

/* ------------------------------------------------------------ */
}  // end of NameSpace GPFiles
/* ------------------------------------------------------------ */

