
/** This is the body of the GPCP runtime support.
 *
 *  Written November 1998, John Gough.
 *
 *
 *
 */

package CP.CPJrts;
import  java.lang.reflect.*;

public class CPJrts
{

/* ==================================================================== *
 *		MOD and DIV helpers. With correction factors		*
 * ==================================================================== */

	public static int CpModI(int lVal, int rVal)
	{
           // A correction is required if the signs of
           // the two operands are different, but the
           // remainder is non-zero. Inc rem by rVal.
	    int rslt = lVal % rVal;
            if ((lVal < 0 != rVal < 0) && (rslt != 0))
                            rslt += rVal;
	    return rslt;
	}

	public static int CpDivI(int lVal, int rVal)
	{
           // A correction is required if the signs of
           // the two operands are different, but the
           // remainder is non-zero. Dec quo by 1.
            int rslt = lVal / rVal;
            int remV = lVal % rVal;
            if ((lVal < 0 != rVal < 0) && (remV != 0))
              rslt--;
	    return rslt;
	}

	public static long CpModL(long lVal, long rVal)
	{
           // A correction is required if the signs of
           // the two operands are different, but the
           // remainder is non-zero. Inc rem by rVal.
	    long rslt = lVal % rVal;
            if ((lVal < 0 != rVal < 0) && (rslt != 0))
                            rslt += rVal;
	    return rslt;
	}

	public static long CpDivL(long lVal, long rVal)
	{
           // A correction is required if the signs of
           // the two operands are different, but the
           // remainder is non-zero. Dec quo by 1.
            long rslt = lVal / rVal;
            long remV = lVal % rVal;
            if ((lVal < 0 != rVal < 0) && (remV != 0))
              rslt--;
	    return rslt;
	}

/* ==================================================================== *
 *		Various string and char-array helpers			*
 * ==================================================================== */

	public static String CaseMesg(int i)
	{
	    String s = "CASE-trap: selector = " + i;
	    return s;
	}

/* -------------------------------------------------------------------- */

	public static String WithMesg(Object o)
	{
	    String c = o.getClass().getName();
	    c = c.substring(c.lastIndexOf('.') + 1);
	    c = "WITH else-trap: type = " + c;
	    return c;
	}

/* -------------------------------------------------------------------- */

	public static int ChrArrLength(char[] src)
	{
	    int  ix = 0;
	    char ch;
	    do {
		ch = src[ix];
		ix++;
	    } while ((ch != '\0') && (ix < src.length));
	    return ix-1;
	}

/* -------------------------------------------------------------------- */

	public static int ChrArrLplus1(char[] src)
	{
	    int  ix = 0;
	    char ch;
	    do {
		ch = src[ix];
		ix++;
	    } while (ch != '\0');
	    return ix;
	}

/* -------------------------------------------------------------------- */

	public static char[] JavaStrToChrOpen(String input)
	{
	    int    len = input.length();
	    char[] str = new char[len+1];
	    input.getChars(0, len, str, 0);
	    str[len] = '\0';
	    return str;
	}

/* -------------------------------------------------------------------- */

	public static void JavaStrToFixChr(char[] out, String in)
	{
	    int    len = in.length();
	    in.getChars(0, len, out, 0);
	    out[len] = '\0';
	}

/* -------------------------------------------------------------------- */

	public static String FixChToJavaStr(char[] arr)
	{
            // This truncation makes semantics same as .NET version
            int len = ChrArrLength(arr);
	    return new String(arr, 0, len);
	}

/* -------------------------------------------------------------------- */

	public static void ChrArrStrCopy(char[] dst, char[] src)
	{
	    int  ix = 0;
	    char ch;
	    do {
		ch = src[ix];
		dst[ix] = ch;
		ix++;
	    } while (ch != '\0');
	}

/* -------------------------------------------------------------------- */

	public static void ChrArrCheck(char[] src)
	{
	    int  ix = 0;
	    char ch;
	    do {
		ch = src[ix];
		if (ch > 0xFF) throw new Error("SHORT on array error");
		ix++;
	    } while (ch != '\0');
	}

/* -------------------------------------------------------------------- */

        public static int strCmp(char[] l, char[] r)
	{
	    for (int ix = 0; ix < l.length && ix < r.length; ix++) {
		if (l[ix] < r[ix]) return -1;
		else if (l[ix] > r[ix]) return 1;
		else if (l[ix] == '\0') return 0;
	    }
	    if (l.length < r.length) return -1;
	    else if (l.length < r.length) return 1;
	    else return 0;
	}

/* ==================================================================== *
 *		Procedure variable reflection helper method		*
 * ==================================================================== */

	public static Method getMth(String mod, String prc)
	{
	    Class    mCls = null;
	    Method[] mths = null;
	    try {
		mCls = Class.forName(mod);
		mths = mCls.getDeclaredMethods();
		for (int i = 0; i < mths.length; i++) {
		    if (mths[i].getName().equals(prc))
			return mths[i];
		}
		return null;
	    } catch(Exception e) {
		System.out.println("CPJrts: " + e.toString());
		return null;
	    }
	}

/* ==================================================================== *
 *		String concatenation helper methods			*
 * ==================================================================== */

	public static String ArrArrToString(char[] l, char[] r)
	{
	    int llen = ChrArrLength(l);
	    int rlen = ChrArrLength(r);
	    StringBuffer buff = new StringBuffer(llen + rlen);
	    return buff.append(l,0,llen).append(r,0,rlen).toString();
	}

	public static String ArrStrToString(char[] l, String r)
	{
	    int llen = ChrArrLength(l);
	    StringBuffer buff = new StringBuffer(3 * llen);
	    return buff.append(l,0,llen).append(r).toString();
	}

	public static String StrArrToString(String l, char[] r)
	{
	    int rlen = ChrArrLength(r);
	    StringBuffer buff = new StringBuffer(3 * rlen);
	    return buff.append(l).append(r,0,rlen).toString();
	}

	public static String StrStrToString(String l, String r)
	{
	    StringBuffer buff = new StringBuffer(l);
	    return buff.append(r).toString();
	}

}

