/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.util.ParsedURLData;
import org.apache.batik.util.ParsedURLDataProtocolHandler;
import org.apache.batik.util.ParsedURLDefaultProtocolHandler;
import org.apache.batik.util.ParsedURLJarProtocolHandler;
import org.apache.batik.util.ParsedURLProtocolHandler;
import org.apache.batik.util.Service;

public class ParsedURL {
    ParsedURLData data;
    String userAgent;
    private static Map handlersMap = null;
    private static ParsedURLProtocolHandler defaultHandler = new ParsedURLDefaultProtocolHandler();
    private static String globalUserAgent = "Batik/1.0";
    static /* synthetic */ Class class$org$apache$batik$util$ParsedURLProtocolHandler;

    public ParsedURL(String string) {
        this.userAgent = ParsedURL.getGlobalUserAgent();
        this.data = ParsedURL.parseURL(string);
    }

    public ParsedURL(String string, String string2) {
        this.userAgent = ParsedURL.getGlobalUserAgent();
        this.data = string != null ? ParsedURL.parseURL(string, string2) : ParsedURL.parseURL(string2);
    }

    public ParsedURL(URL uRL) {
        this.userAgent = ParsedURL.getGlobalUserAgent();
        this.data = new ParsedURLData(uRL);
    }

    public ParsedURL(URL uRL, String string) {
        this.userAgent = ParsedURL.getGlobalUserAgent();
        this.data = uRL != null ? ParsedURL.parseURL(new ParsedURL(uRL), string) : ParsedURL.parseURL(string);
    }

    public ParsedURL(ParsedURL parsedURL, String string) {
        this.userAgent = parsedURL.getUserAgent();
        this.data = parsedURL != null ? ParsedURL.parseURL(parsedURL, string) : ParsedURL.parseURL(string);
    }

    public static InputStream checkGZIP(InputStream inputStream) throws IOException {
        return ParsedURLData.checkGZIP(inputStream);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean complete() {
        return this.data.complete();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ParsedURL)) {
            return false;
        }
        ParsedURL parsedURL = (ParsedURL)object;
        return this.data.equals(parsedURL.data);
    }

    public String getContentEncoding() {
        return this.data.getContentEncoding(this.userAgent);
    }

    public String getContentType() {
        return this.data.getContentType(this.userAgent);
    }

    public static String getGlobalUserAgent() {
        return globalUserAgent;
    }

    public static synchronized ParsedURLProtocolHandler getHandler(String string) {
        if (string == null) {
            return defaultHandler;
        }
        Map map = ParsedURL.getHandlersMap();
        ParsedURLProtocolHandler parsedURLProtocolHandler = (ParsedURLProtocolHandler)map.get(string);
        if (parsedURLProtocolHandler == null) {
            parsedURLProtocolHandler = defaultHandler;
        }
        return parsedURLProtocolHandler;
    }

    private static synchronized Map getHandlersMap() {
        if (handlersMap != null) {
            return handlersMap;
        }
        handlersMap = new HashMap();
        ParsedURL.registerHandler(new ParsedURLDataProtocolHandler());
        ParsedURL.registerHandler(new ParsedURLJarProtocolHandler());
        Iterator iterator = Service.providers(class$org$apache$batik$util$ParsedURLProtocolHandler != null ? class$org$apache$batik$util$ParsedURLProtocolHandler : (class$org$apache$batik$util$ParsedURLProtocolHandler = ParsedURL.class$("org.apache.batik.util.ParsedURLProtocolHandler")));
        while (iterator.hasNext()) {
            ParsedURLProtocolHandler parsedURLProtocolHandler = (ParsedURLProtocolHandler)iterator.next();
            ParsedURL.registerHandler(parsedURLProtocolHandler);
        }
        return handlersMap;
    }

    public String getHost() {
        if (this.data.host == null) {
            return null;
        }
        return new String(this.data.host);
    }

    public String getPath() {
        if (this.data.path == null) {
            return null;
        }
        return new String(this.data.path);
    }

    public int getPort() {
        return this.data.port;
    }

    public String getPortStr() {
        return this.data.getPortStr();
    }

    public String getProtocol() {
        if (this.data.protocol == null) {
            return null;
        }
        return new String(this.data.protocol);
    }

    protected static String getProtocol(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(58);
        if (n2 == -1) {
            return null;
        }
        String string2 = string.substring(0, n2).toLowerCase();
        if (string2.indexOf(47) != -1) {
            return null;
        }
        return string2;
    }

    public String getRef() {
        if (this.data.ref == null) {
            return null;
        }
        return new String(this.data.ref);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public InputStream openStream() throws IOException {
        return this.data.openStream(this.userAgent, null);
    }

    public InputStream openStream(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string);
        return this.data.openStream(this.userAgent, arrayList.iterator());
    }

    public InputStream openStream(Iterator iterator) throws IOException {
        return this.data.openStream(this.userAgent, iterator);
    }

    public InputStream openStream(String[] stringArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        int n2 = 0;
        while (n2 < stringArray.length) {
            arrayList.add(stringArray[n2]);
            ++n2;
        }
        return this.data.openStream(this.userAgent, arrayList.iterator());
    }

    public InputStream openStreamRaw() throws IOException {
        return this.data.openStreamRaw(this.userAgent, null);
    }

    public InputStream openStreamRaw(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string);
        return this.data.openStreamRaw(this.userAgent, arrayList.iterator());
    }

    public InputStream openStreamRaw(Iterator iterator) throws IOException {
        return this.data.openStreamRaw(this.userAgent, iterator);
    }

    public InputStream openStreamRaw(String[] stringArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        int n2 = 0;
        while (n2 < stringArray.length) {
            arrayList.add(stringArray[n2]);
            ++n2;
        }
        return this.data.openStreamRaw(this.userAgent, arrayList.iterator());
    }

    public static ParsedURLData parseURL(String string) {
        ParsedURLProtocolHandler parsedURLProtocolHandler = ParsedURL.getHandler(ParsedURL.getProtocol(string));
        return parsedURLProtocolHandler.parseURL(string);
    }

    public static ParsedURLData parseURL(String string, String string2) {
        ParsedURL parsedURL = new ParsedURL(string);
        return ParsedURL.parseURL(parsedURL, string2);
    }

    public static ParsedURLData parseURL(ParsedURL parsedURL, String string) {
        String string2 = ParsedURL.getProtocol(string);
        if (string2 == null) {
            string2 = parsedURL.getProtocol();
        }
        ParsedURLProtocolHandler parsedURLProtocolHandler = ParsedURL.getHandler(string2);
        return parsedURLProtocolHandler.parseURL(parsedURL, string);
    }

    public static synchronized void registerHandler(ParsedURLProtocolHandler parsedURLProtocolHandler) {
        if (parsedURLProtocolHandler.getProtocolHandled() == null) {
            defaultHandler = parsedURLProtocolHandler;
            return;
        }
        Map map = ParsedURL.getHandlersMap();
        map.put(parsedURLProtocolHandler.getProtocolHandled(), parsedURLProtocolHandler);
    }

    public boolean sameFile(ParsedURL parsedURL) {
        return this.data.sameFile(parsedURL.data);
    }

    public static void setGlobalUserAgent(String string) {
        globalUserAgent = string;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public String toString() {
        return this.data.toString();
    }
}

