/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.application;

import com.l2fprod.common.application.OSXAdapter;
import com.l2fprod.common.application.core.AppContext;
import com.l2fprod.common.application.core.XmlUIBuilder;
import com.l2fprod.common.application.selection.Selection;
import com.l2fprod.common.application.selection.SelectionChangedEvent;
import com.l2fprod.common.application.selection.SelectionListener;
import com.l2fprod.common.swing.StatusBar;
import com.l2fprod.common.util.OS;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.io.IOException;
import java.net.URL;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Application
extends JFrame {
    private AppContext context;

    public Application() throws HeadlessException {
    }

    public Application(GraphicsConfiguration gc) {
        super(gc);
    }

    public Application(String title) throws HeadlessException {
        super(title);
    }

    public Application(String title, GraphicsConfiguration gc) {
        super(title, gc);
    }

    public AppContext getContext() {
        return this.context;
    }

    public void initialize(AppContext context) {
        this.context = context;
    }

    protected void defaultUIInit() {
        URL ui = this.getClass().getResource("ui.xml");
        if (ui != null) {
            try {
                StatusBar statusbar;
                XmlUIBuilder builder = new XmlUIBuilder(this.context, ui);
                JMenuBar menubar = builder.getMenubar("default");
                this.setJMenuBar(menubar);
                JToolBar toolbar = builder.getToolBar("default");
                if (toolbar != null) {
                    this.getContentPane().add("North", toolbar);
                }
                if ((statusbar = builder.getStatusBar("default")) != null) {
                    this.getContentPane().add("South", statusbar);
                    SelectionListener statusBarUpdater = new SelectionListener(){

                        public void selectionChanged(SelectionChangedEvent event) {
                            Selection selection = Application.this.context.getSelectionManager().getSelection();
                            JLabel message = (JLabel)statusbar.getZone("message");
                            message.setText(selection.isEmpty() ? "No Selection" : String.valueOf(selection.getSelection().length));
                        }
                    };
                    this.context.getSelectionManager().addSelectionListener(statusBarUpdater);
                }
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.initMacOSX();
    }

    protected void initMacOSX() {
        if (OS.isMacOSX()) {
            try {
                Action about = this.getContext().getActions().get("about");
                Action prefs = this.getContext().getActions().get("preferences");
                Action exit = this.getContext().getActions().get("exit");
                class ApplicationOSXAdapter
                extends OSXAdapter {
                    private final /* synthetic */ Action val$about;
                    private final /* synthetic */ Action val$prefs;
                    private final /* synthetic */ Action val$exit;

                    public ApplicationOSXAdapter(Action val$about, Action val$prefs, Action val$exit) throws Exception {
                        this.val$about = val$about;
                        this.val$prefs = val$prefs;
                        this.val$exit = val$exit;
                    }

                    protected void handleAbout() {
                        this.val$about.actionPerformed(null);
                    }

                    protected void handlePreferences() {
                        this.val$prefs.actionPerformed(null);
                    }

                    protected void handleQuit() {
                        this.val$exit.actionPerformed(null);
                    }
                }
                ApplicationOSXAdapter adapter = new ApplicationOSXAdapter(about, prefs, exit);
                adapter.setEnabledAboutMenu(true);
                adapter.setEnabledPreferencesMenu(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

