/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.application.core;

import com.l2fprod.common.application.core.AppContext;
import com.l2fprod.common.application.core.DefaultAction;
import com.l2fprod.common.swing.StatusBar;
import com.l2fprod.common.util.ResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlUIBuilder {
    public static final String ID = "id";
    public static final String ACTION = "action";
    public static final String ACTION_REF = "action-ref";
    public static final String TOOLBAR = "toolbar";
    public static final String MENUBAR = "menubar";
    public static final String MENU = "menu";
    public static final String MENU_REF = "menu-ref";
    public static final String STATUSBAR = "statusbar";
    public static final String STATUSBARITEM = "statusbaritem";
    public static final String SEPARATOR = "separator";
    private static final Logger logger = Logger.getLogger("XmlUIBuilder");
    private Map actions;
    private Map menus;
    private Map menubars;
    private Map toolbars;
    private Map statusbars;
    private AppContext context;

    public XmlUIBuilder(AppContext context, URL xml) throws ParserConfigurationException, SAXException, IOException {
        this.context = context;
        this.actions = new HashMap();
        this.menus = new HashMap();
        this.menubars = new HashMap();
        this.toolbars = new HashMap();
        this.statusbars = new HashMap();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        Handler handler = new Handler();
        parser.parse(xml.openStream(), (DefaultHandler)handler);
    }

    public JMenuBar getMenubar(String id) {
        JMenuBar menubar = (JMenuBar)this.menubars.get(id);
        return menubar;
    }

    public JMenu getMenu(String id) {
        JMenu menu = (JMenu)this.menus.get(id);
        return menu;
    }

    public JToolBar getToolBar(String id) {
        JToolBar toolbar = (JToolBar)this.toolbars.get(id);
        return toolbar;
    }

    public StatusBar getStatusBar(String id) {
        StatusBar status = (StatusBar)this.statusbars.get(id);
        return status;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("actions={");
        Iterator iter = this.actions.values().iterator();
        while (iter.hasNext()) {
            DefaultAction action = (DefaultAction)iter.next();
            buffer.append(action.toString());
            if (!iter.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append("},");
        buffer.append("menus={");
        iter = this.menus.values().iterator();
        while (iter.hasNext()) {
            JMenu menu = (JMenu)iter.next();
            buffer.append(menu.toString());
            if (!iter.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append("}");
        return buffer.toString();
    }

    private String getResource(String text) {
        try {
            return ResourceManager.resolve(text);
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
            return text;
        }
    }

    private void applyAttributes(JMenu menu, Attributes attributes) {
        menu.setText(this.getResource(attributes.getValue("text")));
        String mnemonic = this.getResource(attributes.getValue("mnemonic"));
        if (mnemonic != null && mnemonic.length() > 0) {
            menu.setMnemonic(mnemonic.charAt(0));
        }
    }

    private void applyAttributes(DefaultAction action, Attributes attributes) {
        String accel;
        action.setId(attributes.getValue(ID));
        action.setText(this.getResource(attributes.getValue("text")));
        String mnemonic = this.getResource(attributes.getValue("mnemonic"));
        if (mnemonic != null && mnemonic.length() > 0) {
            action.setMnemonic(mnemonic.charAt(0));
        }
        action.setCommand(attributes.getValue("command"));
        String objectClass = attributes.getValue("objectType");
        if (objectClass != null && objectClass.length() > 0) {
            action.setObjectType(objectClass);
        }
        action.setEnablesFor(attributes.getValue("enablesFor"));
        String icon = attributes.getValue("icon");
        if (icon != null && icon.length() > 0) {
            URL url = this.getClass().getResource(icon);
            if (url == null) {
                System.out.println("icon " + icon + " not found");
            } else {
                action.setSmallIcon(new ImageIcon(url));
            }
        }
        if ((accel = attributes.getValue("accelerator")) != null && accel.length() > 0) {
            action.setAccelerator(accel);
        }
    }

    private void addMenuToContainer(String menuId, Container parent) {
        logger.info("adding " + menuId + " to " + parent);
        JMenu menu = (JMenu)this.menus.get(menuId);
        parent.add(menu);
    }

    private void addActionToContainer(String actionId, Container parent) {
        DefaultAction action = (DefaultAction)this.actions.get(actionId);
        if (parent instanceof JMenu) {
            JMenuItem item = ((JMenu)parent).add(action);
            item.setMnemonic(action.getMnemonic());
        } else if (parent instanceof JToolBar) {
            ((JToolBar)parent).add(action);
        }
    }

    private void addComponentToContainer(Component component, Container parent) {
        parent.add(component);
    }

    static /* synthetic */ void access$700(XmlUIBuilder x0, String x1, Container x2) {
        x0.addMenuToContainer(x1, x2);
    }

    static /* synthetic */ void access$1100(XmlUIBuilder x0, String x1, Container x2) {
        x0.addActionToContainer(x1, x2);
    }

    static /* synthetic */ void access$1200(XmlUIBuilder x0, Component x1, Container x2) {
        x0.addComponentToContainer(x1, x2);
    }

    static {
        logger.setLevel(Level.ALL);
    }

    class Handler
    extends DefaultHandler {
        Stack containerStack;
        List doItLaters;

        Handler() {
        }

        public void startDocument() {
            this.containerStack = new Stack();
            this.doItLaters = new ArrayList();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            logger.entering(this.getClass().getName(), "startElement");
            try {
                if (XmlUIBuilder.MENUBAR.equals(qName)) {
                    logger.info("menubar(" + attributes.getValue(XmlUIBuilder.ID) + ")");
                    JMenuBar menubar = new JMenuBar();
                    XmlUIBuilder.this.menubars.put(attributes.getValue(XmlUIBuilder.ID), menubar);
                    this.containerStack.push(menubar);
                } else if (XmlUIBuilder.TOOLBAR.equals(qName)) {
                    logger.info("toolbar(" + attributes.getValue(XmlUIBuilder.ID) + ")");
                    JToolBar toolbar = new JToolBar();
                    toolbar.setFloatable("true".equals(attributes.getValue("floatable")));
                    XmlUIBuilder.this.toolbars.put(attributes.getValue(XmlUIBuilder.ID), toolbar);
                    this.containerStack.push(toolbar);
                } else if (XmlUIBuilder.STATUSBAR.equals(qName)) {
                    logger.info("statusbar(" + attributes.getValue(XmlUIBuilder.ID) + ")");
                    StatusBar statusbar = new StatusBar();
                    XmlUIBuilder.this.statusbars.put(attributes.getValue(XmlUIBuilder.ID), statusbar);
                    this.containerStack.push(statusbar);
                } else if (XmlUIBuilder.STATUSBARITEM.equals(qName)) {
                    logger.info("statusbaritem(" + attributes.getValue(XmlUIBuilder.ID) + ")");
                    String componentClass = attributes.getValue("classname");
                    String constraint = attributes.getValue("constraint");
                    Component zone = (Component)Class.forName(componentClass).newInstance();
                    StatusBar container = (StatusBar)this.containerStack.peek();
                    container.addZone(attributes.getValue(XmlUIBuilder.ID), zone, constraint);
                } else if (XmlUIBuilder.MENU.equals(qName)) {
                    logger.info("menu(" + attributes.getValue(XmlUIBuilder.ID) + ")");
                    JMenu menu = new JMenu();
                    XmlUIBuilder.this.applyAttributes(menu, attributes);
                    XmlUIBuilder.this.menus.put(attributes.getValue(XmlUIBuilder.ID), menu);
                    this.containerStack.push(menu);
                } else if (XmlUIBuilder.MENU_REF.equals(qName)) {
                    logger.info("menu-ref(" + attributes.getValue("idref") + ")");
                    Container container = (Container)this.containerStack.peek();
                    String idref = attributes.getValue("idref");
                    Runnable doItLater = new Runnable(this, idref, container){
                        private final /* synthetic */ String val$idref;
                        private final /* synthetic */ Container val$container;
                        private final /* synthetic */ Handler this$1;
                        {
                            this.this$1 = this$1;
                            this.val$idref = val$idref;
                            this.val$container = val$container;
                        }

                        public void run() {
                            XmlUIBuilder.access$700(Handler.access$600(this.this$1), this.val$idref, this.val$container);
                        }
                    };
                    this.doItLaters.add(doItLater);
                } else if (XmlUIBuilder.ACTION.equals(qName)) {
                    DefaultAction action = new DefaultAction();
                    XmlUIBuilder.this.applyAttributes(action, attributes);
                    XmlUIBuilder.this.actions.put(action.getId(), action);
                    XmlUIBuilder.this.context.getActions().add(action);
                } else if (XmlUIBuilder.ACTION_REF.equals(qName)) {
                    Container container = (Container)this.containerStack.peek();
                    String idref = attributes.getValue("idref");
                    Runnable doItLater = new Runnable(this, idref, container){
                        private final /* synthetic */ String val$idref;
                        private final /* synthetic */ Container val$container;
                        private final /* synthetic */ Handler this$1;
                        {
                            this.this$1 = this$1;
                            this.val$idref = val$idref;
                            this.val$container = val$container;
                        }

                        public void run() {
                            XmlUIBuilder.access$1100(Handler.access$600(this.this$1), this.val$idref, this.val$container);
                        }
                    };
                    this.doItLaters.add(doItLater);
                } else if (XmlUIBuilder.SEPARATOR.equals(qName)) {
                    Container container = (Container)this.containerStack.peek();
                    Runnable doItLater = new Runnable(this, container){
                        private final /* synthetic */ Container val$container;
                        private final /* synthetic */ Handler this$1;
                        {
                            this.this$1 = this$1;
                            this.val$container = val$container;
                        }

                        public void run() {
                            XmlUIBuilder.access$1200(Handler.access$600(this.this$1), new JSeparator(), this.val$container);
                        }
                    };
                    this.doItLaters.add(doItLater);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SAXException(e);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (XmlUIBuilder.MENUBAR.equals(qName) || XmlUIBuilder.MENU.equals(qName) || XmlUIBuilder.TOOLBAR.equals(qName) || XmlUIBuilder.STATUSBAR.equals(qName)) {
                this.containerStack.pop();
            }
        }

        public void endDocument() throws SAXException {
            try {
                super.endDocument();
                Iterator iter = this.doItLaters.iterator();
                while (iter.hasNext()) {
                    Runnable runnable = (Runnable)iter.next();
                    runnable.run();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SAXException(e);
            }
        }

        public void error(SAXParseException e) {
            this.report(e);
        }

        public void fatalError(SAXParseException e) {
            this.report(e);
        }

        public void warning(SAXParseException e) {
            this.report(e);
        }

        private void report(SAXException e) {
            e.getCause().printStackTrace();
        }

        static /* synthetic */ XmlUIBuilder access$600(Handler x0) {
            return x0.XmlUIBuilder.this;
        }
    }
}

