/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.application.document;

import com.l2fprod.common.application.document.Workspace;
import com.l2fprod.common.application.document.WorkspaceDocument;
import com.l2fprod.common.application.document.WorkspaceDocumentListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import javax.swing.event.EventListenerList;

public class AbstractWorkspaceDocument
implements WorkspaceDocument {
    private static final int OPENED = 0;
    private static final int ACTIVATED = 1;
    private static final int DEACTIVATED = 2;
    private static final int CLOSING = 3;
    private static final int CLOSED = 4;
    private boolean closed = true;
    private boolean selected = false;
    private String title;
    private Workspace workspace;
    protected EventListenerList listeners = new EventListenerList();
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected VetoableChangeSupport vetoSupport = new VetoableChangeSupport(this);
    static /* synthetic */ Class class$com$l2fprod$common$application$document$WorkspaceDocumentListener;

    public void addDocumentListener(WorkspaceDocumentListener listener) {
        this.listeners.add(class$com$l2fprod$common$application$document$WorkspaceDocumentListener == null ? (class$com$l2fprod$common$application$document$WorkspaceDocumentListener = AbstractWorkspaceDocument.class$("com.l2fprod.common.application.document.WorkspaceDocumentListener")) : class$com$l2fprod$common$application$document$WorkspaceDocumentListener, listener);
    }

    public void removeDocumentListener(WorkspaceDocumentListener listener) {
        this.listeners.remove(class$com$l2fprod$common$application$document$WorkspaceDocumentListener == null ? (class$com$l2fprod$common$application$document$WorkspaceDocumentListener = AbstractWorkspaceDocument.class$("com.l2fprod.common.application.document.WorkspaceDocumentListener")) : class$com$l2fprod$common$application$document$WorkspaceDocumentListener, listener);
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        if (this.workspace != null) {
            throw new IllegalArgumentException("document is already in a workspace");
        }
        this.workspace = workspace;
    }

    public void setClosed(boolean closed) throws PropertyVetoException {
        if (this.closed == closed) {
            return;
        }
        boolean old = this.closed;
        if (closed) {
            this.vetoSupport.fireVetoableChange("closed", old, closed);
            this.fireEvent(3);
            this.closed = true;
            this.fireEvent(4);
            this.workspace = null;
        } else {
            this.closed = false;
            this.fireEvent(0);
        }
        this.support.firePropertyChange("closed", old, closed);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setSelected(boolean selected) throws PropertyVetoException {
        if (this.selected == selected) {
            return;
        }
        boolean old = this.selected;
        if (selected) {
            this.selected = true;
            this.fireEvent(1);
        } else {
            this.vetoSupport.fireVetoableChange("selected", old, selected);
            this.selected = false;
            this.fireEvent(2);
        }
        this.support.firePropertyChange("selected", old, selected);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void save() {
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String old = this.title;
        this.title = title;
        this.support.firePropertyChange("title", old, title);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoSupport.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoSupport.removeVetoableChangeListener(listener);
    }

    private void fireEvent(int event) {
        WorkspaceDocumentListener[] wdl = (WorkspaceDocumentListener[])this.listeners.getListeners(class$com$l2fprod$common$application$document$WorkspaceDocumentListener == null ? (class$com$l2fprod$common$application$document$WorkspaceDocumentListener = AbstractWorkspaceDocument.class$("com.l2fprod.common.application.document.WorkspaceDocumentListener")) : class$com$l2fprod$common$application$document$WorkspaceDocumentListener);
        int c = wdl.length;
        block7: for (int i = 0; i < c; ++i) {
            switch (event) {
                case 0: {
                    wdl[i].documentOpened(this);
                    continue block7;
                }
                case 1: {
                    wdl[i].documentActivated(this);
                    continue block7;
                }
                case 2: {
                    wdl[i].documentDeactivated(this);
                    continue block7;
                }
                case 3: {
                    wdl[i].documentClosing(this);
                    continue block7;
                }
                case 4: {
                    wdl[i].documentClosed(this);
                }
            }
        }
    }

    public String toString() {
        return super.toString() + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        return "title=" + this.getTitle() + ",closed=" + this.isClosed();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

