/*
 * Decompiled with CFR 0.152.
 */
package net.janino.util;

import java.util.ArrayList;

public class StringPattern {
    public static final int INCLUDE = 0;
    public static final int EXCLUDE = 1;
    private final int mode;
    private final String pattern;

    public StringPattern(int n, String string) {
        this.mode = n;
        this.pattern = string;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean matches(String string) {
        return StringPattern.wildmatch(this.pattern, string);
    }

    public static boolean matches(StringPattern[] stringPatternArray, String string) {
        if (stringPatternArray != null) {
            int n = stringPatternArray.length - 1;
            while (n >= 0) {
                if (stringPatternArray[n].matches(string)) {
                    return stringPatternArray[n].getMode() == 0;
                }
                --n;
            }
        }
        return false;
    }

    public static StringPattern[] parseCombinedPattern(String string) {
        ArrayList<StringPattern> arrayList = new ArrayList<StringPattern>();
        int n = 0;
        while (n < string.length()) {
            int n2;
            char c = string.charAt(n);
            if (c == '+') {
                n2 = 0;
            } else if (c == '-') {
                n2 = 1;
                ++n;
            } else {
                n2 = 0;
            }
            int n3 = ++n;
            while (n3 < string.length()) {
                c = string.charAt(n3);
                if (c == '+' || c == '-') break;
                ++n3;
            }
            arrayList.add(new StringPattern(n2, string.substring(n, n3)));
            n = n3;
        }
        return arrayList.toArray(new StringPattern[arrayList.size()]);
    }

    public String toString() {
        return String.valueOf((char)(this.mode == 0 ? 43 : (this.mode == 1 ? 45 : 63))) + this.pattern;
    }

    private static boolean wildmatch(String string, String string2) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '?': {
                    if (n != string2.length()) break;
                    return false;
                }
                case '*': {
                    if (string.length() == n + 1) {
                        return true;
                    }
                    string = string.substring(n + 1);
                    while (n <= string2.length()) {
                        if (StringPattern.wildmatch(string, string2.substring(n))) {
                            return true;
                        }
                        ++n;
                    }
                    return false;
                }
                default: {
                    if (n == string2.length()) {
                        return false;
                    }
                    if (string2.charAt(n) == c) break;
                    return false;
                }
            }
            ++n;
        }
        return string2.length() == n;
    }
}

