/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.images;

import ch.abacus.lib.images.ImageLoader;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;

public class ImageUtils {
    protected static Hashtable mIconMap;
    protected static Icon mDefaultIcon;
    protected static FileSystemView mFileSystemView;

    protected static synchronized FileSystemView getFileSystemView() {
        if (mFileSystemView == null) {
            mFileSystemView = FileSystemView.getFileSystemView();
        }
        return mFileSystemView;
    }

    protected static synchronized Hashtable getIconMap() {
        if (mIconMap == null) {
            mIconMap = new Hashtable(2);
        }
        return mIconMap;
    }

    public static synchronized Icon getSystemIcon(String ending) {
        Hashtable map = ImageUtils.getIconMap();
        if (map.containsKey(ending)) {
            return (Icon)map.get(ending);
        }
        try {
            File dd = new File(System.getProperty("java.io.tmpdir"));
            if (!dd.exists()) {
                System.err.println("System Property: 'java.io.tmpdir' is not a valid directory");
                return ImageUtils.getDefaultIcon();
            }
            File f = new File(dd, "abacus_icon_tempfile." + ending);
            boolean exists = f.exists();
            if (!exists && !f.createNewFile()) {
                System.err.println("Creating file failed ... returning default icon.");
                return ImageUtils.getDefaultIcon();
            }
            Icon i = ImageUtils.getFileSystemView().getSystemIcon(f);
            if (i != null) {
                map.put(ending, i);
            }
            if (!exists) {
                f.delete();
            }
            return i;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ImageUtils.getDefaultIcon();
        }
    }

    public static synchronized Icon getDefaultIcon() {
        if (mDefaultIcon == null) {
            mDefaultIcon = ImageLoader.getImageIcon("glp_new.png");
        }
        return mDefaultIcon;
    }
}

