/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.plaf;

import java.awt.Color;
import java.awt.SystemColor;
import javax.swing.plaf.ColorUIResource;

public class AbacusTheme {
    public static final ColorUIResource white = new ColorUIResource(255, 255, 255);
    public static final ColorUIResource black = new ColorUIResource(0, 0, 0);
    public static final ColorUIResource maroon = new ColorUIResource(128, 0, 0);
    public static final ColorUIResource green = new ColorUIResource(0, 128, 0);
    public static final ColorUIResource olive = new ColorUIResource(128, 128, 0);
    public static final ColorUIResource navy = new ColorUIResource(0, 0, 128);
    public static final ColorUIResource purple = new ColorUIResource(128, 0, 128);
    public static final ColorUIResource teal = new ColorUIResource(0, 128, 128);
    public static final ColorUIResource gray = new ColorUIResource(128, 128, 128);
    public static final ColorUIResource silver = new ColorUIResource(192, 192, 192);
    public static final ColorUIResource red = new ColorUIResource(255, 0, 0);
    public static final ColorUIResource lime = new ColorUIResource(0, 255, 0);
    public static final ColorUIResource yellow = new ColorUIResource(255, 255, 0);
    public static final ColorUIResource blue = new ColorUIResource(0, 0, 255);
    public static final ColorUIResource fuchsia = new ColorUIResource(255, 0, 255);
    public static final ColorUIResource aqua = new ColorUIResource(0, 255, 255);
    public static final ColorUIResource lightGray = new ColorUIResource(192, 192, 192);
    public static final ColorUIResource darkGray = new ColorUIResource(128, 128, 128);
    public static final ColorUIResource btnFace = new ColorUIResource(SystemColor.control.getRGB());
    public static final ColorUIResource btnShadow = new ColorUIResource(SystemColor.controlShadow.getRGB());
    public static final ColorUIResource highLight = new ColorUIResource(SystemColor.textHighlight.getRGB());
    public static final ColorUIResource menuText = new ColorUIResource(SystemColor.menuText.getRGB());
    public static final ColorUIResource entryLinkColor = new ColorUIResource(128);
    public static final ColorUIResource inactiveCaption = darkGray;
    private static final ColorUIResource colGroupFill = new ColorUIResource(181, 190, 215);
    private static final ColorUIResource colGroupBorder = new ColorUIResource(139, 146, 226);
    private static final ColorUIResource colGroupFont = black;
    private static final ColorUIResource colGroupFillFooter = silver;
    private static final ColorUIResource colGroupBorderFooter = gray;
    private static final ColorUIResource colGroupFontFooter = navy;
    private static final ColorUIResource xpBaseSelectColor = highLight;
    private static ColorUIResource xpColor = btnFace;
    private static ColorUIResource xpIconBackColor = btnFace;
    private static ColorUIResource xpMenuBarColor = btnFace;
    private static ColorUIResource xpSelectColor = highLight;
    private static ColorUIResource xpSelectBorderColor = highLight;
    private static ColorUIResource xpSelectFontColor = menuText;
    private static ColorUIResource xpDisabledColor = inactiveCaption;
    private static ColorUIResource xpSeparatorColor = btnFace;
    private static ColorUIResource xpCheckedColor = highLight;
    private static ColorUIResource xpGridZebraColor = new ColorUIResource(new Color(14806271));
    private static ColorUIResource xpToolBarBGColor;
    public static final ColorUIResource window;
    public static final ColorUIResource windowText;
    private static ColorUIResource xpButtonUpLeftCorner;
    private static ColorUIResource xpBorderHovered;
    private static ColorUIResource xpBorderFocused;
    private static ColorUIResource xpBorderNormal;
    private static ColorUIResource xpFillNormal;
    private static ColorUIResource xpFillFocused;
    private static ColorUIResource xpFillHovered;
    private static ColorUIResource xpFillDown;
    private static ColorUIResource xpMenuBorderColor;
    private static ColorUIResource xpMenuShadowColor;
    private static ColorUIResource xpCheckedAreaColor;
    private static ColorUIResource xpCheckedAreaSelectColor;
    private static ColorUIResource xpToolButtonBGColor;
    private static ColorUIResource xpCatalogBGColor;
    private static ColorUIResource xpArrowNormal;
    private static ColorUIResource xpArrowDown;
    private static ColorUIResource xpArrowDisabled;
    private static boolean colorsInitialized;

    public AbacusTheme() {
        AbacusTheme.initColors();
    }

    private static void initColors() {
        if (!colorsInitialized) {
            xpArrowDown = white;
            xpArrowNormal = black;
            xpArrowDisabled = white;
            xpSelectColor = AbacusTheme.lightColor(xpSelectColor, 68);
            xpCheckedAreaColor = AbacusTheme.lightColor(xpSelectColor, 80);
            xpCheckedAreaSelectColor = AbacusTheme.lightColor(xpSelectColor, 50);
            xpMenuBorderColor = AbacusTheme.shadeColor(btnFace, 90);
            xpMenuShadowColor = AbacusTheme.shadeColor(btnFace, 76);
            xpButtonUpLeftCorner = AbacusTheme.lightColor(btnShadow, 30);
            xpDisabledColor = btnShadow;
            xpBorderFocused = AbacusTheme.lightColor(xpSelectBorderColor, 60);
            xpBorderNormal = AbacusTheme.shadeColor(btnFace, 60);
            xpBorderHovered = AbacusTheme.shadeColor(xpBorderFocused, 30);
            xpFillNormal = btnFace;
            xpFillDown = AbacusTheme.shadeColor(xpBorderFocused, 15);
            xpFillFocused = AbacusTheme.lightColor(xpBorderFocused, 50);
            xpFillHovered = AbacusTheme.lightColor(xpBorderNormal, 90);
            xpToolButtonBGColor = AbacusTheme.shadeColor(xpIconBackColor, 15);
            xpToolBarBGColor = AbacusTheme.lightColor(xpIconBackColor, 30);
            xpCatalogBGColor = AbacusTheme.lightColor(xpFillNormal, 40);
            colorsInitialized = true;
        }
    }

    private static int lightColorValue(int colorValue, int percent) {
        int t = (255 - colorValue) * percent;
        t = t % 100 >= 50 ? t / 100 + 1 : (t /= 100);
        return colorValue + t;
    }

    private static ColorUIResource lightColor(ColorUIResource color, int percent) {
        if (percent <= 0) {
            return color;
        }
        if (percent > 100) {
            percent = 100;
        }
        return new ColorUIResource(AbacusTheme.lightColorValue(color.getRed(), percent), AbacusTheme.lightColorValue(color.getGreen(), percent), AbacusTheme.lightColorValue(color.getBlue(), percent));
    }

    private static int trimColor(int colorValue, int trimValue) {
        if ((colorValue -= trimValue) < 0) {
            return 0;
        }
        if (colorValue > 255) {
            return 255;
        }
        return colorValue;
    }

    private static ColorUIResource shadeColor(ColorUIResource color, int colorValue) {
        return new ColorUIResource(AbacusTheme.trimColor(color.getRed(), colorValue), AbacusTheme.trimColor(color.getGreen() + 2, colorValue), AbacusTheme.trimColor(color.getBlue(), colorValue));
    }

    public ColorUIResource getAqua() {
        return aqua;
    }

    public ColorUIResource getBlack() {
        return black;
    }

    public ColorUIResource getBlue() {
        return blue;
    }

    public ColorUIResource getBtnFace() {
        return btnFace;
    }

    public ColorUIResource getBtnShadow() {
        return btnShadow;
    }

    public ColorUIResource getColGroupBorder() {
        return colGroupBorder;
    }

    public ColorUIResource getColGroupBorderFooter() {
        return colGroupBorderFooter;
    }

    public ColorUIResource getColGroupFill() {
        return colGroupFill;
    }

    public ColorUIResource getColGroupFillFooter() {
        return colGroupFillFooter;
    }

    public ColorUIResource getColGroupFont() {
        return colGroupFont;
    }

    public ColorUIResource getColGroupFontFooter() {
        return colGroupFontFooter;
    }

    public boolean isColorsInitialized() {
        return colorsInitialized;
    }

    public ColorUIResource getDarkGray() {
        return darkGray;
    }

    public ColorUIResource getFuchsia() {
        return fuchsia;
    }

    public ColorUIResource getGray() {
        return gray;
    }

    public ColorUIResource getGreen() {
        return green;
    }

    public ColorUIResource getHighLight() {
        return highLight;
    }

    public ColorUIResource getInactiveCaption() {
        return inactiveCaption;
    }

    public ColorUIResource getLightGray() {
        return lightGray;
    }

    public ColorUIResource getLime() {
        return lime;
    }

    public ColorUIResource getMaroon() {
        return maroon;
    }

    public ColorUIResource getMenuText() {
        return menuText;
    }

    public ColorUIResource getNavy() {
        return navy;
    }

    public ColorUIResource getOlive() {
        return olive;
    }

    public ColorUIResource getPurple() {
        return purple;
    }

    public ColorUIResource getRed() {
        return red;
    }

    public ColorUIResource getSilver() {
        return silver;
    }

    public ColorUIResource getTeal() {
        return teal;
    }

    public ColorUIResource getWhite() {
        return white;
    }

    public ColorUIResource getArrowDisabled() {
        return xpArrowDisabled;
    }

    public ColorUIResource getArrowDown() {
        return xpArrowDown;
    }

    public ColorUIResource getArrowNormal() {
        return xpArrowNormal;
    }

    public ColorUIResource getBaseSelectColor() {
        return xpBaseSelectColor;
    }

    public ColorUIResource getBorderFocused() {
        return xpBorderFocused;
    }

    public ColorUIResource getBorderHovered() {
        return xpBorderHovered;
    }

    public ColorUIResource getBorderNormal() {
        return xpBorderNormal;
    }

    public ColorUIResource getButtonUpLeftCorner() {
        return xpButtonUpLeftCorner;
    }

    public ColorUIResource getCheckedAreaColor() {
        return xpCheckedAreaColor;
    }

    public ColorUIResource getCheckedAreaSelectColor() {
        return xpCheckedAreaSelectColor;
    }

    public ColorUIResource getCheckedColor() {
        return xpCheckedColor;
    }

    public ColorUIResource getColor() {
        return xpColor;
    }

    public ColorUIResource getDisabledColor() {
        return xpDisabledColor;
    }

    public ColorUIResource getFillDown() {
        return xpFillDown;
    }

    public ColorUIResource getFillFocused() {
        return xpFillFocused;
    }

    public ColorUIResource getFillHovered() {
        return xpFillHovered;
    }

    public ColorUIResource getFillNormal() {
        return xpFillNormal;
    }

    public ColorUIResource getIconBackColor() {
        return xpIconBackColor;
    }

    public ColorUIResource getMenuBarColor() {
        return xpMenuBarColor;
    }

    public ColorUIResource getMenuBorderColor() {
        return xpMenuBorderColor;
    }

    public ColorUIResource getMenuShadowColor() {
        return xpMenuShadowColor;
    }

    public ColorUIResource getSelectBorderColor() {
        return xpSelectBorderColor;
    }

    public ColorUIResource getSelectColor() {
        return xpSelectColor;
    }

    public ColorUIResource getSelectFontColor() {
        return xpSelectFontColor;
    }

    public ColorUIResource getSeparatorColor() {
        return xpSeparatorColor;
    }

    public ColorUIResource getToolButtonBGColor() {
        return xpToolButtonBGColor;
    }

    public ColorUIResource getToolBarBGColor() {
        return xpToolBarBGColor;
    }

    public ColorUIResource getYellow() {
        return yellow;
    }

    public ColorUIResource getCatalogBGColor() {
        return xpCatalogBGColor;
    }

    public static ColorUIResource getGridZebraColor() {
        return xpGridZebraColor;
    }

    static {
        window = new ColorUIResource(SystemColor.window);
        windowText = new ColorUIResource(SystemColor.windowText);
        colorsInitialized = false;
    }
}

