/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.propertyinspector.display;

import ch.abacus.lib.ui.JATable;
import ch.abacus.lib.ui.propertyinspector.core.AccessorInterface;
import ch.abacus.lib.ui.propertyinspector.core.Clazz;
import ch.abacus.lib.ui.propertyinspector.core.Clazzes;
import ch.abacus.lib.ui.propertyinspector.core.Group;
import ch.abacus.lib.ui.propertyinspector.core.GroupEditorInterface;
import ch.abacus.lib.ui.propertyinspector.core.Property;
import ch.abacus.lib.ui.propertyinspector.core.SelectionList;
import ch.abacus.lib.ui.propertyinspector.display.DependenciesInterface;
import ch.abacus.lib.ui.propertyinspector.display.DisplayGroup;
import ch.abacus.lib.ui.propertyinspector.display.DisplayProperties;
import ch.abacus.lib.ui.propertyinspector.display.DisplayProperty;
import ch.abacus.lib.ui.propertyinspector.display.ObjectInstance;
import ch.abacus.lib.ui.propertyinspector.display.PropertyDefinitionInterface;
import ch.abacus.lib.ui.propertyinspector.display.PropertyInspector;
import ch.abacus.lib.ui.propertyinspector.display.TableEventInterface;
import ch.abacus.lib.ui.propertyinspector.display.editor.PropertyInspectorCellEditor;
import ch.abacus.lib.ui.propertyinspector.display.renderer.PropertyInspectorCellRenderer;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyModel
extends AbstractTableModel {
    private ArrayList displayProperties = new ArrayList();
    private boolean updating = true;
    private PropertyInspector propertyInspector;
    private Clazzes clazzes = new Clazzes();
    private SelectionList selection = new SelectionList();
    private AccessorInterface accessor;
    private DependenciesInterface dependencyChecker;
    private PropertyDefinitionInterface propertyDefinition;
    private DisplayProperties visibleProperties;
    private JATable table;
    private boolean sortAlphabetically;
    private boolean grouped;
    private Property defaultProperty;
    private PropertyInspectorCellRenderer properyInspectorRenderer;
    private PropertyInspectorCellEditor propertyInspectorCellEditor;
    private TableEventInterface tableEvent;
    private KeyAdapter tableKeyAdapter = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            if (!PropertyModel.this.table.isEditing()) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    PropertyModel.this.editCurrentRow();
                }
            } else {
                PropertyModel.this.table.endEditing();
            }
        }
    };
    private MouseAdapter mouseAdapter = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            Object value;
            Point p = e.getPoint();
            int row = PropertyModel.this.table.rowAtPoint(p);
            if (row != -1 && (value = PropertyModel.this.getValueAt(row, 0)) instanceof DisplayGroup) {
                TableColumn column = PropertyModel.this.table.getColumnModel().getColumn(0);
                int width = column.getWidth();
                column = PropertyModel.this.table.getColumnModel().getColumn(1);
                DisplayGroup group = (DisplayGroup)value;
                if (p.x > (width += column.getWidth()) - 16 && p.x < width && group.getGroup().getEditor() != null) {
                    GroupEditorInterface editor = group.getGroup().getEditor();
                    editor.edit(e, group.getGroup());
                } else {
                    group.getGroup().setFolded(!group.getGroup().isFolded());
                    PropertyModel.this.changeSelection();
                }
            }
            if (PropertyModel.this.tableEvent != null) {
                PropertyModel.this.tableEvent.propertySelectionChanged(PropertyModel.this.table.getSelectedRow());
            }
        }
    };

    PropertyModel(PropertyInspector propertyInspector, JATable table) {
        this.table = table;
        this.grouped = true;
        this.sortAlphabetically = false;
        this.propertyInspector = propertyInspector;
    }

    public TableEventInterface getTableEvent() {
        return this.tableEvent;
    }

    public void setTableEvent(TableEventInterface tableEvent) {
        this.tableEvent = tableEvent;
    }

    public HashMap<String, String> getLanguageStrings() {
        return this.propertyInspector.getLanguageStrings();
    }

    public boolean isSortAlphabetically() {
        return this.sortAlphabetically;
    }

    public void setSortAlphabetically(boolean sortAlphabetically) {
        if (sortAlphabetically == this.sortAlphabetically) {
            return;
        }
        this.sortAlphabetically = sortAlphabetically;
        this.changeSelection();
    }

    public boolean isGrouped() {
        return this.grouped;
    }

    public void setGrouped(boolean grouped) {
        if (grouped == this.grouped) {
            return;
        }
        this.grouped = grouped;
        this.changeSelection();
    }

    public Property getDefaultProperty() {
        return this.defaultProperty;
    }

    public void setDefaultProperty(Property defaultProperty) {
        this.defaultProperty = defaultProperty;
    }

    public void refreshProperty(Property property) {
        for (int i = 0; i < this.displayProperties.size(); ++i) {
            Object display = this.displayProperties.get(i);
            if (!(display instanceof DisplayProperty) || ((DisplayProperty)display).getProperty() != property) continue;
            ((DisplayProperty)display).getValues().clear();
            for (int a = 0; a < this.selection.size(); ++a) {
                ((DisplayProperty)display).getValues().add(this.accessor.getValue(property, (ObjectInstance)this.selection.get(a)));
            }
            Rectangle rect = this.table.getCellRect(i, 1, true);
            this.table.repaint(rect);
            break;
        }
    }

    public void initialize() {
        this.properyInspectorRenderer = new PropertyInspectorCellRenderer(this.table);
        this.propertyInspectorCellEditor = new PropertyInspectorCellEditor(this.table);
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(0).setCellRenderer(this.properyInspectorRenderer);
        columnModel.getColumn(1).setCellRenderer(this.properyInspectorRenderer);
        columnModel.getColumn(1).setCellEditor(this.propertyInspectorCellEditor);
        this.table.addMouseListener(this.mouseAdapter);
        this.table.addKeyListener(this.tableKeyAdapter);
        this.table.setFocusCycleRoot(true);
        this.table.setFocusTraversalKeysEnabled(false);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.displayProperties.size();
    }

    public AccessorInterface getAccessor() {
        return this.accessor;
    }

    public void setAccessor(AccessorInterface accessor) {
        this.accessor = accessor;
    }

    public PropertyDefinitionInterface getPropertyDefinition() {
        return this.propertyDefinition;
    }

    public void setPropertyDefinition(PropertyDefinitionInterface propertyDefinition) {
        this.propertyDefinition = propertyDefinition;
    }

    public DependenciesInterface getDependencyChecker() {
        return this.dependencyChecker;
    }

    public void setDependencyChecker(DependenciesInterface dependencyChecker) {
        this.dependencyChecker = dependencyChecker;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.displayProperties.get(rowIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean ok;
        Object object = this.displayProperties.get(rowIndex);
        if (object instanceof DisplayGroup) {
            return false;
        }
        boolean bl = ok = columnIndex > 0;
        if (object instanceof DisplayProperty) {
            DisplayProperty p = (DisplayProperty)object;
            ok = ok && !p.getProperty().isReadOnly();
            ok = ok && (!p.getProperty().isSingleSelection() || this.selection.size() <= 1);
            ok = ok && p.getProperty().getEditor() != null;
            ok = ok && p.isEnabled();
        }
        return ok;
    }

    public void editCurrentRow() {
        int row = this.table.getSelectedRow();
        if (row != -1) {
            this.editRow(row);
        }
    }

    private int getNearestRow() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            for (int i = 0; i < this.displayProperties.size(); ++i) {
                if (!(this.displayProperties.get(i) instanceof DisplayProperty) || ((DisplayProperty)this.displayProperties.get(i)).getProperty() != this.defaultProperty) continue;
                return i;
            }
        }
        if (this.displayProperties.size() > 0) {
            return 0;
        }
        return -1;
    }

    public void editAnyRow() {
        int row = this.getNearestRow();
        if (row != -1) {
            this.editRow(row);
        }
    }

    public void editRow(int row) {
        this.table.editCellAt(row, 1);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Component c = PropertyModel.this.table.getEditorComponent();
                if (c != null) {
                    c.requestFocus();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(Object[] objects) {
        if (this.table.isEditing()) {
            this.table.endEditing();
        }
        this.selection.clear();
        this.beginUpdate();
        try {
            for (int i = 0; i < objects.length; ++i) {
                this.addSelection(objects[i]);
            }
            this.changeSelection();
        }
        finally {
            this.endUpdate();
        }
    }

    private void addPropertiesToSelection(DisplayProperties selection, ObjectInstance instance, Clazz clazz) {
        for (int i = 0; i < clazz.getProperties().size(); ++i) {
            Property property = clazz.getProperties().get(i);
            DisplayProperty p = selection.findByProperty(property, true);
            p.getValues().add(this.accessor.getValue(property, instance));
        }
    }

    protected Clazz findClazzFromInstance(Clazzes clazzes, ObjectInstance instance) {
        if (instance.getClassName() != null) {
            return clazzes.findByInstance(instance.getClassName());
        }
        return clazzes.findByInstance(instance.getObject());
    }

    public void changeSelection() {
        int i;
        if (!this.updating || this.displayProperties.size() == 0 && this.selection.size() == 0) {
            return;
        }
        this.visibleProperties = new DisplayProperties();
        for (int i2 = 0; i2 < this.selection.size(); ++i2) {
            ObjectInstance instance = (ObjectInstance)this.selection.get(i2);
            for (Clazz clazz = this.findClazzFromInstance(this.clazzes, instance); clazz != null; clazz = clazz.getParent()) {
                this.addPropertiesToSelection(this.visibleProperties, (ObjectInstance)this.selection.get(i2), clazz);
            }
        }
        if (this.propertyDefinition != null) {
            this.propertyDefinition.addPropertyDefinition(this.selection, this.visibleProperties);
        }
        for (int i3 = this.visibleProperties.size() - 1; i3 >= 0; --i3) {
            DisplayProperty p = this.visibleProperties.get(i3);
            if (p.getValues().size() == this.selection.size()) continue;
            this.visibleProperties.remove(p);
        }
        DisplayGroup root = new DisplayGroup(null);
        for (i = 0; i < this.visibleProperties.size(); ++i) {
            DisplayProperty p = this.visibleProperties.get(i);
            if (this.grouped) {
                Group group = p.getProperty().getGroup();
                ArrayList<Group> list = new ArrayList<Group>();
                if (group != null) {
                    do {
                        list.add(0, group);
                    } while ((group = group.getParent()) != null);
                }
                DisplayGroup displayGroup = root;
                DisplayGroup parent = root;
                for (int gg = 0; gg < list.size(); ++gg) {
                    group = (Group)list.get(gg);
                    if ((displayGroup = displayGroup.findByGroup(group)) == null) {
                        displayGroup = new DisplayGroup(group);
                        parent.getChildren().add(displayGroup);
                    }
                    if (gg == list.size() - 1) {
                        displayGroup.getProperties().add(p);
                    }
                    parent = displayGroup;
                }
                continue;
            }
            root.getProperties().add(p);
        }
        if (this.grouped) {
            root.getChildren().sort(this.sortAlphabetically);
            this.sortGroups(root);
        } else {
            root.getProperties().sort(this.sortAlphabetically);
        }
        this.displayProperties.clear();
        this.flattenDisplayGroups(root);
        if (this.dependencyChecker != null) {
            for (i = 0; i < this.visibleProperties.size(); ++i) {
                DisplayProperty p = this.visibleProperties.get(i);
                DisplayProperties dependencies = this.createDependencyListFor(p.getProperty());
                this.dependencyChecker.checkDependencies(p, p.getValues().getCurrentValue(), dependencies);
            }
        }
        this.fireTableDataChanged();
    }

    public DisplayProperties getVisibleProperties() {
        return this.visibleProperties;
    }

    private boolean isGroupVisible(Group group) {
        boolean ok = true;
        while (group != null) {
            ok &= !group.isFolded();
            group = group.getParent();
        }
        return ok;
    }

    private void sortGroups(DisplayGroup root) {
        root.getProperties().sort(this.sortAlphabetically);
        for (int i = 0; i < root.getChildren().size(); ++i) {
            this.sortGroups(root.getChildren().get(i));
        }
    }

    private void flattenDisplayGroups(DisplayGroup root) {
        int i;
        if (root.getGroup() != null && this.isGroupVisible(root.getGroup().getParent())) {
            this.displayProperties.add(root);
        }
        for (i = 0; i < root.getProperties().size(); ++i) {
            DisplayProperty property = root.getProperties().get(i);
            if (this.grouped && !this.isGroupVisible(property.getProperty().getGroup())) continue;
            this.displayProperties.add(root.getProperties().get(i));
        }
        for (i = 0; i < root.getChildren().size(); ++i) {
            this.flattenDisplayGroups(root.getChildren().get(i));
        }
    }

    public void beginUpdate() {
        this.updating = false;
    }

    public void endUpdate() {
        this.updating = true;
        this.changeSelection();
    }

    public void addSelection(String className, Object object) {
        this.selection.add(new ObjectInstance(className, object));
        this.changeSelection();
    }

    public void addSelection(Object object) {
        this.addSelection(null, object);
    }

    public Clazzes getClazzes() {
        return this.clazzes;
    }

    public ArrayList<ObjectInstance> getSelection() {
        return this.selection;
    }

    private DisplayProperties createDependencyListFor(Property property) {
        DisplayProperties dependencies = new DisplayProperties();
        for (int a = 0; a < property.getDependencies().size(); ++a) {
            Property dependency = property.getDependencies().get(a);
            DisplayProperty dp = this.visibleProperties.findByProperty(dependency, false);
            if (dp == null) {
                dp = new DisplayProperty(dependency);
            }
            dp.setEnabled(true);
            dependencies.add(dp);
        }
        return dependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!((PropertyInspectorCellEditor)this.table.getCellEditor()).getCurrentEditor().isModified()) {
            return;
        }
        DisplayProperty displayProperty = (DisplayProperty)this.displayProperties.get(rowIndex);
        displayProperty.getValues().clear();
        Property property = displayProperty.getProperty();
        this.accessor.beginUpdate();
        try {
            for (int i = 0; i < this.selection.size(); ++i) {
                this.accessor.setValue(property, (ObjectInstance)this.selection.get(i), aValue);
                displayProperty.getValues().add(aValue);
                if (this.dependencyChecker != null && property.getDependencies().size() > 0) {
                    DisplayProperties dependencies = this.createDependencyListFor(property);
                    this.dependencyChecker.checkDependencies(displayProperty, aValue, dependencies);
                }
                this.fireTableDataChanged();
            }
        }
        finally {
            this.accessor.endUpdate();
        }
    }
}

