/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.propertyinspector.display.renderer;

import ch.abacus.lib.ui.BorderFactory;
import ch.abacus.lib.ui.propertyinspector.core.GroupEditorInterface;
import ch.abacus.lib.ui.propertyinspector.display.DisplayGroup;
import ch.abacus.lib.ui.propertyinspector.display.renderer.BaseCellRenderer;
import ch.abacus.lib.ui.propertyinspector.display.renderer.IconLabel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.border.Border;

public class CategoryCellRenderer
extends BaseCellRenderer {
    private Color textColor;
    private IconLabel label;
    private Border nullBorder;

    public CategoryCellRenderer(JTable table) {
        super(table);
        this.textColor = this.background.darker();
        this.label = new IconLabel();
        this.nullBorder = BorderFactory.createEmptyBorder();
        this.font = table.getFont().deriveFont(1);
    }

    public IconLabel getLabel() {
        return this.label;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.initialize(this.label, table, false, false, row, column);
        this.label.setBackground(this.background);
        this.label.setForeground(this.textColor);
        DisplayGroup displayGroup = (DisplayGroup)value;
        this.label.setToolTipText(displayGroup.getGroup().getHint());
        switch (column) {
            case 0: {
                this.label.setIcon(null);
                this.label.setText(displayGroup.getGroup().getName());
                this.label.setBorder(this.border);
                this.label.setFont(this.font);
                this.border.init(displayGroup);
                break;
            }
            case 1: {
                GroupEditorInterface editor = displayGroup.getGroup().getEditor();
                if (editor != null && editor.isVisible(displayGroup.getGroup())) {
                    this.label.setIcon(editor.getIcon());
                    this.label.setHint(editor.getHint());
                } else {
                    this.label.setIcon(null);
                    this.label.setHint(null);
                }
                this.label.setBorder(this.nullBorder);
                this.label.setText("");
            }
        }
        return this.label;
    }
}

