/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.abaRenderer;

import ch.abacus.lib.ui.renderer.abaRenderer.RendererFocusTraversalPolicy;
import ch.abacus.lib.ui.renderer.abaRenderer.RendererFocusTree;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import java.awt.Component;
import java.awt.Container;

public class RendererFocusNode {
    Object swingObject;
    RendererFocusNode previousSibling;
    RendererFocusNode nextSibling;
    RendererFocusNode parent;
    RendererFocusNode firstChild;
    RendererFocusNode lastChild;

    public RendererFocusNode(Object swingObject) {
        this.swingObject = swingObject;
        RendererFocusTree.addQuickAccess(this, swingObject);
    }

    public void addChildren(MetaObject theObject) {
        Container theContainer;
        if ((theObject.isFrame() || theObject.isPanel() || theObject.isAbalet() || theObject.isTabPage() || theObject.isGroup()) && (theContainer = (Container)theObject.getSwingObject()) != null) {
            theContainer.setFocusTraversalPolicy(RendererFocusTraversalPolicy.getInstance());
        }
        for (MetaObject theChild = theObject.theFirstChild; theChild != null; theChild = theChild.getNextObject()) {
            RendererFocusNode childNode = new RendererFocusNode(theChild.getSwingObject());
            this.addChildNode(childNode);
            childNode.addChildren(theChild);
        }
    }

    public void addChildNode(RendererFocusNode theNode) {
        if (this.firstChild == null) {
            this.firstChild = theNode;
        } else {
            theNode.previousSibling = this.lastChild;
            this.lastChild.nextSibling = theNode;
        }
        theNode.parent = this;
        this.lastChild = theNode;
    }

    public boolean isFocusable() {
        if (this.swingObject instanceof Component) {
            return ((Component)this.swingObject).isFocusable();
        }
        return false;
    }

    public boolean isEnabled() {
        if (this.swingObject instanceof Component) {
            return ((Component)this.swingObject).isEnabled();
        }
        return false;
    }

    public Component next() {
        if (this.nextSibling != null) {
            if (this.nextSibling.firstChild != null) {
                return this.nextSibling.first();
            }
            if (this.nextSibling.isFocusable() && this.nextSibling.isEnabled()) {
                return (Component)this.nextSibling.swingObject;
            }
            return this.nextSibling.next();
        }
        if (this.parent != null) {
            return this.parent.next();
        }
        return null;
    }

    public Component previous() {
        if (this.previousSibling != null) {
            if (this.previousSibling.lastChild != null) {
                return this.previousSibling.last();
            }
            if (this.previousSibling.isFocusable() && this.previousSibling.isEnabled()) {
                return (Component)this.previousSibling.swingObject;
            }
            return this.previousSibling.previous();
        }
        if (this.parent != null) {
            return this.parent.previous();
        }
        return null;
    }

    public Component first() {
        if (this.firstChild != null) {
            if (this.firstChild.firstChild != null) {
                return this.firstChild.first();
            }
            if (this.firstChild.isEnabled() && this.firstChild.isFocusable()) {
                return (Component)this.firstChild.swingObject;
            }
            return this.firstChild.next();
        }
        return null;
    }

    public Component last() {
        if (this.lastChild != null) {
            if (this.lastChild.lastChild != null) {
                return this.lastChild.last();
            }
            if (this.lastChild.isEnabled() && this.lastChild.isFocusable()) {
                return (Component)this.lastChild.swingObject;
            }
            return this.lastChild.previous();
        }
        return null;
    }
}

