/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.JAFrame;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;
import ch.abacus.lib.ui.renderer.common.HammerConsoleAboutBox;
import ch.abacus.lib.ui.renderer.common.HammerLogEditorMouseListener;
import ch.abacus.lib.ui.renderer.common.HammerLogEditorPopupMenu;
import ch.abacus.lib.ui.renderer.common.HammerLogFileFilter;
import ch.abacus.lib.ui.renderer.common.HammerLogFileView;
import ch.abacus.lib.ui.renderer.common.HammerLogOutputStream;
import ch.abacus.lib.ui.renderer.common.HammerLogSourceCaretListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class HammerLogConsole
extends JAFrame {
    public Thread theThread;
    public HammerLogConsole theLogFrame = this;
    protected JAScrollPane theLogPane = new JAScrollPane();
    protected JATextAreaX theLogTextOutputWindow = new JATextAreaX(this);
    protected JButton theResetLogButton = new JButton();
    protected JButton theSaveLogButton = new JButton();
    protected JButton thePrintLogButton = new JButton();
    protected HammerLogOutputStream theCreator = null;
    CutAction cutAction = null;
    CopyAction copyAction = null;
    PasteAction pasteAction = null;
    OpenAction openAction = null;
    SaveAction saveAction = null;
    SaveAsAction saveAsAction = null;
    NewAction newAction = null;
    CloseAction closeAction = null;
    AboutAction aboutAction = null;
    UndoAction undoAction = null;
    RedoAction redoAction = null;
    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu = new JMenu("File");
    JMenu editMenu = new JMenu("Edit");
    JMenu windowMenu = new JMenu("Window");
    JMenu helpMenu = new JMenu("Help");
    public AbstractAction lastClipboardBufferingAction = null;
    int iByteCount = 0;
    String sBuffer = new String("");

    public HammerLogConsole(HammerLogOutputStream theCreator) {
        this.theCreator = theCreator;
        this.theThread = Thread.currentThread();
        PrintStream saveErr = System.err;
        Container theContainer = this.getContentPane();
        JAPanel theMenuPanel = new JAPanel(false);
        theMenuPanel.setLayout(new GridLayout(2, 1));
        JAPanel theMainPanel = new JAPanel(false);
        AnchoringLayoutManager layoutManagertheLogFrame = new AnchoringLayoutManager();
        theMainPanel.setLayout(layoutManagertheLogFrame);
        this.setLocation(32, 192);
        this.setSize(520, 504);
        this.setTitle("Design Cockpit Log");
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.helpMenu);
        JToolBar toolBar = new JToolBar();
        String sImageDirectory = "";
        ImageIcon newIcon = new ImageIcon(sImageDirectory + "Glp_new.gif");
        ImageIcon openIcon = new ImageIcon(sImageDirectory + "Glp_open.gif");
        ImageIcon saveIcon = new ImageIcon(sImageDirectory + "Glp_save.gif");
        ImageIcon cutIcon = new ImageIcon(sImageDirectory + "Glp_cut.gif");
        ImageIcon copyIcon = new ImageIcon(sImageDirectory + "Glp_copy.gif");
        ImageIcon pasteIcon = new ImageIcon(sImageDirectory + "Glp_paste.gif");
        ImageIcon aboutIcon = new ImageIcon(sImageDirectory + "Glp_about.gif");
        ImageIcon undoIcon = new ImageIcon(sImageDirectory + "glp_Undo.gif");
        ImageIcon redoIcon = new ImageIcon(sImageDirectory + "glp_Redo.gif");
        toolBar.setMargin(new Insets(5, 5, 5, 5));
        toolBar.setFocusable(false);
        this.newAction = new NewAction("New", newIcon, this);
        this.closeAction = new CloseAction("Close", null, this);
        this.openAction = new OpenAction("Open", openIcon, this);
        this.saveAction = new SaveAction("Save", saveIcon, this);
        this.saveAsAction = new SaveAsAction("Save As", saveIcon, this);
        this.cutAction = new CutAction("Cut", cutIcon, this);
        this.copyAction = new CopyAction("Copy", copyIcon, this);
        this.pasteAction = new PasteAction("Paste", pasteIcon, this);
        this.aboutAction = new AboutAction("About", aboutIcon, this);
        this.undoAction = new UndoAction("Undo", undoIcon, this);
        this.redoAction = new RedoAction("Redo", redoIcon, this);
        toolBar.add(this.newAction);
        toolBar.add(this.openAction);
        toolBar.add(this.saveAction);
        toolBar.addSeparator();
        toolBar.add(this.cutAction);
        toolBar.add(this.copyAction);
        toolBar.add(this.pasteAction);
        toolBar.add(this.undoAction);
        toolBar.add(this.redoAction);
        this.fileMenu.add(this.newAction);
        this.fileMenu.add(this.openAction);
        this.fileMenu.add(this.saveAction);
        this.fileMenu.add(this.saveAsAction);
        this.fileMenu.add(this.closeAction);
        this.editMenu.add(this.cutAction);
        this.editMenu.add(this.copyAction);
        this.editMenu.add(this.pasteAction);
        this.editMenu.add(this.undoAction);
        this.editMenu.add(this.redoAction);
        this.helpMenu.add(this.aboutAction);
        theMenuPanel.add(this.menuBar);
        theMenuPanel.add(toolBar);
        theContainer.add((Component)theMenuPanel, "North");
        theContainer.add((Component)theMainPanel, "Center");
        this.theLogPane.setLocation(20, 40);
        this.theLogPane.setSize(480, 300);
        theMainPanel.add((Component)this.theLogPane, "theLogPane");
        layoutManagertheLogFrame.setAnchoring(this.theLogPane, true, true, true, true);
        this.theLogTextOutputWindow.setLocation(0, 0);
        this.theLogTextOutputWindow.setSize(480, 300);
        this.theLogTextOutputWindow.setText("");
        this.theLogTextOutputWindow.thePane = this.theLogPane;
        this.theLogTextOutputWindow.fixupSize();
        this.theLogPane.setViewportView(this.theLogTextOutputWindow);
        this.addWindowListener(new WindowEventHandler());
        this.setDefaultCloseOperation(2);
        this.show();
        System.setErr(saveErr);
    }

    void addByte(int byte_to_write) {
        ++this.iByteCount;
        char c = (char)(byte_to_write & 0xFF);
        if (c != '\u0000') {
            this.sBuffer = this.sBuffer + c;
            if (c < ' ') {
                this.flush();
            }
        } else {
            this.theLogTextOutputWindow.append(this.sBuffer);
            this.sBuffer = new String("");
            this.iByteCount = 0;
        }
    }

    void flush() {
        this.theLogTextOutputWindow.append(this.sBuffer);
        this.sBuffer = new String("");
        this.iByteCount = 0;
    }

    public void editorAction(String theActionName, ActionEvent evt, HammerLogConsole theIDELogConsole) {
        JATextAreaX theActiveEditor = theIDELogConsole.theLogTextOutputWindow;
        Class<?> clsActiveEditor = theActiveEditor.getClass();
        Class[] clsParams = new Class[]{new String().getClass()};
        try {
            Method m = clsActiveEditor.getMethod("getActionByName", clsParams);
            Object[] objParams = new Object[]{theActionName};
            Object obj = m.invoke((Object)theActiveEditor, objParams);
            if (obj != null && obj instanceof Action) {
                Action action = (Action)obj;
                action.actionPerformed(evt);
            }
        }
        catch (InvocationTargetException e1) {
            System.out.println("Invocation error");
        }
        catch (NoSuchMethodException e2) {
            System.out.println("No such method error");
        }
        catch (IllegalAccessException e3) {
            System.out.println("Illegal Access error");
        }
    }

    class JATextAreaX
    extends JTextArea
    implements UndoableEditListener {
        protected JScrollPane thePane = null;
        HammerLogConsole theIDELogConsole;
        Hashtable actions;
        public HammerLogEditorPopupMenu thePopupMenu = null;
        public static final int UNDO_LIMIT = 1500;
        private UndoManager m_undoManager;

        public JATextAreaX(HammerLogConsole theIDELogConsole) {
            this.theIDELogConsole = theIDELogConsole;
            this.init();
        }

        void init() {
            this.addCaretListener(new HammerLogSourceCaretListener(this.theIDELogConsole));
            this.thePopupMenu = new HammerLogEditorPopupMenu(this, this.theIDELogConsole);
            this.addMouseListener(new HammerLogEditorMouseListener(this, this.thePopupMenu));
            this.createActionTable();
            this.getDocument().addUndoableEditListener(this);
            this.createUndoMananger();
        }

        private void createActionTable() {
            this.actions = new Hashtable();
            Action[] actionsArray = this.getActions();
            for (int i = 0; i < actionsArray.length; ++i) {
                Action a = actionsArray[i];
                String sActionName = (String)a.getValue("Name");
                this.actions.put(sActionName, a);
            }
        }

        public Action getActionByName(String name) {
            return (Action)this.actions.get(name);
        }

        private void createUndoMananger() {
            this.m_undoManager = new UndoManager();
            this.m_undoManager.setLimit(1500);
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            this.m_undoManager.addEdit(e.getEdit());
        }

        public void undo() {
            try {
                this.m_undoManager.undo();
            }
            catch (CannotUndoException cue) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public void redo() {
            try {
                this.m_undoManager.redo();
            }
            catch (CannotRedoException cue) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        void fixupSize() {
            FontMetrics theFontMetrics;
            int iRows = this.getRows();
            int iColumns = this.getColumns();
            Font theFont = this.getFont();
            if (theFont != null && (theFontMetrics = this.getFontMetrics(theFont)) != null) {
                int iXSize = iColumns * theFontMetrics.stringWidth("m    WXZ") / 8;
                int iYSize = iRows * theFontMetrics.getHeight();
                this.thePane.setPreferredSize(new Dimension(iXSize, iYSize));
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public SaveAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            String sFileName = "";
            String sDirectoryName = "";
            JFileChooser theFileChooser = new JFileChooser(sDirectoryName);
            theFileChooser.addChoosableFileFilter(new HammerLogFileFilter());
            theFileChooser.setFileView(new HammerLogFileView());
            int iOptionSelected = theFileChooser.showSaveDialog(HammerLogConsole.this.getContentPane());
            if (iOptionSelected == 0) {
                try {
                    File file = theFileChooser.getSelectedFile();
                    sFileName = file.getCanonicalPath();
                }
                catch (IOException e93) {
                    return;
                }
            } else {
                return;
            }
            File theOutputLogFile = new File(sFileName);
            try {
                PrintWriter pw = new PrintWriter(new FileOutputStream(theOutputLogFile));
                JATextAreaX theTextWindow = this.theIDELogConsole.theLogTextOutputWindow;
                int iLines = theTextWindow.getLineCount();
                for (int iLine = 0; iLine < iLines; ++iLine) {
                    int iLength;
                    int iOffset = theTextWindow.getLineStartOffset(iLine);
                    String sText = theTextWindow.getText(iOffset, iLength = theTextWindow.getLineEndOffset(iLine) - iOffset);
                    if (sText.length() <= 0) continue;
                    pw.print(sText);
                }
                pw.flush();
                pw.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    class SaveAsAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public SaveAsAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
        }
    }

    class BackgroundColorChooserAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public BackgroundColorChooserAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
        }
    }

    class ForegroundColorChooserAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public ForegroundColorChooserAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
        }
    }

    class RedoAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public RedoAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            JATextAreaX theEditor = this.theIDELogConsole.theLogTextOutputWindow;
            Class<?> clsActiveEditor = theEditor.getClass();
            Class[] clsParams = new Class[]{};
            try {
                Method m = clsActiveEditor.getMethod("redo", clsParams);
                Object[] objParams = new Object[]{};
                m.invoke((Object)theEditor, objParams);
            }
            catch (InvocationTargetException e1) {
                System.out.println("Invocation error");
            }
            catch (NoSuchMethodException e2) {
                System.out.println("No such method error");
            }
            catch (IllegalAccessException e3) {
                System.out.println("Illegal Access error");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public UndoAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            JATextAreaX theEditor = this.theIDELogConsole.theLogTextOutputWindow;
            Class<?> clsActiveEditor = theEditor.getClass();
            Class[] clsParams = new Class[]{};
            try {
                Method m = clsActiveEditor.getMethod("undo", clsParams);
                Object[] objParams = new Object[]{};
                m.invoke((Object)theEditor, objParams);
            }
            catch (InvocationTargetException e1) {
                System.out.println("Invocation error");
            }
            catch (NoSuchMethodException e2) {
                System.out.println("No such method error");
            }
            catch (IllegalAccessException e3) {
                System.out.println("Illegal Access error");
            }
        }
    }

    class FontChooserAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public FontChooserAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
        }
    }

    class AboutAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public AboutAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            new HammerConsoleAboutBox(this.theIDELogConsole);
        }
    }

    class NewAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public NewAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            this.theIDELogConsole.theLogTextOutputWindow.setText("");
        }
    }

    class CloseAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public CloseAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
        }
    }

    class OpenAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public OpenAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            JFileChooser theFileChooser = new JFileChooser();
            theFileChooser.addChoosableFileFilter(new HammerLogFileFilter());
            theFileChooser.setFileView(new HammerLogFileView());
            int iOptionSelected = theFileChooser.showOpenDialog(this.theIDELogConsole.getContentPane());
            if (iOptionSelected == 0) {
                File file = theFileChooser.getSelectedFile();
                try {
                    String sLine;
                    String sFullPath = file.getCanonicalPath();
                    this.theIDELogConsole.theLogTextOutputWindow.setText("");
                    BufferedReader in = new BufferedReader(new FileReader(sFullPath));
                    String sText = "";
                    while ((sLine = in.readLine()) != null) {
                        sText = sText + "\r\n" + sLine;
                    }
                    in.close();
                    this.theIDELogConsole.theLogTextOutputWindow.setText(sText);
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
        }
    }

    class PasteAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public PasteAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            HammerLogConsole.this.editorAction("paste-from-clipboard", evt, this.theIDELogConsole);
        }
    }

    class CopyAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public CopyAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            HammerLogConsole.this.editorAction("copy-to-clipboard", evt, this.theIDELogConsole);
        }
    }

    class CutAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public CutAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            HammerLogConsole.this.editorAction("cut-to-clipboard", evt, this.theIDELogConsole);
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            HammerLogConsole thisConsole = (HammerLogConsole)evt.getSource();
            thisConsole.theCreator.theLogConsoles.remove(thisConsole);
        }
    }
}

