/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.HammerClassByteFileLoader;
import ch.abacus.lib.ui.renderer.common.HammerInputStream;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaClassDetail;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetaContainerType;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import ch.abacus.lib.ui.renderer.common.MetadataAdministrator;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import ch.abacus.lib.ui.renderer.common.MetadataDocumentGenerator;
import ch.abacus.lib.ui.renderer.droplets.DropletSimpleLog;
import electric.xml.CData;
import electric.xml.Child;
import electric.xml.Children;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.ArrayList;

public class HammerMetadataDocument {
    public MetadataDispenser theMetadataDispenser;
    private boolean bAlreadyLoaded = false;
    private boolean bCustomAlreadyLoaded = false;
    private boolean bLoadingComplete = false;
    public String sFullPathName;
    public String sJarName;
    public int mode;
    public String sDocumentComments = null;
    public String sJarEntryName;

    public HammerMetadataDocument(MetadataDispenser theMetadataDispenser) {
        this.theMetadataDispenser = theMetadataDispenser;
    }

    MetaPropertyDescriptor doPropertyList(MetaClassDetail theClassDetail, Element xmlProperty, int iOrder) {
        Element xmlPropName = xmlProperty.getElement("Name");
        Element xmlPropClass = xmlProperty.getElement("Class");
        Element xmlPropType = xmlProperty.getElement("Type");
        Elements xmlPropValueChoices = xmlProperty.getElements("ValueChoice");
        Element xmlPropDefaultValue = xmlProperty.getElement("DefaultValue");
        Element xmlPropSet = xmlProperty.getElement("Set");
        Element xmlPropGet = xmlProperty.getElement("Get");
        Element xmlPropertyHelper = xmlProperty.getElement("Helper");
        Element xmlPropertyDoc = xmlProperty.getElement("Doc");
        Element xmlPropGenerate = xmlProperty.getElement("Generate");
        Element xmlPropVisible = xmlProperty.getElement("Visible");
        Element xmlPropArray = xmlProperty.getElement("Array");
        Element xmlPropDataAwareness = xmlProperty.getElement("DataAwareness");
        Element xmlPropObjRef = xmlProperty.getElement("ObjectReference");
        Element xmlPropObjList = xmlProperty.getElement("ObjectList");
        Element xmlPropDefConstants = xmlProperty.getElement("DefaultConstantType");
        Element xmlPropLanguages = xmlProperty.getElement("Languages");
        Element xmlPropReadOnly = xmlProperty.getElement("ReadOnly");
        String sPropertyName = xmlPropName.getTextString();
        String sPropertyClass = "String";
        String sPropertyType = "";
        String sPropertyDefaultValue = "";
        String sPropertySetName = "";
        String sPropertyGetName = "";
        String sPropertyDoc = "";
        String sPropertyHelper = "";
        if (xmlPropClass != null) {
            sPropertyClass = xmlPropClass.getTextString();
        }
        if (xmlPropType != null) {
            sPropertyType = xmlPropType.getTextString();
        }
        if (xmlPropSet != null) {
            sPropertySetName = xmlPropSet.getTextString();
        }
        if (xmlPropGet != null) {
            sPropertyGetName = xmlPropGet.getTextString();
        }
        if (xmlPropertyHelper != null) {
            sPropertyHelper = xmlPropertyHelper.getTextString();
        }
        if (xmlPropDefaultValue != null) {
            sPropertyDefaultValue = xmlPropDefaultValue.getTextString();
        }
        if (xmlPropertyDoc != null) {
            Children theChildren = xmlPropertyDoc.getChildren();
            Child childTest = theChildren.first();
            CData cData = (CData)childTest;
            sPropertyDoc = cData.getString();
        }
        boolean bVisible = false;
        boolean bAutoGenerate = false;
        boolean bArray = false;
        boolean bLanguages = false;
        boolean bObjectReference = false;
        boolean bObjectPromptList = false;
        boolean bDataAwareness = false;
        boolean bReadOnly = false;
        String sIncludeTypeConstants = null;
        if (xmlPropDataAwareness != null) {
            bDataAwareness = true;
        }
        if (xmlPropGenerate != null) {
            bAutoGenerate = true;
        }
        if (xmlPropVisible != null) {
            bVisible = true;
        }
        if (xmlPropArray != null) {
            bArray = true;
        }
        if (xmlPropLanguages != null) {
            bLanguages = true;
        }
        if (xmlPropObjRef != null) {
            bObjectReference = true;
        }
        if (xmlPropObjList != null) {
            bObjectPromptList = true;
        }
        if (xmlPropReadOnly != null) {
            bReadOnly = true;
        }
        if (xmlPropDefConstants != null) {
            sIncludeTypeConstants = xmlPropDefConstants.getTextString();
        }
        String[] sValueChoices = new String[xmlPropValueChoices.size()];
        for (int iValueChoice = 0; iValueChoice < xmlPropValueChoices.size(); ++iValueChoice) {
            Element elementValueChoice = xmlPropValueChoices.next();
            sValueChoices[iValueChoice] = elementValueChoice.getTextString();
        }
        MetaPropertyDescriptor theNewProperty = new MetaPropertyDescriptor(sPropertyName, sPropertyType, sPropertyClass, sValueChoices, sPropertyDoc, sPropertyDefaultValue, sPropertySetName, sPropertyGetName, sPropertyHelper, sIncludeTypeConstants, iOrder, this.theMetadataDispenser, theClassDetail);
        theNewProperty.bGenerate = bAutoGenerate;
        theNewProperty.bVisible = bVisible;
        theNewProperty.bAllowMultipleValues = bArray;
        theNewProperty.bAllowMultipleLanguages = bLanguages;
        theNewProperty.bObjectReference = bObjectReference;
        theNewProperty.bObjectPromptList = bObjectPromptList;
        theNewProperty.setReadOnly(bReadOnly);
        theNewProperty.setDataAwareness(bDataAwareness);
        Elements theProperties = xmlProperty.getElements("Property");
        int iSubOrder = 0;
        for (int iProperty = 0; iProperty < theProperties.size(); ++iProperty) {
            xmlProperty = theProperties.next();
            MetaPropertyDescriptor thePropertyList = this.doPropertyList(theClassDetail, xmlProperty, iSubOrder++);
            theNewProperty.addSubproperty(thePropertyList);
        }
        return theNewProperty;
    }

    public MetaClass loadClass(DropletSimpleLog theLog, Element xmlClass, MetaClass theParent) {
        Element xmlClassList;
        Element xmlDesignEditor;
        Element xmlClassFactory;
        Element xmlCustomCodeGenerator;
        String sContainerType;
        Element xmlDisplayClassIcon;
        Element xmlSkipDefaultListeners;
        Element xmlCompositeComponents;
        Element xmlDesignBorders;
        Element xmlSkipDecl;
        Element xmlHidden;
        String sClassComment = null;
        String sClassName = xmlClass.getName();
        Element xmlClassComment = xmlClass.getElement("Comments");
        if (xmlClassComment != null) {
            sClassComment = xmlClassComment.getTextString();
        }
        Element xmlFullClassName = xmlClass.getElement("FullClassName");
        String sFullClassName = "";
        if (xmlFullClassName != null) {
            sFullClassName = xmlFullClassName.getTextString();
        }
        if (theLog != null) {
            theLog.writeMessage("Full class name of metaclass is " + sFullClassName);
        }
        MetaClassDetail theClass = new MetaClassDetail(sClassName, sFullClassName);
        theClass.sClassComment = sClassComment;
        theClass.sFullClassName = sFullClassName;
        this.setLanguageAlias(theClass, xmlClass);
        Element xmlSuperClass = xmlClass.getElement("Superclass");
        String sSuperClassName = "";
        String sFullPathName = "";
        if (xmlSuperClass != null) {
            sSuperClassName = xmlSuperClass.getElement("Name").getTextString();
            sFullPathName = xmlSuperClass.getElement("FullPath").getTextString();
        }
        theClass.setSuperClass(sSuperClassName, sFullPathName);
        Element xmlDisplayClass = xmlClass.getElement("Display");
        if (xmlDisplayClass != null) {
            theClass.setDisplayClass(xmlDisplayClass.getTextString());
        }
        if ((xmlHidden = xmlClass.getElement("Hidden")) != null) {
            theClass.bHidden = true;
        }
        if ((xmlSkipDecl = xmlClass.getElement("SkipDeclarations")) != null) {
            theClass.bSkipDecl = true;
        }
        if ((xmlDesignBorders = xmlClass.getElement("DesignBorders")) != null) {
            theClass.bDesignBorders = true;
        }
        if ((xmlCompositeComponents = xmlClass.getElement("CompositeComponent")) != null) {
            theClass.bCompositeComponent = true;
        }
        if ((xmlSkipDefaultListeners = xmlClass.getElement("SkipDefaultListeners")) != null) {
            theClass.bDefaultListeners = false;
        }
        if ((xmlDisplayClassIcon = xmlClass.getElement("Icon")) != null) {
            theClass.setDisplayClassIcon(xmlDisplayClassIcon.getTextString());
        }
        boolean bHorzSplitterClass = false;
        boolean bVertSplitterClass = false;
        boolean bPanelClass = false;
        Element xmlContainerType = xmlClass.getElement("ContainerType");
        if (xmlContainerType != null && (sContainerType = xmlContainerType.getTextString()) != null && sContainerType.trim().length() != 0) {
            theClass.containerType = new MetaContainerType();
            theClass.containerType.setContainerType(sContainerType);
            if (sContainerType.equals("vsplit")) {
                bVertSplitterClass = true;
            } else if (sContainerType.equals("hsplit")) {
                bHorzSplitterClass = true;
            } else if (sContainerType.equals("panel")) {
                bPanelClass = true;
            }
        }
        if ((xmlCustomCodeGenerator = xmlClass.getElement("Custom")) != null) {
            theClass.sCustomCodeGenerationMethod = xmlCustomCodeGenerator.getTextString();
        }
        if ((xmlClassFactory = xmlClass.getElement("ClassFactory")) != null) {
            theClass.theFactoryName = xmlClassFactory.getTextString();
        }
        if ((xmlDesignEditor = xmlClass.getElement("DesignEditor")) != null) {
            theClass.theDesignEditor = xmlDesignEditor.getTextString();
        }
        if (this.theMetadataDispenser.iMode == 1) {
            Elements xmlListeners = xmlClass.getElements("Listener");
            for (int iListener = 0; iListener < xmlListeners.size(); ++iListener) {
                Element xmlListener = xmlListeners.next();
                theClass.addListener(xmlListener.getTextString(), this.theMetadataDispenser);
            }
            Elements xmlDataElements = xmlClass.getElements("MemberData");
            for (int iData = 0; iData < xmlDataElements.size(); ++iData) {
                Element xmlDataElement = xmlDataElements.next();
                String sFieldName = xmlDataElement.getElement("Name").getTextString();
                Element xmlFieldType = xmlDataElement.getElement("Type");
                Element xmlFieldClass = xmlDataElement.getElement("Class");
                String sFieldClass = "";
                String sFieldType = "String";
                if (xmlFieldClass != null) {
                    sFieldType = "Class";
                    sFieldClass = xmlDataElement.getElement("Class").getTextString();
                } else if (xmlFieldType != null) {
                    sFieldType = xmlFieldType.getTextString();
                }
                String sFieldValue = "";
                String sFieldDoc = "";
                Element xmlFieldValue = xmlDataElement.getElement("Value");
                Element xmlFieldDoc = xmlDataElement.getElement("Doc");
                if (xmlFieldValue != null) {
                    sFieldValue = xmlFieldValue.getTextString();
                }
                if (xmlFieldDoc != null) {
                    Children theChildren = xmlFieldDoc.getChildren();
                    int iDocChildren = theChildren.size();
                    if (theChildren != null && iDocChildren != 0) {
                        Child childTest = theChildren.first();
                        CData cData = (CData)childTest;
                        sFieldDoc = cData.getString();
                    }
                }
                theClass.addData(sFieldName, sFieldType, sFieldClass, sFieldValue, sFieldDoc);
            }
            Elements theMethods = xmlClass.getElements("Method");
            for (int iMethod = 0; iMethod < theMethods.size(); ++iMethod) {
                Element xmlMethod = theMethods.next();
                String sMethodName = xmlMethod.getElement("Name").getTextString();
                Element xmlMethodCode = xmlMethod.getElement("Code");
                String sMethodBody = "";
                if (xmlMethodCode != null) {
                    Children theChildren = xmlMethodCode.getChildren();
                    Child childTest = theChildren.first();
                    CData cData = (CData)childTest;
                    sMethodBody = cData.getString();
                }
                Element xmlMethodDoc = xmlMethod.getElement("Doc");
                String sMethodDoc = "";
                if (xmlMethodDoc != null) {
                    Children theChildren = xmlMethodDoc.getChildren();
                    int iDocChildren = theChildren.size();
                    if (theChildren != null && iDocChildren != 0) {
                        Child childTest = theChildren.first();
                        CData cData = (CData)childTest;
                        sMethodDoc = cData.getString();
                    }
                }
                theClass.addMethod(sMethodName, sMethodBody, sMethodDoc);
            }
        }
        Elements theProperties = xmlClass.getElements("Property");
        for (int iProperty = 0; iProperty < theProperties.size(); ++iProperty) {
            Element xmlProperty = theProperties.next();
            MetaPropertyDescriptor thePropertyList = this.doPropertyList(theClass, xmlProperty, 0);
            theClass.addProperties(thePropertyList);
        }
        Element theDoc = xmlClass.getElement("Doc");
        MetaClass theMetaClass = this.theMetadataDispenser.getMetadataUser().getDropletsState() ? new MetaClass(theLog, theClass, theParent, this.theMetadataDispenser) : new MetaClass(theClass, theParent, this.theMetadataDispenser, true);
        if (theLog != null) {
            if (theMetaClass == null) {
                theLog.writeMessage("No metaclass could be created!");
            } else {
                theLog.writeMessage("Metaclass is " + theMetaClass.toString());
            }
        }
        if (bVertSplitterClass) {
            this.theMetadataDispenser.setVerticalSplitterClass(theMetaClass);
        } else if (bHorzSplitterClass) {
            this.theMetadataDispenser.setHorizontalSplitterClass(theMetaClass);
        } else if (bPanelClass) {
            this.theMetadataDispenser.setDefaultPanelClass(theMetaClass);
        }
        if (theParent != null) {
            theParent.addClass(theMetaClass);
        }
        if ((xmlClassList = xmlClass.getElement("Classes")) != null) {
            Elements xmlClasses = xmlClassList.getElements();
            for (int iClass = 0; iClass < xmlClasses.size(); ++iClass) {
                Element xmlSubClass = xmlClasses.next();
                this.loadClass(theLog, xmlSubClass, theMetaClass);
            }
        }
        return theMetaClass;
    }

    private void setLanguageAlias(MetaClassDetail metaClassDetail, Element xmlClass) {
        String sIsoCode;
        String sClassAlias;
        if (this.theMetadataDispenser.getGlobalInterface() != null && (sClassAlias = xmlClass.getAttribute(sIsoCode = this.theMetadataDispenser.getGlobalInterface().getLanguage().getISOCode())) != null) {
            metaClassDetail.setDisplayName(sClassAlias);
        }
    }

    public MetaClass loadClass(Element xmlClass, MetaClass theParent) {
        return this.loadClass(null, xmlClass, theParent);
    }

    public MetaConstantGroup loadConstants(Element xmlConstantGroup) {
        String sGroupName = xmlConstantGroup.getName();
        MetaConstantGroup theGroup = this.theMetadataDispenser.findConstantGroup(sGroupName);
        if (theGroup == null) {
            theGroup = new MetaConstantGroup(sGroupName, this.theMetadataDispenser);
        }
        Elements theNames = xmlConstantGroup.getElements();
        int iNameCount = theNames.size();
        for (int i = 0; i < iNameCount; ++i) {
            Element theName = theNames.next();
            String sName = theName.getName();
            String sValue = theName.getTextString();
            if (sName == null || sValue == null) continue;
            theGroup.set(sName, sValue);
        }
        return theGroup;
    }

    public MetaConstantGroupCollection loadConstantGroupCollections(Element xmlConstantGroupCollection) {
        String sCollectionName = xmlConstantGroupCollection.getName();
        MetaConstantGroupCollection theCollection = new MetaConstantGroupCollection(sCollectionName, this.theMetadataDispenser);
        Elements theNames = xmlConstantGroupCollection.getElements();
        int iNameCount = theNames.size();
        for (int i = 0; i < iNameCount; ++i) {
            Element theName = theNames.next();
            String sName = theName.getName();
            MetaConstantGroup theGroup = this.theMetadataDispenser.findConstantGroup(sName);
            if (theGroup == null) continue;
            theCollection.addGroup(theGroup);
        }
        return theCollection;
    }

    public boolean loadMeta(DropletSimpleLog theLog, String sSystemDocument) {
        Element xmlClassesRoot;
        Element xmlConstantCollectionsRoot;
        Element xmlConstantsRoot;
        Element xmlVersion;
        Element xmlDesignBorderDefinition;
        Element xmlDocumentComments;
        if (this.bAlreadyLoaded) {
            return true;
        }
        this.theMetadataDispenser.theFirstClass = null;
        this.theMetadataDispenser.theLastClass = null;
        this.theMetadataDispenser.theFirstListener = null;
        this.theMetadataDispenser.theLastListener = null;
        HammerInputStream hisMetadataStream = this.theMetadataDispenser.getMetadataUser().getFileManager().getInputStream(sSystemDocument);
        if (theLog != null) {
            if (hisMetadataStream == null) {
                theLog.writeMessage(sSystemDocument + " is not open!!!");
            } else {
                theLog.writeMessage("Input stream for metadata " + sSystemDocument + " is " + hisMetadataStream.toString());
            }
        }
        if (hisMetadataStream == null || hisMetadataStream.theStream == null) {
            return false;
        }
        this.mode = hisMetadataStream.mode;
        this.sFullPathName = hisMetadataStream.sFullPathName;
        this.sJarName = hisMetadataStream.sJarName;
        if (theLog != null) {
            theLog.writeMessage("MetadataMeta: " + this.sFullPathName);
            theLog.writeMessage("MetadataMeta Jar: " + this.sJarName);
        }
        BufferedInputStream theMetadataStream = new BufferedInputStream(hisMetadataStream.theStream);
        Document xmlSystemDocument = null;
        try {
            xmlSystemDocument = new Document((InputStream)theMetadataStream);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
        if (theLog != null) {
            theLog.writeMessage("Metadata.meta has been loaded into an xml document.");
        }
        Element xmlSystemRoot = xmlSystemDocument.getRoot();
        if (theLog != null && xmlSystemRoot != null) {
            theLog.writeMessage("System root is " + xmlSystemRoot.getTextString());
        }
        if ((xmlDocumentComments = xmlSystemRoot.getElement("Comments")) != null) {
            this.sDocumentComments = xmlDocumentComments.getTextString();
        }
        if ((xmlDesignBorderDefinition = xmlSystemRoot.getElement("DesignBorderDefinition")) != null) {
            this.theMetadataDispenser.sDesignBorderDefinition = xmlDesignBorderDefinition.getTextString();
        }
        if ((xmlVersion = xmlSystemRoot.getElement("Version")) != null) {
            this.theMetadataDispenser.theMetaDataAdministrator = new MetadataAdministrator(this.theMetadataDispenser, xmlVersion);
        }
        if (this.theMetadataDispenser.iMode == 1) {
            int iListener;
            Element xmlListenerRoot = xmlSystemRoot.getElement("Listeners");
            if (xmlListenerRoot != null) {
                Elements xmlListeners = xmlListenerRoot.getElements();
                for (iListener = 0; iListener < xmlListeners.size(); ++iListener) {
                    Element xmlListener = xmlListeners.next();
                    MetaClass theMetaClass = this.loadClass(xmlListener, null);
                    if (this.theMetadataDispenser.theFirstListener == null) {
                        this.theMetadataDispenser.theFirstListener = theMetaClass;
                    } else {
                        this.theMetadataDispenser.theLastListener.theNextSibling = theMetaClass;
                    }
                    theMetaClass.thePrevSibling = this.theMetadataDispenser.theLastClass;
                    this.theMetadataDispenser.theLastListener = theMetaClass;
                    ++this.theMetadataDispenser.iListenerCount;
                }
            }
            int iBasicSwingListeners = this.theMetadataDispenser.theListenerCollection.iListenerCount;
            for (iListener = 0; iListener < iBasicSwingListeners; ++iListener) {
                MetaClassDetail theListenerMetadata = this.theMetadataDispenser.theListenerCollection.getDefaultListenerClassMetadata(iListener);
                theListenerMetadata.sClassName = this.theMetadataDispenser.theListenerCollection.getDefaultListenerName(iListener);
                theListenerMetadata.sAddListenerMethod = this.theMetadataDispenser.theListenerCollection.getAddListenerName(iListener);
                theListenerMetadata.sRemoveListenerMethod = this.theMetadataDispenser.theListenerCollection.getRemoveListenerName(iListener);
                MetaClass theListener = new MetaClass(theListenerMetadata, null, this.theMetadataDispenser, true);
                if (theListener == null) continue;
                if (this.theMetadataDispenser.theFirstListener == null) {
                    this.theMetadataDispenser.theFirstListener = theListener;
                } else {
                    this.theMetadataDispenser.theLastListener.theNextSibling = theListener;
                }
                theListener.thePrevSibling = this.theMetadataDispenser.theLastClass;
                this.theMetadataDispenser.theLastListener = theListener;
                ++this.theMetadataDispenser.iListenerCount;
            }
        }
        if (theLog != null) {
            theLog.writeMessage("About to load constants.");
        }
        if ((xmlConstantsRoot = xmlSystemRoot.getElement("Constants")) != null) {
            Elements xmlTypes = xmlConstantsRoot.getElements();
            for (int iType = 0; iType < xmlTypes.size(); ++iType) {
                Element xmlType = xmlTypes.next();
                MetaConstantGroup theMetaConstantGroup = this.loadConstants(xmlType);
                if (this.theMetadataDispenser.theFirstMetaConstantGroup == null) {
                    this.theMetadataDispenser.theFirstMetaConstantGroup = theMetaConstantGroup;
                } else {
                    this.theMetadataDispenser.theLastMetaConstantGroup.theNextSibling = theMetaConstantGroup;
                }
                theMetaConstantGroup.thePrevSibling = this.theMetadataDispenser.theLastMetaConstantGroup;
                this.theMetadataDispenser.theLastMetaConstantGroup = theMetaConstantGroup;
            }
        }
        if ((xmlConstantCollectionsRoot = xmlSystemRoot.getElement("ConstantCollections")) != null) {
            Elements xmlTypes = xmlConstantCollectionsRoot.getElements();
            for (int iType = 0; iType < xmlTypes.size(); ++iType) {
                Element xmlType = xmlTypes.next();
                MetaConstantGroupCollection theMetaConstantGroupCollection = this.loadConstantGroupCollections(xmlType);
                if (this.theMetadataDispenser.theFirstMetaConstantGroupCollection == null) {
                    this.theMetadataDispenser.theFirstMetaConstantGroupCollection = theMetaConstantGroupCollection;
                } else {
                    this.theMetadataDispenser.theLastMetaConstantGroupCollection.theNextSibling = theMetaConstantGroupCollection;
                }
                theMetaConstantGroupCollection.thePreviousSibling = this.theMetadataDispenser.theLastMetaConstantGroupCollection;
                this.theMetadataDispenser.theLastMetaConstantGroupCollection = theMetaConstantGroupCollection;
            }
        }
        if (theLog != null) {
            theLog.writeMessage("About to load classes.");
        }
        if ((xmlClassesRoot = xmlSystemRoot.getElement("Classes")) != null) {
            if (theLog != null) {
                theLog.writeMessage("There are classes.");
            }
            Elements xmlClasses = xmlClassesRoot.getElements();
            for (int iClass = 0; iClass < xmlClasses.size(); ++iClass) {
                Element xmlClass = xmlClasses.next();
                MetaClass theMetaClass = this.loadClass(theLog, xmlClass, null);
                if (this.theMetadataDispenser.theFirstClass == null) {
                    this.theMetadataDispenser.theFirstClass = theMetaClass;
                } else {
                    this.theMetadataDispenser.theLastClass.theNextSibling = theMetaClass;
                }
                theMetaClass.thePrevSibling = this.theMetadataDispenser.theLastClass;
                this.theMetadataDispenser.theLastClass = theMetaClass;
            }
            this.bAlreadyLoaded = true;
            return true;
        }
        if (theLog != null) {
            theLog.writeMessage("There are no classes!");
        }
        return false;
    }

    protected boolean loadCustomMeta(InputStream customMetadataStream) {
        Element xmlRepoClasses;
        Elements xmlCustomClasses;
        String parenClass;
        MetaClass pClass;
        Element xmlListenerRoot;
        Document xmlReposit = null;
        try {
            BufferedInputStream repoMetadataStream = new BufferedInputStream(customMetadataStream);
            xmlReposit = new Document((InputStream)repoMetadataStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        Element xmlRepoRootClass = xmlReposit.getRoot();
        Element xmlConstantsRoot = xmlRepoRootClass.getElement("Constants");
        if (xmlConstantsRoot != null) {
            Elements xmlTypes = xmlConstantsRoot.getElements();
            for (int iType = 0; iType < xmlTypes.size(); ++iType) {
                Element xmlType = xmlTypes.next();
                String sGroupName = xmlType.getName();
                MetaConstantGroup theGroup = this.theMetadataDispenser.findConstantGroup(sGroupName);
                MetaConstantGroup theMetaConstantGroup = this.loadConstants(xmlType);
                if (theGroup != null) continue;
                if (this.theMetadataDispenser.theFirstMetaConstantGroup == null) {
                    this.theMetadataDispenser.theFirstMetaConstantGroup = theMetaConstantGroup;
                } else {
                    this.theMetadataDispenser.theLastMetaConstantGroup.theNextSibling = theMetaConstantGroup;
                }
                theMetaConstantGroup.thePrevSibling = this.theMetadataDispenser.theLastMetaConstantGroup;
                this.theMetadataDispenser.theLastMetaConstantGroup = theMetaConstantGroup;
            }
        }
        if (this.theMetadataDispenser.iMode == 1 && (xmlListenerRoot = xmlRepoRootClass.getElement("Listeners")) != null) {
            Elements xmlListeners = xmlListenerRoot.getElements();
            for (int iListener = 0; iListener < xmlListeners.size(); ++iListener) {
                Element xmlListener = xmlListeners.next();
                MetaClass theMetaClass = this.loadClass(xmlListener, null);
                if (this.theMetadataDispenser.theFirstListener == null) {
                    this.theMetadataDispenser.theFirstListener = theMetaClass;
                } else {
                    this.theMetadataDispenser.theLastListener.theNextSibling = theMetaClass;
                }
                theMetaClass.thePrevSibling = this.theMetadataDispenser.theLastClass;
                this.theMetadataDispenser.theLastListener = theMetaClass;
                ++this.theMetadataDispenser.iListenerCount;
            }
        }
        if ((pClass = this.theMetadataDispenser.findClass(parenClass = (xmlCustomClasses = (xmlRepoClasses = xmlRepoRootClass.getElement("Classes")).getElements()).first().getName())) != null) {
            Element xmlRepoClassesEx = xmlCustomClasses.first().getElement("Classes");
            xmlCustomClasses = xmlRepoClassesEx.getElements();
        }
        for (int iClass = 0; iClass < xmlCustomClasses.size(); ++iClass) {
            Element xmlRepoClass = xmlCustomClasses.next();
            MetaClass repositMetaClass = this.loadClass(null, xmlRepoClass, pClass);
            if (pClass != null) continue;
            this.theMetadataDispenser.theLastClass.theNextSibling = repositMetaClass;
            repositMetaClass.thePrevSibling = this.theMetadataDispenser.theLastClass;
            this.theMetadataDispenser.theLastClass = repositMetaClass;
        }
        return true;
    }

    public boolean loadCustomMeta(String sSystemDocument, String repositoryLocation) {
        if (this.bCustomAlreadyLoaded) {
            return true;
        }
        HammerInputStream hisMetadataStream = this.theMetadataDispenser.getMetadataUser().getFileManager().getInputStream(sSystemDocument);
        if (hisMetadataStream == null || hisMetadataStream.theStream == null) {
            return false;
        }
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };
        HammerInputStream jarRepoMetadataStream = null;
        String[] dirRepositories = repositoryLocation.split(File.pathSeparator);
        for (int c = 0; c < dirRepositories.length; ++c) {
            File dir = new File(dirRepositories[c]);
            String[] children = dir.list(filter);
            if (children == null) {
                HammerClassByteFileLoader tmpByteFileLoader = this.theMetadataDispenser.getMetadataUser().getClassLoader().getLoader().classByteFileLoader;
                ArrayList e = tmpByteFileLoader.getFilesInPath(repositoryLocation);
                for (int i = 0; i < e.size(); ++i) {
                    String repositoryFile = (String)e.get(i);
                    jarRepoMetadataStream = this.theMetadataDispenser.getMetadataUser().getFileManager().getInputStream(repositoryFile);
                    if (jarRepoMetadataStream.sJarName == null) {
                        return false;
                    }
                    this.loadCustomMeta(jarRepoMetadataStream.theStream);
                }
                this.bCustomAlreadyLoaded = true;
                return true;
            }
            for (int i = 0; i < children.length; ++i) {
                String filename = new StringBuffer().append(dirRepositories[c]).append(File.separator).append(children[i]).toString();
                FileInputStream repoHammerMetadataStream = null;
                try {
                    repoHammerMetadataStream = new FileInputStream(filename);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                this.loadCustomMeta(repoHammerMetadataStream);
            }
        }
        this.bCustomAlreadyLoaded = true;
        return true;
    }

    public boolean loadMeta(String sSystemDocument) {
        if (this.bAlreadyLoaded) {
            return true;
        }
        HammerInputStream hisMetadataStream = this.theMetadataDispenser.getMetadataUser().getFileManager().getInputStream(sSystemDocument);
        return this.loadMeta(hisMetadataStream);
    }

    public boolean loadMeta(HammerInputStream hisMetadataStream) {
        Element xmlClassesRoot;
        Element xmlConstantCollectionsRoot;
        Element xmlConstantsRoot;
        Element xmlVersion;
        Element xmlDesignBorderDefinition;
        if (hisMetadataStream == null || hisMetadataStream.theStream == null) {
            return false;
        }
        this.theMetadataDispenser.theFirstClass = null;
        this.theMetadataDispenser.theLastClass = null;
        this.theMetadataDispenser.theFirstListener = null;
        this.theMetadataDispenser.theLastListener = null;
        this.mode = hisMetadataStream.mode;
        this.sFullPathName = hisMetadataStream.sFullPathName;
        this.sJarName = hisMetadataStream.sJarName;
        this.sJarEntryName = hisMetadataStream.sJarEntryName;
        BufferedInputStream theMetadataStream = new BufferedInputStream(hisMetadataStream.theStream);
        Document xmlSystemDocument = null;
        try {
            xmlSystemDocument = new Document((InputStream)theMetadataStream);
        }
        catch (ParseException e) {
            return false;
        }
        Element xmlSystemRoot = xmlSystemDocument.getRoot();
        Element xmlDocumentComments = xmlSystemRoot.getElement("Comments");
        if (xmlDocumentComments != null) {
            this.sDocumentComments = xmlDocumentComments.getTextString();
        }
        if ((xmlDesignBorderDefinition = xmlSystemRoot.getElement("DesignBorderDefinition")) != null) {
            this.theMetadataDispenser.sDesignBorderDefinition = xmlDesignBorderDefinition.getTextString();
        }
        if ((xmlVersion = xmlSystemRoot.getElement("Version")) != null) {
            this.theMetadataDispenser.theMetaDataAdministrator = new MetadataAdministrator(this.theMetadataDispenser, xmlVersion);
        }
        if (this.theMetadataDispenser.iMode == 1) {
            int iListener;
            Element xmlListenerRoot = xmlSystemRoot.getElement("Listeners");
            if (xmlListenerRoot != null) {
                Elements xmlListeners = xmlListenerRoot.getElements();
                for (iListener = 0; iListener < xmlListeners.size(); ++iListener) {
                    Element xmlListener = xmlListeners.next();
                    MetaClass theMetaClass = this.loadClass(xmlListener, null);
                    if (this.theMetadataDispenser.theFirstListener == null) {
                        this.theMetadataDispenser.theFirstListener = theMetaClass;
                    } else {
                        this.theMetadataDispenser.theLastListener.theNextSibling = theMetaClass;
                    }
                    theMetaClass.thePrevSibling = this.theMetadataDispenser.theLastClass;
                    this.theMetadataDispenser.theLastListener = theMetaClass;
                    ++this.theMetadataDispenser.iListenerCount;
                }
            }
            int iBasicSwingListeners = this.theMetadataDispenser.theListenerCollection.iListenerCount;
            for (iListener = 0; iListener < iBasicSwingListeners; ++iListener) {
                MetaClassDetail theListenerMetadata = this.theMetadataDispenser.theListenerCollection.getDefaultListenerClassMetadata(iListener);
                theListenerMetadata.sClassName = this.theMetadataDispenser.theListenerCollection.getDefaultListenerName(iListener);
                theListenerMetadata.sAddListenerMethod = this.theMetadataDispenser.theListenerCollection.getAddListenerName(iListener);
                theListenerMetadata.sRemoveListenerMethod = this.theMetadataDispenser.theListenerCollection.getRemoveListenerName(iListener);
                MetaClass theListener = new MetaClass(theListenerMetadata, null, this.theMetadataDispenser, true);
                if (theListener == null) continue;
                if (this.theMetadataDispenser.theFirstListener == null) {
                    this.theMetadataDispenser.theFirstListener = theListener;
                } else {
                    this.theMetadataDispenser.theLastListener.theNextSibling = theListener;
                }
                theListener.thePrevSibling = this.theMetadataDispenser.theLastClass;
                this.theMetadataDispenser.theLastListener = theListener;
                ++this.theMetadataDispenser.iListenerCount;
            }
        }
        if ((xmlConstantsRoot = xmlSystemRoot.getElement("Constants")) != null) {
            Elements xmlTypes = xmlConstantsRoot.getElements();
            for (int iType = 0; iType < xmlTypes.size(); ++iType) {
                Element xmlType = xmlTypes.next();
                MetaConstantGroup theMetaConstantGroup = this.loadConstants(xmlType);
                if (this.theMetadataDispenser.theFirstMetaConstantGroup == null) {
                    this.theMetadataDispenser.theFirstMetaConstantGroup = theMetaConstantGroup;
                } else {
                    this.theMetadataDispenser.theLastMetaConstantGroup.theNextSibling = theMetaConstantGroup;
                }
                theMetaConstantGroup.thePrevSibling = this.theMetadataDispenser.theLastMetaConstantGroup;
                this.theMetadataDispenser.theLastMetaConstantGroup = theMetaConstantGroup;
            }
        }
        if ((xmlConstantCollectionsRoot = xmlSystemRoot.getElement("ConstantCollections")) != null) {
            Elements xmlTypes = xmlConstantCollectionsRoot.getElements();
            for (int iType = 0; iType < xmlTypes.size(); ++iType) {
                Element xmlType = xmlTypes.next();
                MetaConstantGroupCollection theMetaConstantGroupCollection = this.loadConstantGroupCollections(xmlType);
                if (this.theMetadataDispenser.theFirstMetaConstantGroupCollection == null) {
                    this.theMetadataDispenser.theFirstMetaConstantGroupCollection = theMetaConstantGroupCollection;
                } else {
                    this.theMetadataDispenser.theLastMetaConstantGroupCollection.theNextSibling = theMetaConstantGroupCollection;
                }
                theMetaConstantGroupCollection.thePreviousSibling = this.theMetadataDispenser.theLastMetaConstantGroupCollection;
                this.theMetadataDispenser.theLastMetaConstantGroupCollection = theMetaConstantGroupCollection;
            }
        }
        if ((xmlClassesRoot = xmlSystemRoot.getElement("Classes")) != null) {
            Elements xmlClasses = xmlClassesRoot.getElements();
            for (int iClass = 0; iClass < xmlClasses.size(); ++iClass) {
                Element xmlClass = xmlClasses.next();
                MetaClass theMetaClass = this.loadClass(xmlClass, null);
                if (this.theMetadataDispenser.theFirstClass == null) {
                    this.theMetadataDispenser.theFirstClass = theMetaClass;
                } else {
                    this.theMetadataDispenser.theLastClass.theNextSibling = theMetaClass;
                }
                theMetaClass.thePrevSibling = this.theMetadataDispenser.theLastClass;
                this.theMetadataDispenser.theLastClass = theMetaClass;
            }
            this.bAlreadyLoaded = true;
            return true;
        }
        return false;
    }

    public boolean writeMetaDocument() {
        String sConfigPath = this.theMetadataDispenser.getMetadataUser().getSystemConfigurationPathName();
        String sOutputDocumentName = sConfigPath != null ? sConfigPath + this.theMetadataDispenser.getMetadataUser().getSystemMetadataDocumentName() : this.theMetadataDispenser.getMetadataUser().getSystemMetadataDocumentName();
        if (sOutputDocumentName == null) {
            sOutputDocumentName = "metadata.meta";
        }
        if (this.mode == 1) {
            sOutputDocumentName = this.sFullPathName;
        }
        MetaClass theFirstClass = null;
        MetaClass theLastClass = null;
        MetaClass theClass = this.theMetadataDispenser.theFirstClass;
        while (theClass != null) {
            MetaClassDetail theClassMetadata = new MetaClassDetail(theClass.getMetadata(), this.theMetadataDispenser);
            theClassMetadata.bUsed = true;
            MetaClass theNewClass = new MetaClass(theClassMetadata, this.theMetadataDispenser.theFirstClass, this.theMetadataDispenser, true);
            if (this.theMetadataDispenser.iMode == 1) {
                MetaClassDetail theListener = theClass.theMetadata.theFirstListener;
                while (theListener != null) {
                    int i = 0;
                    String theListenerName = theListener.sClassName;
                    for (i = 0; i < this.theMetadataDispenser.getDefaultListenerCount() && !theListenerName.equals(this.theMetadataDispenser.theListenerCollection.getDefaultListenerName(i)); ++i) {
                    }
                    if (i == this.theMetadataDispenser.getDefaultListenerCount()) {
                        theNewClass.addListener(theListenerName, this.theMetadataDispenser);
                    }
                    theListener = theListener.theNextClass;
                }
            }
            if (theFirstClass == null) {
                theFirstClass = theNewClass;
            } else {
                theLastClass.theNextSibling = theNewClass;
            }
            theLastClass = theNewClass;
            if (theClass.theFirstClass != null) {
                this.doMetaDocChildren(theNewClass, theClass.theFirstClass);
            }
            theClass = theClass.theNextSibling;
        }
        MetadataDocumentGenerator theGenerator = new MetadataDocumentGenerator(sOutputDocumentName, theFirstClass, theLastClass);
        theGenerator.GenerateFromMetadata(this.theMetadataDispenser);
        return true;
    }

    void doMetaDocChildren(MetaClass theParentClass, MetaClass theFirstClass) {
        MetaClass theClass = theFirstClass;
        while (theClass != null) {
            MetaClassDetail theClassMetadata = new MetaClassDetail(theClass.theMetadata, this.theMetadataDispenser);
            theClassMetadata.bUsed = true;
            MetaClass theNewClass = new MetaClass(theClassMetadata, theParentClass, this.theMetadataDispenser, true);
            if (theParentClass.theFirstClass == null) {
                theParentClass.theFirstClass = theNewClass;
            } else {
                theParentClass.theLastClass.theNextSibling = theNewClass;
            }
            theParentClass.theLastClass = theNewClass;
            if (theClass.theFirstClass != null) {
                this.doMetaDocChildren(theNewClass, theClass.theFirstClass);
            }
            theClass = theClass.theNextSibling;
        }
    }

    public boolean isCustomMetadataComplete() {
        return this.bLoadingComplete;
    }

    public void setCustomMetadataComplete(boolean bFlag) {
        this.bLoadingComplete = bFlag;
    }

    public boolean isbAlreadyLoaded() {
        return this.bAlreadyLoaded;
    }

    public void setbAlreadyLoaded(boolean bAlreadyLoaded) {
        this.bAlreadyLoaded = bAlreadyLoaded;
    }
}

