/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.HammerEditorPopupMenu;
import com.ibm.cf.CodeFormatter;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.comedia.text.CAbstractHighlighter;
import org.comedia.text.CJavaHighlighter;
import org.comedia.ui.CSyntaxEditor;

public class HammerSourceEditor
extends CSyntaxEditor {
    Hashtable actions;
    public HammerEditorPopupMenu thePopupMenu = null;
    public static final int UNDO_LIMIT = 1500;
    private UndoManager m_undoManager;
    private int iMaxLine = 74;
    private int iIndent = 2;
    private String sStickyDelims = ",";
    private String sDelims = "(+";

    public HammerSourceEditor() {
        this.setSyntaxHighlighter((CAbstractHighlighter)new CJavaHighlighter());
        this.createActionTable();
        this.getDocument().addUndoableEditListener((UndoableEditListener)((Object)this));
        this.createUndoMananger();
    }

    public HammerSourceEditor(String sDelims, String sStickyDelims, int iIndent, int iMaxLine) {
        this.sDelims = sDelims;
        this.sStickyDelims = sStickyDelims;
        this.iIndent = iIndent;
        this.iMaxLine = iMaxLine;
        this.setSyntaxHighlighter((CAbstractHighlighter)new CJavaHighlighter());
        this.createActionTable();
        this.getDocument().addUndoableEditListener((UndoableEditListener)((Object)this));
        this.createUndoMananger();
    }

    public void setCode(String sText) {
        StringReader theStringReader = new StringReader(sText);
        CodeFormatter theFormatter = new CodeFormatter();
        StringWriter theWriter = new StringWriter(sText.length());
        if (this.sDelims != null) {
            theFormatter.setDelimiters(this.sDelims);
        }
        if (this.sStickyDelims != null) {
            theFormatter.setStickyDelimiters(this.sStickyDelims);
        }
        theFormatter.setIndentationStep(this.iIndent);
        if (this.iMaxLine != 0) {
            theFormatter.setMaxLineLength(this.iMaxLine);
        }
        theFormatter.formatCode((Reader)theStringReader, (Writer)theWriter);
        theStringReader = new StringReader(theWriter.getBuffer().toString());
        try {
            this.read(theStringReader, null);
        }
        catch (IOException e1) {
            // empty catch block
        }
    }

    private void createActionTable() {
        this.actions = new Hashtable();
        Action[] actionsArray = this.getActions();
        for (int i = 0; i < actionsArray.length; ++i) {
            Action a = actionsArray[i];
            String sActionName = (String)a.getValue("Name");
            this.actions.put(sActionName, a);
        }
    }

    public Action getActionByName(String name) {
        return (Action)this.actions.get(name);
    }

    private void createUndoMananger() {
        this.m_undoManager = new UndoManager();
        this.m_undoManager.setLimit(1500);
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        this.m_undoManager.addEdit(e.getEdit());
    }

    public void undo() {
        try {
            this.m_undoManager.undo();
        }
        catch (CannotUndoException cue) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void redo() {
        try {
            this.m_undoManager.redo();
        }
        catch (CannotRedoException cue) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

