/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.HammerLanguagePresentation;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import ch.abacus.lib.ui.renderer.common.MetaType;
import electric.xml.Element;
import electric.xml.Elements;

public class MetaParameter {
    public int theOrder = 0;
    public MetaType theComplexType = null;
    public String theSimpleType = null;
    public MetaPropertyValueEx theValue = null;
    public String theName = null;
    public MetaParameter thePreviousParameter = null;
    public MetaParameter theNextParameter = null;
    boolean bValid = false;
    public MetaProject theDesignProject = null;
    boolean bAllowMultipleLanguages = false;
    boolean bObjectReference = false;

    public MetaParameter() {
    }

    public MetaParameter(int theOrder, MetaType theComplexType, String theName, MetaProject theDesignProject, boolean bAllowMultipleLanguages, boolean bObjectReference) {
        this.theOrder = theOrder;
        this.theComplexType = theComplexType;
        this.theName = theName;
        this.bValid = true;
        this.theDesignProject = theDesignProject;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.bObjectReference = bObjectReference;
    }

    public MetaParameter(int theOrder, MetaType theComplexType, MetaProject theDesignProject, boolean bAllowMultipleLanguages, boolean bObjectReference) {
        this.theOrder = theOrder;
        this.theComplexType = theComplexType;
        this.bValid = true;
        this.theDesignProject = theDesignProject;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.bObjectReference = bObjectReference;
    }

    public MetaParameter(int theOrder, MetaPropertyValueEx objValue, boolean bAllowMultipleLanguages, boolean bObjectReference) {
        this.theOrder = theOrder;
        this.theValue = objValue;
        this.theSimpleType = objValue != null ? MetaPropertyValueEx.translateType(objValue.getType()) : "java.lang.String";
        this.theDesignProject = objValue.theDesignProject;
        this.bValid = true;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.bObjectReference = bObjectReference;
    }

    public MetaParameter(int theOrder, String theSimpleType, String sValue, MetaProject theDesignProject, boolean bAllowMultipleLanguages, boolean bObjectReference) {
        this.theOrder = theOrder;
        this.theSimpleType = theSimpleType;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.bObjectReference = bObjectReference;
        this.theDesignProject = theDesignProject;
        this.theValue = new MetaPropertyValueEx(theSimpleType, sValue, theDesignProject, bAllowMultipleLanguages);
    }

    public MetaParameter(int theOrder, MetaPropertyValueEx objValue, String theName, MetaProject theDesignProject, boolean bAllowMultipleLanguages, boolean bObjectReference) {
        this.theOrder = theOrder;
        if (objValue != null) {
            this.theSimpleType = MetaPropertyValueEx.translateType(objValue.getType());
            objValue.theDesignProject = theDesignProject;
        } else {
            this.theSimpleType = new String("java.lang.String");
        }
        this.theName = theName;
        this.theValue = objValue;
        this.theDesignProject = theDesignProject;
        this.bValid = true;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.bObjectReference = bObjectReference;
    }

    public MetaParameter(MetaType theComplexType, String theName, MetaProject theDesignProject, boolean bAllowMultipleLanguages, boolean bObjectReference) {
        this.theComplexType = theComplexType;
        this.theName = theName;
        this.bValid = true;
        this.theDesignProject = theDesignProject;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.bObjectReference = bObjectReference;
    }

    public MetaParameter(MetaType theComplexType, MetaProject theDesignProject, boolean bAllowMultipleLanguages, boolean bObjectReference) {
        this.theComplexType = theComplexType;
        this.bValid = true;
        this.theDesignProject = theDesignProject;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.bObjectReference = bObjectReference;
    }

    public MetaParameter(MetaPropertyValueEx objValue, MetaProject theDesignProject, boolean bAllowMultipleLanguages, boolean bObjectReference) {
        this.theValue = objValue;
        if (objValue != null) {
            this.theSimpleType = MetaPropertyValueEx.translateType(objValue.getType());
            objValue.theDesignProject = theDesignProject;
        } else {
            this.theSimpleType = new String("java.lang.String");
        }
        this.theDesignProject = theDesignProject;
        this.bValid = true;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.bObjectReference = bObjectReference;
    }

    public MetaParameter(String theSimpleType, String sValue, MetaProject theDesignProject, boolean bAllowMultipleLanguages, boolean bObjectReference) {
        this.theSimpleType = theSimpleType;
        this.theDesignProject = theDesignProject;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.theValue = new MetaPropertyValueEx(theSimpleType, sValue, theDesignProject, bAllowMultipleLanguages);
        this.bObjectReference = bObjectReference;
    }

    public MetaParameter searchParameterTree(String sShortName) {
        MetaParameter theTestParameter = this;
        while (theTestParameter != null) {
            if (sShortName.equals(this.theName)) {
                return theTestParameter;
            }
            if (this.theComplexType != null) {
                MetaParameter testSubParameter = this.theComplexType.theFirstParameter;
                while (testSubParameter != null) {
                    if (sShortName.equals(testSubParameter.theName)) {
                        return testSubParameter;
                    }
                    testSubParameter = testSubParameter.theNextParameter;
                }
            }
            theTestParameter = theTestParameter.theNextParameter;
        }
        return null;
    }

    public void set(String sType, String sValue, MetaProject theDesignProject) {
        if (this.theValue == null) {
            this.theValue = new MetaPropertyValueEx(sType, sValue, theDesignProject, this.bAllowMultipleLanguages);
        } else {
            this.theValue.setLocalString(sValue);
            this.theValue.theDesignProject = theDesignProject;
        }
    }

    public void set(String sType, String sValue, boolean bCast, MetaProject theDesignProject) {
        if (this.theValue == null) {
            this.theValue = new MetaPropertyValueEx(sType, sValue, bCast, theDesignProject, this.bAllowMultipleLanguages);
        } else {
            this.theValue.setLocalString(sValue);
            this.theValue.theDesignProject = theDesignProject;
        }
    }

    public void attachToProject(MetaProject theProj) {
        this.theDesignProject = theProj;
        if (this.theValue != null) {
            this.theValue.theDesignProject = theProj;
        }
        if (this.theComplexType != null) {
            this.theComplexType.attachToProject(theProj);
        }
    }

    public boolean save(Element theParent) {
        Element xmlParameter = new Element("Parameter");
        theParent.addElement(xmlParameter);
        Element xmlOrder = new Element("Order");
        xmlOrder.setText(new Integer(this.theOrder).toString());
        if (this.theName != null && this.theName.length() > 0) {
            Element xmlName = new Element("Name");
            xmlName.setText(this.theName);
            xmlParameter.addElement(xmlName);
        }
        xmlParameter.addElement(xmlOrder);
        if (this.bObjectReference) {
            Element xmlObjRef = new Element("ObjectReference");
            xmlParameter.addElement(xmlObjRef);
        }
        if (this.theComplexType != null) {
            this.theComplexType.save(xmlParameter);
        } else {
            Element xmlSimpleType = new Element("SimpleType");
            xmlSimpleType.setText(this.theSimpleType);
            xmlParameter.addElement(xmlSimpleType);
        }
        if (this.theValue != null) {
            if (this.theValue.getLanguageCount() == 1 || !this.bAllowMultipleLanguages) {
                Element xmlValue = new Element("Value");
                xmlValue.setText(this.theValue.getStringValue());
                xmlParameter.addElement(xmlValue);
            } else {
                String sDefaultValue = this.theValue.getLanguageDependentValue(0);
                for (int iLang = 0; iLang <= 3; ++iLang) {
                    HammerLanguagePresentation thisLanguage = this.theValue.theDesignProject.getLanguage(iLang);
                    if (thisLanguage == null) continue;
                    String sLanguageValue = this.theValue.getLanguageDependentValue(iLang);
                    if (iLang != 0 && sLanguageValue.equals(sDefaultValue)) continue;
                    thisLanguage.saveValue(xmlParameter, sLanguageValue);
                }
            }
        }
        return true;
    }

    public boolean load(Element theElement, int iOldVersionFixIndex) {
        Element xmlObjectReference;
        Element xmlOrder = theElement.getElement("Order");
        String sOrder = xmlOrder.getTextString();
        this.theOrder = new Integer(sOrder);
        if (this.theDesignProject.needsFixed()) {
            this.theOrder = iOldVersionFixIndex;
        }
        this.bObjectReference = (xmlObjectReference = theElement.getElement("ObjectReference")) != null;
        Element xmlType = theElement.getElement("Type");
        if (xmlType != null) {
            this.theComplexType = new MetaType(this.theDesignProject);
            this.theComplexType.load(xmlType);
        } else {
            Element xmlSimpleType = theElement.getElement("SimpleType");
            this.theSimpleType = xmlSimpleType != null ? xmlSimpleType.getTextString() : "java.lang.String";
            Elements xmlLanguages = theElement.getElements("Language");
            if (xmlLanguages == null || xmlLanguages.size() == 0) {
                Element xmlValue = theElement.getElement("Value");
                String sValue = null;
                if (xmlValue != null) {
                    sValue = xmlValue.getTextString();
                }
                if (sValue == null) {
                    sValue = new String("");
                }
                this.theValue = new MetaPropertyValueEx(this.theSimpleType, sValue, this.theDesignProject, false);
            } else {
                String[] theValues = new String[4];
                Element xmlLanguage = xmlLanguages.next();
                while (xmlLanguage != null) {
                    int theLanguage = 0;
                    String theAttribute = xmlLanguage.getAttribute("Name");
                    try {
                        Integer theValue = new Integer(theAttribute);
                        theLanguage = theValue;
                    }
                    catch (NumberFormatException e1) {
                        // empty catch block
                    }
                    HammerLanguagePresentation thisLanguage = this.theDesignProject.getLanguage(theLanguage);
                    theValues = thisLanguage.loadValue(xmlLanguage, theValues);
                    xmlLanguage = xmlLanguages.next();
                }
                this.theValue = new MetaPropertyValueEx(this.theSimpleType, theValues, this.theDesignProject, true);
                this.bAllowMultipleLanguages = true;
            }
        }
        Element xmlName = theElement.getElement("Name");
        if (xmlName != null) {
            this.theName = xmlName.getTextString();
        }
        return true;
    }

    public MetaParameter Clone() {
        if (this.theComplexType != null) {
            return new MetaParameter(this.theOrder, this.theComplexType.Clone(), this.theName, this.theDesignProject, this.bAllowMultipleLanguages, this.bObjectReference);
        }
        MetaParameter newParameter = new MetaParameter(this.theOrder, this.theValue != null ? this.theValue.Clone() : null, this.theName, this.theDesignProject, this.bAllowMultipleLanguages, this.bObjectReference);
        newParameter.theSimpleType = this.theSimpleType;
        return newParameter;
    }

    public Object Create() {
        if (this.theSimpleType != null) {
            return this.theValue;
        }
        return this.theComplexType.Create(null, null);
    }

    public String getLiteralValue() {
        if (this.theSimpleType != null) {
            return this.theValue.getStringValue();
        }
        return this.theComplexType.getLiteralValue();
    }

    public void setMnemonic() {
        if (this.theSimpleType != null) {
            this.theValue.setMnemonic();
        } else {
            this.theComplexType.setMnemonic();
        }
    }

    public boolean getMnemonic() {
        if (this.theSimpleType != null) {
            return this.theValue.bMnemonic;
        }
        return this.theComplexType.getMnemonic();
    }
}

