/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.abaRenderer.AbaRenderer;
import ch.abacus.lib.ui.renderer.common.AbaMetaDataUser;
import ch.abacus.lib.ui.renderer.common.AbaNLS;
import ch.abacus.lib.ui.renderer.common.CompressedProjectDocument;
import ch.abacus.lib.ui.renderer.common.EnumerateProjectMetaObjectInterface;
import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.HammerJarAccess;
import ch.abacus.lib.ui.renderer.common.HammerLanguagePresentation;
import ch.abacus.lib.ui.renderer.common.HammerNLSAccess;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaClassDetail;
import ch.abacus.lib.ui.renderer.common.MetaCloneMode;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaProjectHeader;
import ch.abacus.lib.ui.renderer.common.MetadataAdministrator;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import ch.abacus.lib.ui.renderer.common.ProjectDocument;
import ch.abacus.lib.ui.renderer.common.generator.ProjectCodeGenerator;
import ch.abacus.lib.ui.renderer.droplets.DropletSimpleLog;
import ch.abacus.lib.util.GlobalInterface;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class MetaProject {
    public String sName = "";
    public String sAuthor = "";
    public String sDocumentVersion = "";
    public String sHammerVersion = "0";
    public String sRendererVersion = "";
    public GlobalInterface theGlobalInterface = null;
    public AbaNLS theNLSSupport = new AbaNLS(this);
    public ArrayList theLocalNLSDocuments = new ArrayList(0);
    public String sHammerRevision = "0";
    public String sHammerSubRevision = "0";
    public String sHammerBuild = "0";
    public String sGenLookFeelName = "Default";
    private boolean isNLSTranslation = true;
    private boolean bGenerateAccessor = true;
    private String AdditionalImports = "";
    private String sRepositPath = "";
    public long lHammerVersionFactor = 0L;
    public Class renderingClass = null;
    private static final long FIX_ORDER_IN_PARAMETERS = MetaProject.calculateProjectFactor("0", "4", "1");
    public static final int DEFAULT_LOOK = 0;
    public static final int PLASTICXP_LOOK = 1;
    public static final int PLASTIC3D_LOOK = 2;
    public static final int PLASTIC_LOOK = 3;
    MetadataDispenser theMetadataDispenser;
    private ArrayList objList = new ArrayList();
    private String sDirectoryName = "";
    private ProjectCodeGenerator codeGenerator;
    private String declVariablePrefix;
    MetaClass theFirstClass = null;
    MetaClass theLastClass = null;
    MetaClass theFirstListener = null;
    MetaClass theLastListener = null;
    int iListenerCount = 0;
    Document xmlSystemDocument = null;
    MetaConstantGroup theFirstMetaConstantGroup = null;
    MetaConstantGroup theLastMetaConstantGroup = null;
    MetaConstantGroupCollection theFirstMetaConstantGroupCollection = null;
    MetaConstantGroupCollection theLastMetaConstantGroupCollection = null;
    protected MetadataAdministrator theMetaDataAdministrator;
    public int iMetadataVersion = 0;
    public int iMetadataRevision = 0;
    public int iMetadataSubrevision = 0;
    public int iMetadataBuild = 0;
    public MetaProjectHeader theProgramData = null;
    MetaProject thePrevDesignProject = null;
    MetaProject theNextDesignProject = null;
    Document xmlProjectDocument = null;
    public int iInputType = 0;
    public static final int UNDEFINED_INPUT_TYPE = 0;
    public static final int FROM_XML_DOCUMENT = 1;
    public static final int FROM_RESOURCE = 2;
    public static final int FROM_STRING = 3;
    public static final int FROM_CLASS = 4;
    public int iMode = 0;
    private AbaMetaDataUser theMetaDataUser = null;
    public Object theClassLoader = null;
    HammerLanguagePresentation theCurrentLanguage = null;
    HammerLanguagePresentation theFirstLanguage = null;
    HammerLanguagePresentation theLastLanguage = null;
    boolean bChanged = false;
    HammerJarAccess theJarAccess = null;
    MetaObject theFirstObject = null;
    MetaObject theLastObject = null;

    public MetadataDispenser getMetadataDispenser() {
        return this.theMetadataDispenser;
    }

    public void setFirstClass(MetaClass theFirstClass) {
        this.theMetadataDispenser.setFirstClass(theFirstClass);
    }

    public MetaClass getLastClass() {
        return this.theMetadataDispenser.getLastClass();
    }

    public MetaClass getFirstClass() {
        return this.theMetadataDispenser.getFirstClass();
    }

    public void setLastClass(MetaClass theLastClass) {
        this.theMetadataDispenser.setLastClass(theLastClass);
    }

    public MetaClass getFirstListener() {
        return this.theMetadataDispenser.getFirstListener();
    }

    public void setFirstListener(MetaClass theFirstListener) {
        this.theMetadataDispenser.setFirstListener(theFirstListener);
    }

    public MetaClass getLastListener() {
        return this.theMetadataDispenser.getLastListener();
    }

    public void setLastListener(MetaClass theLastListener) {
        this.theMetadataDispenser.setLastListener(theLastListener);
    }

    public int getiListenerCount() {
        return this.theMetadataDispenser.getListenerCount();
    }

    public void setiListenerCount(int iListenerCount) {
        this.theMetadataDispenser.setListenerCount(iListenerCount);
    }

    public MetaConstantGroup getFirstMetaConstantGroup() {
        return this.theFirstMetaConstantGroup;
    }

    public void setFirstMetaConstantGroup(MetaConstantGroup theFirstMetaConstantGroup) {
        this.theFirstMetaConstantGroup = theFirstMetaConstantGroup;
    }

    public MetaConstantGroup getLastMetaConstantGroup() {
        return this.theLastMetaConstantGroup;
    }

    public void setLastMetaConstantGroup(MetaConstantGroup theLastMetaConstantGroup) {
        this.theLastMetaConstantGroup = theLastMetaConstantGroup;
    }

    public MetaConstantGroupCollection getFirstMetaConstantGroupCollection() {
        return this.theFirstMetaConstantGroupCollection;
    }

    public void setFirstMetaConstantGroupCollection(MetaConstantGroupCollection theFirstMetaConstantGroupCollection) {
        this.theFirstMetaConstantGroupCollection = theFirstMetaConstantGroupCollection;
    }

    public MetaConstantGroupCollection getLastMetaConstantGroupCollection() {
        return this.theLastMetaConstantGroupCollection;
    }

    public void setLastMetaConstantGroupCollection(MetaConstantGroupCollection theLastMetaConstantGroupCollection) {
        this.theLastMetaConstantGroupCollection = theLastMetaConstantGroupCollection;
    }

    public MetaProject(int iMode, GlobalInterface theGlobalInterface, Object theClassLoader, MetadataDispenser theMetadataDispenser) throws HammerException {
        this.iMode = iMode;
        this.theMetadataDispenser = theMetadataDispenser;
        this.theGlobalInterface = theGlobalInterface;
        this.theClassLoader = theClassLoader;
        this.setCurrentLanguage(0);
    }

    public MetaProject(int iMode, GlobalInterface theGlobalInterface, Object theClassLoader, MetadataDispenser theMetadataDispenser, MetaProject templateProject) throws HammerException {
        this.iMode = iMode;
        this.theMetadataDispenser = theMetadataDispenser;
        this.theGlobalInterface = theGlobalInterface;
        this.theClassLoader = theClassLoader;
        this.setCurrentLanguage(0);
        this.sAuthor = templateProject.sAuthor;
        this.sDocumentVersion = templateProject.sDocumentVersion;
        this.sHammerVersion = templateProject.sHammerVersion;
        this.sName = templateProject.sName;
        this.sRendererVersion = templateProject.sRendererVersion;
        this.theGlobalInterface = templateProject.theGlobalInterface;
        this.theMetaDataUser = templateProject.theMetaDataUser;
        String SystemDocumentPath = this.theMetaDataUser.getSystemConfigurationPathName() + this.theMetaDataUser.getSystemMetadataDocumentName();
        if (SystemDocumentPath == null) {
            SystemDocumentPath = "metadata.meta";
        }
        boolean bTest = this.loadMeta(SystemDocumentPath);
        String repositoryPath = this.theMetaDataUser.getConfigurationManager().getConfigurationVariable("RepositoryPath");
        if (repositoryPath != null) {
            this.loadCustomMeta(SystemDocumentPath, repositoryPath);
        }
        if (bTest) {
            this.getNLS().Load(templateProject);
            MetaObject theObject = templateProject.theFirstObject;
            while (theObject != null) {
                MetaObject theNewObject = theObject.Clone(new MetaCloneMode(0), null, true);
                theNewObject.attachToProject(this);
                theNewObject.recursiveModeSet(2);
                this.addObject(theNewObject);
                theObject = theObject.theNextObject;
            }
        }
    }

    private void loadMeta(MetaClass theParent, MetaClass srcClass) {
        while (srcClass != null) {
            MetaClass newClass = theParent.addInstanceTracker(srcClass);
            newClass.theParentClass = theParent;
            if (srcClass.theFirstClass != null) {
                this.loadMeta(newClass, srcClass.theFirstClass);
            }
            srcClass = srcClass.theNextSibling;
        }
    }

    public boolean loadMeta(DropletSimpleLog theLog, String systemDocumentPath) {
        boolean bRetValue = this.theMetadataDispenser.theMetadataDocument.loadMeta(theLog, systemDocumentPath);
        MetaClass srcClass = this.theMetadataDispenser.theFirstClass;
        while (srcClass != null) {
            MetaClass newClass = this.addInstanceTracker(srcClass);
            if (srcClass.theFirstClass != null) {
                this.loadMeta(newClass, srcClass.theFirstClass);
            }
            srcClass = srcClass.theNextSibling;
        }
        return bRetValue;
    }

    public boolean loadMeta(String systemDocumentPath) {
        return this.loadMeta(null, systemDocumentPath);
    }

    public void resetMetadata() {
        try {
            this.theMetadataDispenser = new MetadataDispenser(this.theMetadataDispenser.theUser, this.theMetadataDispenser.getGlobalInterface(), 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean loadCustomMeta(String systemDocumentPath, String repositoryPath) {
        this.sRepositPath = repositoryPath;
        boolean bRetValue = this.theMetadataDispenser.theMetadataDocument.loadCustomMeta(systemDocumentPath, repositoryPath);
        MetaClass srcClass = this.theMetadataDispenser.theFirstClass;
        while (srcClass != null) {
            MetaClass newClass = this.addInstanceTracker(srcClass);
            if (srcClass.theFirstClass != null) {
                this.loadMeta(newClass, srcClass.theFirstClass);
            }
            srcClass = srcClass.theNextSibling;
        }
        this.theMetadataDispenser.theMetadataDocument.setCustomMetadataComplete(true);
        return bRetValue;
    }

    public int getInputType() {
        return this.iInputType;
    }

    public void setInputType(int iInputType) {
        this.iInputType = iInputType;
    }

    public MetaObject getFirstObject() {
        return this.theFirstObject;
    }

    public MetaObject getLastObject() {
        return this.theLastObject;
    }

    public void setFirstObject(MetaObject someObject) {
        this.theFirstObject = someObject;
    }

    public void setLastObject(MetaObject someObject) {
        this.theLastObject = someObject;
    }

    public String getName() {
        return this.sName;
    }

    public AbaNLS getNLS() {
        return this.theNLSSupport;
    }

    public void setNLS(AbaNLS theNLS) {
        this.theNLSSupport = theNLS;
    }

    public void setCurrentLanguage(int theLanguage) {
        HammerLanguagePresentation testLanguage = this.theFirstLanguage;
        while (testLanguage != null) {
            if (testLanguage.theLanguage == theLanguage) {
                this.theCurrentLanguage = testLanguage;
                break;
            }
            testLanguage = testLanguage.theNextLanguage;
        }
        if (testLanguage == null) {
            HammerLanguagePresentation theNewLanguage = new HammerLanguagePresentation(theLanguage, this);
            this.addLanguage(theNewLanguage);
            this.theCurrentLanguage = theNewLanguage;
        }
    }

    public HammerLanguagePresentation getLanguage(int iLang) {
        HammerLanguagePresentation theLang = this.theFirstLanguage;
        while (theLang != null) {
            if (theLang.theLanguage == iLang) {
                return theLang;
            }
            theLang = theLang.theNextLanguage;
        }
        return null;
    }

    public void addLanguage(HammerLanguagePresentation theLanguagePresentation) {
        if (this.theFirstLanguage == null) {
            this.theFirstLanguage = theLanguagePresentation;
        } else {
            this.theLastLanguage.theNextLanguage = theLanguagePresentation;
            theLanguagePresentation.thePreviousLanguage = this.theLastLanguage;
        }
        this.theLastLanguage = theLanguagePresentation;
    }

    private MetaObject findObject(MetaObject theObject, String sObjectName) {
        while (theObject != null) {
            if (theObject.getName().equals(sObjectName)) {
                return theObject;
            }
            MetaObject theChildMatch = this.findObject(theObject.theFirstChild, sObjectName);
            if (theChildMatch != null) {
                return theChildMatch;
            }
            theObject = theObject.theNextObject;
        }
        return null;
    }

    public MetaObject findObject(String sObjectName) {
        MetaObject theObject = this.theFirstObject;
        while (theObject != null) {
            if (theObject.getName().equals(sObjectName)) {
                return theObject;
            }
            MetaObject theChildMatch = this.findObject(theObject.theFirstChild, sObjectName);
            if (theChildMatch != null) {
                return theChildMatch;
            }
            theObject = theObject.theNextObject;
        }
        return null;
    }

    public void enumerateObjects(EnumerateProjectMetaObjectInterface callbackObject, MetaObject startingObject) {
        if (startingObject == null) {
            return;
        }
        do {
            callbackObject.callbackProjectMetaObject(startingObject);
            if (startingObject.theFirstChild == null) continue;
            this.enumerateObjects(callbackObject, startingObject.theFirstChild);
        } while ((startingObject = startingObject.theNextObject) != null);
    }

    private MetaObject findObjectByClass(MetaObject theObject, String sClasstName) {
        while (theObject != null) {
            String sFullName = theObject.theType.theFullName;
            if (sFullName.equals(sClasstName)) {
                this.objList.add(theObject);
            }
            MetaObject theChildMatch = this.findObjectByClass(theObject.theFirstChild, sClasstName);
            theObject = theObject.theNextObject;
        }
        return null;
    }

    public ArrayList findObjectsByClass(String sObjectClass) {
        MetaObject theObject = this.theFirstObject;
        this.objList.clear();
        while (theObject != null) {
            String sFullName = theObject.theType.theFullName;
            if (sFullName.equals(sObjectClass)) {
                this.objList.add(theObject);
            }
            if (theObject.theFirstChild != null) {
                this.findObjectByClass(theObject, sObjectClass);
            }
            theObject = theObject.theNextObject;
        }
        return this.objList;
    }

    public String getNewObjectName(String sClassName) {
        int i = 1;
        while (true) {
            Integer iValue = new Integer(i);
            String sObjectName = sClassName + iValue.toString();
            if (this.findObject(sObjectName) == null) {
                return sObjectName;
            }
            ++i;
        }
    }

    public MetaClass addInstanceTracker(MetaClass srcClass) {
        MetaClass newClass = srcClass.emptyClone();
        newClass.theParentClass = null;
        if (this.theLastClass == null) {
            this.theFirstClass = newClass;
        } else {
            newClass.thePrevSibling = this.theLastClass;
            this.theLastClass.theNextSibling = newClass;
        }
        this.theLastClass = newClass;
        return newClass;
    }

    public MetaClass findInstanceTracker(MetaClass theClass, String sClassName) {
        while (theClass != null) {
            MetaClass testClass;
            if (theClass.theMetadata.sClassName.equals(sClassName)) {
                return theClass;
            }
            if (theClass.theFirstClass != null && (testClass = this.findClass(theClass.theFirstClass, sClassName)) != null) {
                return testClass;
            }
            theClass = theClass.theNextSibling;
        }
        return null;
    }

    public MetaClass findInstanceTracker(String sClassName) {
        MetaClass theClass = this.theFirstClass;
        while (theClass != null) {
            MetaClass testClass;
            if (theClass.theMetadata.sClassName.equals(sClassName)) {
                return theClass;
            }
            if (theClass.theFirstClass != null && (testClass = this.findClass(theClass.theFirstClass, sClassName)) != null) {
                return testClass;
            }
            theClass = theClass.theNextSibling;
        }
        return null;
    }

    public MetaClass addClass(Element theClassDescriptor) {
        MetaClass newChild = this.theMetadataDispenser.addClass(theClassDescriptor);
        this.addInstanceTracker(newChild);
        return newChild;
    }

    public void addClass(MetaClass newChild) {
        this.theMetadataDispenser.addClass(newChild);
        this.addInstanceTracker(newChild);
    }

    public MetaClass findClass(MetaClass theClass, String sClassName) {
        return this.theMetadataDispenser.findClass(theClass, sClassName);
    }

    public MetaClass findClass(String sClassName) {
        return this.theMetadataDispenser.findClass(sClassName);
    }

    public MetaClass findClassLogged(DropletSimpleLog theLog, String sClassName) {
        return this.theMetadataDispenser.findClass(theLog, sClassName);
    }

    public MetaClass findListener(MetaClass theListener, String sListenerName) {
        return this.theMetadataDispenser.findListener(theListener, sListenerName);
    }

    public MetaClass findListener(String sListenerName) {
        return this.theMetadataDispenser.findListener(sListenerName);
    }

    public MetaClassDetail getNewListener(String sListenerName) {
        return this.theMetadataDispenser.getNewListener(sListenerName);
    }

    public MetaClassDetail getNewDefaultListener(int iIndex) {
        return this.theMetadataDispenser.getNewDefaultListener(iIndex);
    }

    public int getListenerCount() {
        return this.theMetadataDispenser.getListenerCount();
    }

    public MetaConstantGroup findConstantGroup(String sGroupName) {
        return this.theMetadataDispenser.findConstantGroup(sGroupName);
    }

    public MetaConstantGroupCollection findConstantGroupCollection(String sGroupName) {
        return this.theMetadataDispenser.findConstantGroupCollection(sGroupName);
    }

    public Border getDesignBorder() {
        Object obj = null;
        try {
            obj = MetaConstantGroup.resolve(this.theMetadataDispenser.sDesignBorderDefinition, this.theMetadataDispenser, this.theMetaDataUser.getClassLoader().getLoader());
        }
        catch (HammerException e) {
            return new LineBorder(Color.BLUE);
        }
        if (obj instanceof Border) {
            return (Border)obj;
        }
        return new LineBorder(Color.BLUE);
    }

    public int getDefaultListenerCount() {
        return this.theMetadataDispenser.getDefaultListenerCount();
    }

    public int getContainerListener() {
        return this.theMetadataDispenser.theListenerCollection.getContainerListener();
    }

    public boolean findChildObjectByName(String sObjectName) {
        MetaObject theChild = this.theFirstObject;
        while (theChild != null) {
            if (theChild.getName().equals(sObjectName)) {
                return true;
            }
            theChild = theChild.theNextObject;
        }
        return false;
    }

    public boolean save(MetaProjectHeader progInfo, Element theParent) {
        if (this.iMode == 1) {
            this.setProjectChangedState(false);
            Element xmlProject = new Element("Project");
            theParent.addElement(xmlProject);
            Element xmlName = new Element("Name");
            xmlName.setText(this.getName());
            xmlProject.addElement(xmlName);
            Element xmlAuthor = new Element("Author");
            xmlAuthor.setText(progInfo.sAuthor);
            xmlProject.addElement(xmlAuthor);
            Element xmlDeclVariablePrefix = new Element("DeclVariablePrefix");
            xmlDeclVariablePrefix.setText(this.getDeclVariablePrefix());
            xmlProject.addElement(xmlDeclVariablePrefix);
            if (this.getMetaDataUser().getOpenSourceState()) {
                Element xmlGenCodeLookFeel = new Element("GeneratedCodeLookAndFeel");
                xmlGenCodeLookFeel.setText(progInfo.sGenLookFeelName == null ? this.sGenLookFeelName : progInfo.sGenLookFeelName);
                xmlProject.addElement(xmlGenCodeLookFeel);
                Element xmlAdditionalImports = new Element("AdditionalImports");
                xmlAdditionalImports.setText(this.AdditionalImports);
                xmlProject.addElement(xmlAdditionalImports);
            }
            if (!this.isNLSTranslation) {
                Element xmlNLSTranslationOff = new Element("NLSTranslationOff");
                xmlNLSTranslationOff.setText(xmlNLSTranslationOff.getTextString());
                xmlProject.addElement(xmlNLSTranslationOff);
            }
            if (!this.bGenerateAccessor) {
                Element xmlGenerateAccessor = new Element("GenerateAccessorOff");
                xmlGenerateAccessor.setText(xmlGenerateAccessor.getTextString());
                xmlProject.addElement(xmlGenerateAccessor);
            }
            Element xmlDocumentVersion = new Element("DocumentVersion");
            this.sDocumentVersion = this.sDocumentVersion == null || this.sDocumentVersion.trim().length() == 0 ? "1" : new Integer(new Integer(this.sDocumentVersion) + 1).toString();
            xmlDocumentVersion.setText(this.sDocumentVersion);
            xmlProject.addElement(xmlDocumentVersion);
            Element xmlHammerVersion = new Element("HammerVersion");
            xmlHammerVersion.setText(new Integer(this.theMetaDataUser.getVersionNumber()).toString());
            xmlProject.addElement(xmlHammerVersion);
            Element xmlHammerRevision = new Element("HammerRevision");
            xmlHammerRevision.setText(new Integer(this.theMetaDataUser.getRevisionNumber()).toString());
            xmlProject.addElement(xmlHammerRevision);
            Element xmlHammerSubRevision = new Element("HammerSubRevision");
            xmlHammerSubRevision.setText(new Integer(this.theMetaDataUser.getSubRevisionNumber()).toString());
            xmlProject.addElement(xmlHammerSubRevision);
            Element xmlHammerBuild = new Element("HammerBuild");
            xmlHammerBuild.setText(new Integer(this.theMetaDataUser.getBuildNumber()).toString());
            xmlProject.addElement(xmlHammerBuild);
            Element xmlRendererVersion = new Element("RendererVersion");
            xmlRendererVersion.setText(this.sRendererVersion);
            xmlProject.addElement(xmlRendererVersion);
            Element xmlMetadataVersion = new Element("MetadataVersion");
            Element xmlMetadataVersionNumber = new Element("MetadataVersionNumber");
            Element xmlMetadataRevisionNumber = new Element("MetadataRevisionNumber");
            Element xmlMetadataSubrevisionNumber = new Element("MetadataSubrevisionNumber");
            Element xmlMetadataBuildNumber = new Element("MetadataBuildNumber");
            if (this.theMetaDataAdministrator != null) {
                xmlMetadataVersionNumber.setText(new Integer(this.theMetaDataAdministrator.iVersionNumber).toString());
                xmlMetadataRevisionNumber.setText(new Integer(this.theMetaDataAdministrator.iRevisionNumber).toString());
                xmlMetadataSubrevisionNumber.setText(new Integer(this.theMetaDataAdministrator.iSubrevisionNumber).toString());
                xmlMetadataBuildNumber.setText(new Integer(this.theMetaDataAdministrator.iBuildNumber).toString());
            } else {
                xmlMetadataVersionNumber.setText(new Integer(this.iMetadataVersion).toString());
                xmlMetadataRevisionNumber.setText(new Integer(this.iMetadataRevision).toString());
                xmlMetadataSubrevisionNumber.setText(new Integer(this.iMetadataSubrevision).toString());
                xmlMetadataBuildNumber.setText(new Integer(this.iMetadataBuild).toString());
            }
            xmlMetadataVersion.addElement(xmlMetadataVersionNumber);
            xmlMetadataVersion.addElement(xmlMetadataRevisionNumber);
            xmlMetadataVersion.addElement(xmlMetadataSubrevisionNumber);
            xmlMetadataVersion.addElement(xmlMetadataBuildNumber);
            xmlProject.addElement(xmlMetadataVersion);
            Date dRightNow = new Date();
            SimpleDateFormat abaDateFormat = new SimpleDateFormat("E yyyy.MM.dd hh:mm:ss a zzz");
            Element xmlTimeStamp = new Element("TimeStamp");
            xmlTimeStamp.setText(abaDateFormat.format(dRightNow));
            xmlProject.addElement(xmlTimeStamp);
            HammerLanguagePresentation theLanguage = this.theFirstLanguage;
            if (theLanguage == null) {
                theLanguage = new HammerLanguagePresentation(0, this);
                Element xmlLanguage = new Element("Language");
                xmlProject.addElement(xmlLanguage);
                xmlLanguage.setAttribute("Name", new Integer(theLanguage.theLanguage).toString());
            } else {
                while (theLanguage != null) {
                    theLanguage.save(xmlProject);
                    theLanguage = theLanguage.theNextLanguage;
                }
            }
            if (this.theLocalNLSDocuments != null && this.theLocalNLSDocuments.size() > 0) {
                Element xmlLocalNLSDocs = new Element("LocalNLSDocuments");
                if (xmlLocalNLSDocs != null) {
                    for (int i = 0; i < this.theLocalNLSDocuments.size(); ++i) {
                        HammerNLSAccess theAccess = (HammerNLSAccess)this.theLocalNLSDocuments.get(i);
                        Element xmlLocalNLSDoc = new Element("LocalNLSDocument");
                        Element xmlDocKey = new Element("Key");
                        Element xmlDocPath = new Element("Path");
                        xmlDocKey.setText(theAccess.sKey);
                        xmlDocPath.setText(theAccess.sDocument);
                        xmlLocalNLSDoc.addElement(xmlDocKey);
                        xmlLocalNLSDoc.addElement(xmlDocPath);
                        xmlLocalNLSDocs.addElement(xmlLocalNLSDoc);
                    }
                }
                xmlProject.addElement(xmlLocalNLSDocs);
            }
            MetaObject theObject = this.theFirstObject;
            while (theObject != null) {
                theObject.save(xmlProject);
                theObject = theObject.theNextObject;
            }
        }
        return true;
    }

    public boolean load(Element theElement) {
        Element xmlHammerBuild;
        Element xmlHammerSubRevision;
        Element xmlHammerRevision;
        Element xmlDeclVariablePrefix;
        Element xmlGenerateAccessorOff;
        Element xmlNLSTranslationOff;
        Element xmlName = theElement.getElement("Name");
        this.sName = xmlName.getTextString();
        Element xmlAuthor = theElement.getElement("Author");
        this.sAuthor = xmlAuthor.getTextString();
        if (this.getMetaDataUser().getOpenSourceState()) {
            Element xmlAdditionalImports;
            Element xmlGenCodeLAF = theElement.getElement("GeneratedCodeLookAndFeel");
            if (xmlGenCodeLAF != null) {
                this.sGenLookFeelName = xmlGenCodeLAF.getTextString();
            }
            if ((xmlAdditionalImports = theElement.getElement("AdditionalImports")) != null) {
                this.AdditionalImports = xmlAdditionalImports.getTextString();
            }
            if (this.AdditionalImports == null) {
                this.AdditionalImports = new String();
            }
        }
        if ((xmlNLSTranslationOff = theElement.getElement("NLSTranslationOff")) != null) {
            this.isNLSTranslation = false;
        }
        if ((xmlGenerateAccessorOff = theElement.getElement("GenerateAccessorOff")) != null) {
            this.bGenerateAccessor = false;
        }
        if ((xmlDeclVariablePrefix = theElement.getElement("DeclVariablePrefix")) != null) {
            this.setDeclVariablePrefix(xmlDeclVariablePrefix.getTextString());
        }
        Element xmlDocumentVersion = theElement.getElement("DocumentVersion");
        this.sDocumentVersion = xmlDocumentVersion.getTextString();
        Element xmlHammerVersion = theElement.getElement("HammerVersion");
        if (xmlHammerVersion != null) {
            this.sHammerVersion = xmlHammerVersion.getTextString();
        }
        if ((xmlHammerRevision = theElement.getElement("HammerRevision")) != null) {
            this.sHammerRevision = xmlHammerRevision.getTextString();
        }
        if ((xmlHammerSubRevision = theElement.getElement("HammerSubRevision")) != null) {
            this.sHammerSubRevision = xmlHammerSubRevision.getTextString();
        }
        if ((xmlHammerBuild = theElement.getElement("HammerBuild")) != null) {
            this.sHammerBuild = xmlHammerBuild.getTextString();
        }
        this.lHammerVersionFactor = MetaProject.calculateProjectFactor(this.sHammerVersion, this.sHammerRevision, this.sHammerSubRevision);
        Element xmlRendererVersion = theElement.getElement("RendererVersion");
        this.sRendererVersion = xmlRendererVersion.getTextString();
        Element xmlMetadataVersion = theElement.getElement("MetadataVersion");
        if (xmlMetadataVersion != null) {
            Element xmlMetadataVersionNumber = xmlMetadataVersion.getElement("MetadataVersionNumber");
            Element xmlMetadataRevisionNumber = xmlMetadataVersion.getElement("MetadataRevisionNumber");
            Element xmlMetadataSubrevisionNumber = xmlMetadataVersion.getElement("MetadataSubrevisionNumber");
            Element xmlMetadataBuildNumber = xmlMetadataVersion.getElement("MetadataBuildNumber");
            this.iMetadataRevision = new Integer(xmlMetadataRevisionNumber.getTextString());
            this.iMetadataSubrevision = new Integer(xmlMetadataSubrevisionNumber.getTextString());
            this.iMetadataBuild = new Integer(xmlMetadataBuildNumber.getTextString());
            this.iMetadataVersion = new Integer(xmlMetadataVersionNumber.getTextString());
        }
        Elements xmlLanguages = theElement.getElements("Language");
        Element xmlLanguage = xmlLanguages.next();
        while (xmlLanguage != null) {
            int iLanguage = 0;
            HammerLanguagePresentation theLanguage = this.theFirstLanguage;
            String theAttribute = xmlLanguage.getAttribute("Name");
            try {
                Integer theValue = new Integer(theAttribute);
                iLanguage = theValue;
            }
            catch (NumberFormatException e1) {
                // empty catch block
            }
            if (iLanguage != 0) {
                theLanguage = new HammerLanguagePresentation();
            }
            theLanguage.theDesignProject = this;
            theLanguage.load(xmlLanguage);
            if (theLanguage.theLanguage != 0) {
                this.addLanguage(theLanguage);
            }
            xmlLanguage = xmlLanguages.next();
        }
        this.theCurrentLanguage = this.theFirstLanguage;
        Element xmlLocalNLSDocs = theElement.getElement("LocalNLSDocuments");
        if (xmlLocalNLSDocs != null) {
            Elements theConfigurationElements = xmlLocalNLSDocs.getElements("LocalNLSDocument");
            for (int i = 0; i < theConfigurationElements.size(); ++i) {
                Element theNLSPath = theConfigurationElements.next();
                Element xmlNLSDocumentKey = theNLSPath.getElement("Key");
                Element xmlNLSDocumentPath = theNLSPath.getElement("Path");
                String sDocumentKey = xmlNLSDocumentKey.getTextString();
                String sDocumentPath = xmlNLSDocumentPath.getTextString();
                HammerNLSAccess theNLSDoc = new HammerNLSAccess(sDocumentKey, sDocumentPath);
                this.theLocalNLSDocuments.add(theNLSDoc);
            }
        }
        Elements theObjects = theElement.getElements("Object");
        Element theObject = theObjects.next();
        while (theObject != null) {
            MetaObject theNewObject = new MetaObject();
            theNewObject.theDesignProject = this;
            boolean bTestLoadObject = theNewObject.load(theObject);
            if (bTestLoadObject) {
                this.addObject(theNewObject);
            } else {
                this.getMetaDataUser().getLogFile().doLogEntry("Fatal Error:", "Cannot load Object " + theNewObject.getName());
            }
            theObject = theObjects.next();
        }
        if (this.theMetaDataAdministrator != null) {
            int iChangeCount = this.theMetaDataAdministrator.getChangeCount();
            for (int iChange = 0; iChange < iChangeCount; ++iChange) {
                System.out.println(this.theMetaDataAdministrator.getChangeDescription(iChange));
            }
        }
        if (this.theMetaDataAdministrator != null) {
            this.theMetaDataAdministrator.applyChanges();
        }
        this.setProjectChangedState(false);
        return true;
    }

    public static long calculateProjectFactor(String sHammerVersion, String sHammerRevision, String sHammerSubRevision) {
        long lRetVal = 0L;
        if (sHammerVersion != null) {
            Integer iHammerVersion = new Integer(sHammerVersion);
            lRetVal += (long)(iHammerVersion * 65536);
        }
        if (sHammerRevision != null) {
            Integer iHammerRevision = new Integer(sHammerRevision);
            lRetVal += (long)(iHammerRevision * 256);
        }
        if (sHammerSubRevision != null) {
            Integer iHammerSubRevision = new Integer(sHammerSubRevision);
            lRetVal += (long)iHammerSubRevision.intValue();
        }
        return lRetVal;
    }

    public void setProjectChangedState(boolean bState) {
        if (bState != this.bChanged) {
            this.bChanged = bState;
            this.theMetaDataUser.processProjectChangedState(bState);
        }
    }

    public boolean getProjectChangedState() {
        return this.bChanged;
    }

    public void addObject(MetaObject theNewObject) {
        if (this.theFirstObject == null) {
            this.theFirstObject = theNewObject;
        } else {
            theNewObject.thePreviousObject = this.theLastObject;
            this.theLastObject.theNextObject = theNewObject;
        }
        this.theLastObject = theNewObject;
    }

    /*
     * Unable to fully structure code
     */
    public boolean loadResource(String sResource, InputStream inputStream, boolean bTryNew) throws HammerException {
        theReader = null;
        try {
            if (sResource.endsWith("proz")) {
                sClassName = MetaProject.getRenderingClassName(sResource);
                storage = new CompressedProjectDocument(this);
                if (bTryNew) {
                    try {
                        if (this.theMetaDataUser instanceof AbaRenderer && storage.readRenderingClass(inputStream, sClassName) != null) {
                            this.setInputType(4);
                            System.out.println("***********AbaRenderer will be rendering from compiled class");
                            System.out.flush();
                            return true;
                        }
                        storage.open(inputStream);
                        bytesProj = storage.readProjSource();
                        if (bytesProj == null) ** GOTO lbl29
                        is = new ByteArrayInputStream(bytesProj);
                        rin = new InputStreamReader((InputStream)is, "UTF8");
                        theReader = new BufferedReader(rin);
                    }
                    catch (HammerException e1) {
                        return false;
                    }
                } else {
                    fzip = new GZIPInputStream(inputStream);
                    rin = new InputStreamReader((InputStream)fzip, "UTF8");
                    theReader = new BufferedReader(rin);
                }
            } else {
                rin = new InputStreamReader(inputStream, "UTF8");
                theReader = new BufferedReader(rin);
            }
lbl29:
            // 4 sources

            System.out.println("***********AbaRenderer will be rendering from XML");
            System.out.flush();
            this.xmlProjectDocument = new Document((Reader)theReader);
        }
        catch (ParseException e1) {
            throw new HammerException(HammerException.BAD_XML_IN_PROJ, sResource + " contains bad XML and cannot be parsed.");
        }
        catch (IOException e3) {
            throw new HammerException(HammerException.CANNOT_READ_PROJ, sResource + " caused file input error.");
        }
        xmlRoot = this.xmlProjectDocument.getRoot();
        if (xmlRoot != null) {
            xmlProject = xmlRoot.getElement("Project");
            if (xmlProject != null) {
                if (this.load(xmlProject)) {
                    this.setInputType(2);
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    InputStream getResourceInputStream(String sResource) throws HammerException {
        InputStream inputStream = null;
        if (this.iMode == 2) {
            inputStream = this.theMetaDataUser.getClassLoader().getLoader().getResourceAsStream(sResource);
        } else if (this.iMode == 1) {
            HammerJarAccess theJarAccess = this.theMetaDataUser.getClassLoader().getLoader().getResourceAccess(sResource);
            if (theJarAccess != null) {
                inputStream = this.theMetaDataUser.getClassLoader().getLoader().getResourceAsStream(theJarAccess);
                this.theJarAccess = theJarAccess;
            } else {
                this.theJarAccess = null;
            }
        } else {
            return null;
        }
        return inputStream;
    }

    public boolean loadResource(String sResource) throws HammerException {
        this.setInputType(0);
        if (sResource == null) {
            return false;
        }
        this.xmlProjectDocument = null;
        InputStream inputStream = this.getResourceInputStream(sResource);
        if (inputStream == null) {
            return false;
        }
        boolean b = this.loadResource(sResource, inputStream, true);
        if (!b) {
            try {
                inputStream.close();
            }
            catch (IOException e1) {
                throw new HammerException(HammerException.CANNOT_OPEN_PROJ, "Cannot close intermediate input stream.");
            }
            inputStream = this.getResourceInputStream(sResource);
            if (inputStream == null) {
                return false;
            }
            b = this.loadResource(sResource, inputStream, false);
        }
        return b;
    }

    public boolean loadProzBuffer(String _Classname, byte[] _Buffer) throws HammerException {
        this.setInputType(0);
        if (_Buffer == null) {
            return false;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(_Buffer);
        if (inputStream == null) {
            return false;
        }
        return this.loadResource(_Classname, inputStream, true);
    }

    public boolean loadXML(String sData) {
        this.setInputType(0);
        if (sData == null) {
            return false;
        }
        this.xmlProjectDocument = null;
        try {
            StringReader inputData = new StringReader(sData);
            BufferedReader theReader = new BufferedReader(inputData);
            this.xmlProjectDocument = new Document((Reader)theReader);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
            return false;
        }
        Element xmlRoot = this.xmlProjectDocument.getRoot();
        if (xmlRoot != null) {
            Element xmlProject = xmlRoot.getElement("Project");
            if (xmlProject != null) {
                if (this.load(xmlProject)) {
                    this.setInputType(3);
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean load(HammerJarAccess theJarAccess) {
        this.setInputType(0);
        if (theJarAccess == null) {
            return true;
        }
        this.xmlProjectDocument = null;
        this.theJarAccess = theJarAccess;
        boolean bTest = false;
        try {
            InputStream fin = theJarAccess.theJarFile.getInputStream(theJarAccess.theJarEntry);
            bTest = this.loadResource(theJarAccess.theJarEntry.getName(), fin, true);
            if (!bTest) {
                fin.close();
                fin = theJarAccess.theJarFile.getInputStream(theJarAccess.theJarEntry);
                bTest = this.loadResource(theJarAccess.theJarEntry.getName(), fin, false);
            }
        }
        catch (HammerException e1) {
            return false;
        }
        catch (IOException e2) {
            return false;
        }
        return bTest;
    }

    public boolean load(String sProjectDocument) {
        File fileInput;
        this.setInputType(0);
        if (sProjectDocument == null) {
            return true;
        }
        if (sProjectDocument.equals("")) {
            return true;
        }
        this.xmlProjectDocument = null;
        try {
            fileInput = new File(sProjectDocument);
            FileInputStream fin = new FileInputStream(fileInput);
            String sFullPath = fileInput.getCanonicalPath();
            String sSeparator = System.getProperty("file.separator");
            int iSeparator = sFullPath.lastIndexOf(sSeparator);
            if (iSeparator != -1) {
                String sDirectoryName = sFullPath.substring(0, iSeparator + 1);
                this.setProjectDirectory(sDirectoryName);
            }
            BufferedReader theReader = null;
            boolean isOpenSource = this.getMetaDataUser().getOpenSourceState();
            if (sProjectDocument.endsWith("proz") || isOpenSource && this.iMode == 2) {
                String sClassName = MetaProject.getRenderingClassName(sProjectDocument);
                CompressedProjectDocument storage = new CompressedProjectDocument(this);
                try {
                    if (this.theMetaDataUser instanceof AbaRenderer && storage.readRenderingClass(fin, sClassName) != null) {
                        this.setInputType(4);
                        return true;
                    }
                    storage.open(fin);
                    byte[] bytesProj = storage.readProjSource();
                    if (bytesProj != null) {
                        ByteArrayInputStream is = new ByteArrayInputStream(bytesProj);
                        InputStreamReader rin = new InputStreamReader((InputStream)is, "UTF8");
                        theReader = new BufferedReader(rin);
                    }
                    storage.close();
                }
                catch (HammerException e1) {
                    fin.close();
                    fin = new FileInputStream(fileInput);
                    GZIPInputStream fzip = new GZIPInputStream(fin);
                    InputStreamReader rin = new InputStreamReader(fzip);
                    theReader = new BufferedReader(rin);
                }
            } else {
                InputStreamReader rin = new InputStreamReader((InputStream)fin, "UTF8");
                theReader = new BufferedReader(rin);
            }
            this.xmlProjectDocument = new Document((Reader)theReader);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
            return false;
        }
        catch (FileNotFoundException e2) {
            return false;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return false;
        }
        Element xmlRoot = this.xmlProjectDocument.getRoot();
        if (xmlRoot != null) {
            Element xmlProject = xmlRoot.getElement("Project");
            if (xmlProject != null) {
                if (this.load(xmlProject)) {
                    this.resetProjectNameIfCorrupt(fileInput.getName());
                    this.setInputType(1);
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private void resetProjectNameIfCorrupt(String projectName) {
        if (!projectName.equals(this.sName)) {
            this.sName = projectName;
        }
    }

    public void setProjectDirectory(String sDirectoryName) {
        this.sDirectoryName = sDirectoryName;
    }

    public String getProjectDirectory() {
        return this.sDirectoryName;
    }

    public String getGenCodeLAF() {
        return this.sGenLookFeelName;
    }

    public boolean isNLSCodeTranslation() {
        return this.isNLSTranslation;
    }

    public boolean isGenerateAccessor() {
        return this.bGenerateAccessor;
    }

    public void setGenCodeLAF(String pLAF) {
        this.sGenLookFeelName = pLAF;
    }

    public void writeDeclarations(ProjectDocument theDocumentManager) {
        MetaObject objTest = this.theFirstObject;
        while (objTest != null) {
            objTest.writeDeclarations(theDocumentManager);
            objTest = objTest.theNextObject;
        }
    }

    public void setMetaDataUser(AbaMetaDataUser objUser) {
        this.theMetaDataUser = objUser;
    }

    public final AbaMetaDataUser getMetaDataUser() {
        return this.theMetaDataUser;
    }

    public HammerLanguagePresentation getCurrentLanguage() {
        return this.theCurrentLanguage;
    }

    public boolean needsFixed() {
        return this.lHammerVersionFactor < FIX_ORDER_IN_PARAMETERS;
    }

    public static String getRenderingClassName(String sClassName) {
        int iPathMatch;
        int iDotMatch = sClassName.lastIndexOf(".");
        if (iDotMatch != -1) {
            sClassName = sClassName.substring(0, iDotMatch);
        }
        if ((iDotMatch = sClassName.lastIndexOf(".")) != -1) {
            sClassName = sClassName.substring(iDotMatch + 1);
        }
        if ((iPathMatch = sClassName.lastIndexOf("/")) != -1) {
            sClassName = sClassName.substring(iPathMatch + 1);
        }
        if ((iPathMatch = sClassName.lastIndexOf("\\")) != -1) {
            sClassName = sClassName.substring(iPathMatch + 1);
        }
        sClassName = "AbaRenderer_" + sClassName;
        return sClassName;
    }

    public ArrayList getDuplicateObjectNames() {
        if (this.getFirstObject() == null) {
            return null;
        }
        final ArrayList allObjects = new ArrayList();
        final ArrayList duplicateObjects = new ArrayList();
        EnumerateProjectMetaObjectInterface enumerator = new EnumerateProjectMetaObjectInterface(){

            public void callbackProjectMetaObject(MetaObject metaObject) {
                String sObjectName = metaObject.getName();
                if (allObjects.contains(sObjectName)) {
                    duplicateObjects.add(sObjectName);
                }
                allObjects.add(sObjectName);
            }
        };
        this.enumerateObjects(enumerator, this.getFirstObject());
        return duplicateObjects;
    }

    public ProjectCodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    public void setCodeGenerator(ProjectCodeGenerator codeGenerator) {
        this.codeGenerator = codeGenerator;
    }

    public void setNLSTranslation(boolean NLSTranslation) {
        this.isNLSTranslation = NLSTranslation;
    }

    public void setGenerateAccessor(boolean bGenerateAccessor) {
        this.bGenerateAccessor = bGenerateAccessor;
    }

    public String getDeclVariablePrefix() {
        return this.declVariablePrefix;
    }

    public void setDeclVariablePrefix(String declVariablePrefix) {
        this.declVariablePrefix = declVariablePrefix;
    }

    public int getGenCodeLookFeel(String sPLAF) {
        if (sPLAF == null) {
            return 0;
        }
        if (sPLAF.equals("Default")) {
            return 0;
        }
        if (sPLAF.equals("PlasticXPLookAndFeel")) {
            return 1;
        }
        if (sPLAF.equals("Plastic3DLookAndFeel")) {
            return 2;
        }
        if (sPLAF.equals("PlasticLookAndFeel")) {
            return 3;
        }
        return 0;
    }

    public void setAdditionalImports(String imports) {
        this.AdditionalImports = imports == null ? "\n" : imports;
    }

    public String getAdditionalImports() {
        return this.AdditionalImports;
    }

    public String getRepositoryPath() {
        return this.sRepositPath;
    }
}

