/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.MetaClassDetail;
import ch.abacus.lib.ui.renderer.common.MetaImport;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import java.util.ArrayList;
import java.util.HashMap;

public class MetaProjectHeader {
    public boolean bAbalet = false;
    public boolean bApplication = false;
    public boolean bGeneratePLAF = false;
    public MetaClassDetail theFirstClass = null;
    public MetaClassDetail theLastClass = null;
    public MetaObject theMainObject = null;
    public MetaImport theFirstImport = null;
    public MetaImport theLastImport = null;
    public String sMainClass = null;
    public String sPackageName = null;
    public String sOutputDirectory = null;
    public String sCodeGenerationDocument = null;
    public String sAuthor = null;
    public String sDescription = null;
    public String sWorkspace = null;
    public String sProjectName = null;
    public String sTransientDirectory = null;
    public String sPlatformLookAndFeel = null;
    public String sGenLookFeelName = null;
    public boolean bNLSTranslation = true;
    public boolean bAccesorCode = true;
    public ArrayList additionalClassPaths = new ArrayList(0);

    public MetaProjectHeader(HashMap thePreferences) {
        this.AddImport("java.io.*");
        this.AddImport("java.awt.*");
        this.AddImport("java.util.*");
        this.AddImport("javax.swing.*");
        this.AddImport("javax.swing.text.*");
        this.AddImport("javax.swing.plaf.*");
        this.AddImport("java.lang.reflect.*");
        this.AddImport("java.awt.event.*");
        this.AddImport("javax.swing.event.*");
        this.AddImport("ch.abacus.lib.ui.*");
        this.AddImport("ch.abacus.lib.ui.layout.*");
        this.AddImport("ch.abacus.lib.ui.renderer.common.jdbc.*");
        this.sProjectName = "New Project";
        this.sAuthor = (String)thePreferences.get("Author");
        this.sPlatformLookAndFeel = (String)thePreferences.get("LNF");
        this.sCodeGenerationDocument = (String)thePreferences.get("MetadataDocument");
        this.sWorkspace = (String)thePreferences.get("Workspace");
        this.sTransientDirectory = (String)thePreferences.get("Transient");
    }

    public void AddImport(String sPackageName) {
        MetaImport theNewImport = new MetaImport(sPackageName);
        if (this.theFirstImport == null) {
            this.theFirstImport = theNewImport;
        } else {
            this.theLastImport.theNextImport = theNewImport;
        }
        this.theLastImport = theNewImport;
    }

    public boolean FindImport(String sPackageName) {
        MetaImport theImport = this.theFirstImport;
        while (theImport != null) {
            if (theImport.sImportName.equals(sPackageName)) {
                return true;
            }
            theImport = theImport.theNextImport;
        }
        return false;
    }

    public void AddClassPath(String sDirectoryName) {
        this.additionalClassPaths.add(sDirectoryName);
    }

    public int getAdditionalClassPathCount() {
        return this.additionalClassPaths.size();
    }

    public String getAdditionalClassPath(int i) {
        return (String)this.additionalClassPaths.get(i);
    }

    public void setClassPath(String s) {
        int iMatch = s.indexOf(";");
        while (iMatch != -1) {
            String sLeft = s.substring(0, iMatch);
            this.AddClassPath(sLeft);
            s = s.substring(iMatch + 1);
            iMatch = s.indexOf(";");
        }
    }

    public String getClassPath() {
        int i = 0;
        String sClassPath = "";
        String sPathSeparator = System.getProperty("path.separator");
        for (i = 0; i < this.getAdditionalClassPathCount(); ++i) {
            sClassPath = sClassPath + this.getAdditionalClassPath(i) + sPathSeparator;
        }
        return sClassPath;
    }

    public void addClass(MetaClassDetail theClass) {
        if (this.theFirstClass == null) {
            this.theFirstClass = theClass;
        } else {
            this.theLastClass.theNextClass = theClass;
        }
        this.theLastClass = theClass;
    }

    public boolean isbAccesorCode() {
        return this.bAccesorCode;
    }

    public void setbAccesorCode(boolean bAccesorCode) {
        this.bAccesorCode = bAccesorCode;
    }

    public boolean isbNLSTranslation() {
        return this.bNLSTranslation;
    }

    public void setbNLSTranslation(boolean bNLSTranslation) {
        this.bNLSTranslation = bNLSTranslation;
    }
}

