/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaParameter;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;
import java.util.HashMap;

public class MetaProperty {
    public MetaProperty theNextProperty = null;
    public MetaProperty thePreviousProperty = null;
    public ArrayList theIndexedValue = null;
    public String theName = "";
    boolean bAllowMultipleValues = false;
    public MetaPropertyDescriptor thePropertyInfo;
    public MetaObject theObject;
    private static HashMap ClassforName;

    public MetaProperty(String theName, MetaParameter theValue, MetaPropertyDescriptor thePropertyInfo, MetaObject theObject) {
        this.theName = theName;
        this.theIndexedValue = new ArrayList(1);
        this.theIndexedValue.add(0, theValue);
        this.thePropertyInfo = thePropertyInfo;
        this.theObject = theObject;
        if (ClassforName == null) {
            ClassforName = new HashMap();
        }
    }

    public MetaProperty(MetaPropertyDescriptor thePropertyInfo, MetaObject theObject) {
        this.theIndexedValue = new ArrayList(1);
        this.thePropertyInfo = thePropertyInfo;
        this.theObject = theObject;
        if (ClassforName == null) {
            ClassforName = new HashMap();
        }
    }

    public MetaProperty(MetaObject theObject) {
        this.theIndexedValue = new ArrayList(1);
        this.theObject = theObject;
        if (ClassforName == null) {
            ClassforName = new HashMap();
        }
    }

    public void attachToProject(MetaProject theProj) {
        int iPropertyArrayCount = this.getValueCount();
        if (iPropertyArrayCount == 0) {
            iPropertyArrayCount = 1;
        }
        for (int i = 0; i < iPropertyArrayCount; ++i) {
            MetaParameter theParam = (MetaParameter)this.theIndexedValue.get(i);
            if (theParam == null) continue;
            theParam.theDesignProject = theProj;
            theParam.attachToProject(theProj);
        }
    }

    public MetaProperty Clone(MetaObject theObject) {
        MetaProperty theReturnValue = new MetaProperty(theObject);
        theReturnValue.theName = this.theName;
        int iPropertyArrayCount = this.getValueCount();
        if (iPropertyArrayCount == 0) {
            iPropertyArrayCount = 1;
        }
        ArrayList<MetaParameter> theReturnValues = new ArrayList<MetaParameter>(iPropertyArrayCount);
        for (int i = 0; i < iPropertyArrayCount; ++i) {
            if (this.theIndexedValue.get(i) == null) continue;
            theReturnValues.add(i, ((MetaParameter)this.theIndexedValue.get(i)).Clone());
        }
        theReturnValue.theIndexedValue = theReturnValues;
        theReturnValue.bAllowMultipleValues = this.bAllowMultipleValues;
        return theReturnValue;
    }

    public boolean save(MetaProject theProject, Element theParent) {
        if (this.theIndexedValue.size() == 1) {
            String sTestValue = this.getLiteralValue(0);
            MetaPropertyDescriptor thePropDetail = this.theObject.theClass.getProperty(this.theName, true);
            if (thePropDetail != null) {
                String sTestDefaultValue = thePropDetail.getDefaultValue();
                String sConciseValue = thePropDetail.getConciseValue(theProject, sTestValue);
                if (sConciseValue.equals(sTestDefaultValue)) {
                    return true;
                }
                if (thePropDetail.theFirstSubproperty != null) {
                    MetaProperty theDefaultPropertyValue = this.theObject.theClass.getDefaultProperty(this.theName);
                    if (theDefaultPropertyValue != null) {
                        sTestDefaultValue = theDefaultPropertyValue.getLiteralValue(0);
                        if (sTestDefaultValue.equals(sTestValue)) {
                            return true;
                        }
                    } else {
                        System.out.println("EXCEPTION!");
                    }
                }
            }
        }
        Element theMetaProperty = new Element("Property");
        Element xmlName = new Element("Name");
        xmlName.setText(this.theName);
        theMetaProperty.addElement(xmlName);
        theParent.addElement(theMetaProperty);
        if (this.bAllowMultipleValues) {
            theMetaProperty.addElement(new Element("Array"));
        }
        for (int i = 0; i < this.theIndexedValue.size(); ++i) {
            ((MetaParameter)this.theIndexedValue.get(i)).save(theMetaProperty);
        }
        return true;
    }

    public boolean load(Element theElement, MetaProject theDesignProject, MetaClass theClass) {
        Element xmlArray;
        Element xmlName = theElement.getElement("Name");
        this.theName = xmlName.getTextString();
        boolean bMnemonic = false;
        if (this.theName.equals("Mnemonic")) {
            bMnemonic = true;
        }
        if ((xmlArray = theElement.getElement("Array")) != null) {
            this.bAllowMultipleValues = true;
        }
        Elements xmlValues = theElement.getElements("Parameter");
        if (theClass == null) {
            return false;
        }
        this.thePropertyInfo = theClass.getProperty(this.theName, true);
        int i = 0;
        this.theIndexedValue = new ArrayList(1);
        Element xmlValue = xmlValues.next();
        while (xmlValue != null) {
            if (this.theIndexedValue != null) {
                MetaParameter theParameter = new MetaParameter();
                theParameter.theDesignProject = theDesignProject;
                theParameter.load(xmlValue, i);
                if (bMnemonic) {
                    theParameter.setMnemonic();
                }
                this.theIndexedValue.add(i++, theParameter);
            } else {
                System.out.println("Missing Value element for property " + this.theName);
            }
            xmlValue = xmlValues.next();
        }
        return true;
    }

    public Object[] Create() {
        Object[] retVal = new Object[this.theIndexedValue.size()];
        for (int i = 0; i < this.theIndexedValue.size(); ++i) {
            MetaParameter theParam = (MetaParameter)this.theIndexedValue.get(i);
            retVal[i] = theParam.Create();
            if (!(retVal[i] instanceof MetaPropertyValueEx)) continue;
            MetaPropertyValueEx theValue = (MetaPropertyValueEx)retVal[i];
            theValue.setResolveAsObject(theParam.bObjectReference);
            try {
                if (ClassforName.containsKey(theParam.theSimpleType)) {
                    theValue.objectClass = (Class)ClassforName.get(theParam.theSimpleType);
                    continue;
                }
                theValue.objectClass = Class.forName(theParam.theSimpleType);
                ClassforName.put(theParam.theSimpleType, theValue.objectClass);
                continue;
            }
            catch (Exception e) {
                theValue.objectClass = null;
                ClassforName.put(theParam.theSimpleType, null);
            }
        }
        return retVal;
    }

    public int getValueCount() {
        return this.theIndexedValue.size();
    }

    public boolean addParameter(int iOrder, int iArrayLink, String sParameterName, String sType, Object aValue, MetaProject theDesignProject, boolean bAllowMultipleLanguages, boolean bObjectReference) {
        MetaParameter theNewParameter = new MetaParameter(iOrder, new MetaPropertyValueEx(sType, aValue.toString(), theDesignProject, bAllowMultipleLanguages), sParameterName, theDesignProject, bAllowMultipleLanguages, bObjectReference);
        MetaParameter theTestParameter = (MetaParameter)this.theIndexedValue.get(iArrayLink);
        MetaParameter theLastParameter = null;
        while (theTestParameter != null) {
            theLastParameter = theTestParameter;
            theTestParameter = theTestParameter.theNextParameter;
        }
        if (theLastParameter != null) {
            theNewParameter.thePreviousParameter = theLastParameter;
            theLastParameter.theNextParameter = theNewParameter;
        } else {
            this.theIndexedValue.add(iArrayLink, theNewParameter);
        }
        return true;
    }

    /*
     * Loose catch block
     */
    public Class getParameterClass() {
        MetaParameter theMetaParameter = (MetaParameter)this.theIndexedValue.get(0);
        if (theMetaParameter == null) {
            return null;
        }
        try {
            block13: {
                if (!ClassforName.containsKey(theMetaParameter.theSimpleType)) break block13;
                Class<?> rtClass = (Class<?>)ClassforName.get(theMetaParameter.theSimpleType);
                if (rtClass != null) {
                    return rtClass;
                }
                rtClass = Class.forName("java.lang." + theMetaParameter.theSimpleType);
                ClassforName.put(theMetaParameter.theSimpleType, rtClass);
                return rtClass;
            }
            Class<?> rtClass = Class.forName(theMetaParameter.theSimpleType);
            ClassforName.put(theMetaParameter.theSimpleType, rtClass);
            return rtClass;
        }
        catch (ClassNotFoundException e1) {
            Class<?> rtClass = Class.forName("java.lang." + theMetaParameter.theSimpleType);
            ClassforName.put("java.lang." + theMetaParameter.theSimpleType, rtClass);
            return rtClass;
            {
                catch (ClassNotFoundException e12) {
                    try {
                        if (theMetaParameter.theSimpleType.equals("Color")) {
                            if (ClassforName.containsKey("java.awt.Color")) {
                                Class rtClass2 = (Class)ClassforName.get("java.awt.Color");
                                return rtClass2;
                            }
                            Class<?> rtClass3 = Class.forName("java.awt.Color");
                            ClassforName.put("java.awt.Color", rtClass3);
                            return rtClass3;
                        }
                        if (theMetaParameter.theSimpleType.equals("Font")) {
                            if (ClassforName.containsKey("java.awt.Font")) {
                                Class rtClass4 = (Class)ClassforName.get("java.awt.Font");
                                return rtClass4;
                            }
                            Class<?> rtClass5 = Class.forName("java.awt.Font");
                            ClassforName.put("java.awt.Font", rtClass5);
                            return rtClass5;
                        }
                    }
                    catch (Exception e2) {
                        return null;
                    }
                    return null;
                }
            }
        }
    }

    public String getLiteralValue(int iItem) {
        String sValue = null;
        MetaParameter theParameter = (MetaParameter)this.theIndexedValue.get(iItem);
        while (theParameter != null) {
            sValue = sValue == null ? "" : sValue + ",";
            sValue = sValue + theParameter.getLiteralValue();
            theParameter = theParameter.theNextParameter;
        }
        return sValue;
    }
}

