/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common.jdbc;

import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaObjectAccess;
import ch.abacus.lib.ui.renderer.common.jdbc.JSSDataSource;
import com.nqadmin.swingSet.SSCellEditing;
import com.nqadmin.swingSet.SSDataValue;
import com.nqadmin.swingSet.SSTableModel;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.sql.RowSet;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JSSDataGrid
extends JTable
implements MetaObjectAccess {
    public String FieldName = null;
    public RowSet rs = null;
    private JSSDataSource editDataSource = null;
    private boolean bRowSetActive = false;
    private boolean isHeaderOn = false;
    private RowSet rowset = null;
    private int columnCount = -1;
    private int rowCount = -1;
    SSTableModel tableModel = null;
    private int iDesignMode = 0;
    protected int[] hiddenColumns = null;
    protected String[] hiddenColumnNames = null;
    Component window = null;

    public JSSDataGrid() {
        this.tableModel = new SSTableModel();
    }

    private boolean isRowSetActive() {
        return this.bRowSetActive;
    }

    private boolean isHeaderSet() {
        return this.isHeaderOn;
    }

    public void setMetaObject(MetaObject ideMetaObject) {
        this.iDesignMode = ideMetaObject.iMode;
    }

    public void setDataSource(JSSDataSource ds) {
        this.editDataSource = ds;
        try {
            if ((this.iDesignMode == 0 || ds != null) && this.isHeaderSet()) {
                this.rs = ds.getRowSet();
                this.setMessageWindow(this);
                this.setRowSet(this.rs);
                this.bRowSetActive = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOrderColumn(String sData) {
        this.FieldName = sData;
        if (!this.isRowSetActive()) {
            this.setDataSource(this.editDataSource);
        }
        if (this.rs != null && this.FieldName != null) {
            try {
                this.setPrimaryColumn(sData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ArrayList getFieldNames() {
        if (this.editDataSource != null) {
            return this.editDataSource.getFieldNames();
        }
        return null;
    }

    public JSSDataGrid(RowSet _rowset) {
        this.rowset = _rowset;
        this.init();
    }

    public void setMessageWindow(Component _window) {
        this.window = _window;
        this.tableModel.setMessageWindow(this.window);
    }

    public void clearData() {
        if (this.getModel() instanceof DefaultTableModel) {
            ((DefaultTableModel)this.getModel()).setNumRows(0);
        } else {
            int cols = this.getModel().getColumnCount();
            DefaultTableModel df = new DefaultTableModel(0, cols);
            df.setColumnIdentifiers(new Vector[0]);
            this.setModel(df);
        }
    }

    public void resetData() {
        this.init();
        this.updateUI();
    }

    private void init() {
        try {
            this.rowset.execute();
            if (this.tableModel == null) {
                this.tableModel = new SSTableModel(this.rowset);
            } else {
                this.tableModel.setRowSet(this.rowset);
            }
            this.rowCount = this.tableModel.getRowCount();
            this.columnCount = this.tableModel.getColumnCount();
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        this.setModel((TableModel)this.tableModel);
        this.tableModel.setMessageWindow(this.window);
        this.tableModel.setJTable((JTable)this);
        TableColumnModel columnModel = this.getColumnModel();
        for (int i = columnModel.getColumnCount() - 1; i >= 0; --i) {
            TableColumn column = columnModel.getColumn(i);
            int j = -1;
            if (this.hiddenColumns != null) {
                for (j = 0; j < this.hiddenColumns.length; ++j) {
                    if (this.hiddenColumns[j] != i) continue;
                    column.setMaxWidth(0);
                    column.setMinWidth(0);
                    column.setPreferredWidth(0);
                    break;
                }
                if (j != this.hiddenColumns.length) continue;
                column.setMinWidth(100);
                continue;
            }
            column.setMinWidth(100);
        }
        this.addKeyListener(new KeyAdapter(){
            private boolean controlPressed = false;

            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 17) {
                    this.controlPressed = true;
                }
            }

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 17) {
                    this.controlPressed = false;
                }
                if (ke.getKeyCode() == 88) {
                    int returnValue;
                    if (!this.controlPressed) {
                        return;
                    }
                    int numRows = JSSDataGrid.this.getSelectedRowCount();
                    if (numRows == 0) {
                        return;
                    }
                    int[] rows = JSSDataGrid.this.getSelectedRows();
                    if (JSSDataGrid.this.window != null && (returnValue = JOptionPane.showConfirmDialog(JSSDataGrid.this.window, "You are about to delete " + rows.length + " rows. " + "\nAre you sure you want to delete the rows?")) != 0) {
                        return;
                    }
                    for (int i = rows.length - 1; i >= 0; --i) {
                        JSSDataGrid.this.tableModel.deleteRow(rows[i]);
                    }
                    JSSDataGrid.this.updateUI();
                }
            }
        });
        this.setAutoResizeMode(0);
    }

    public void setRowSet(RowSet _rowset) {
        boolean updateUI = false;
        if (this.rowset != null) {
            updateUI = true;
        }
        if (this.rowset == null) {
            this.rowset = _rowset;
            this.init();
        } else {
            this.rowset = _rowset;
            try {
                this.tableModel.setRowSet(this.rowset);
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        if (updateUI) {
            this.updateUI();
        }
    }

    public void setDefaultValues(int[] _columnNumbers, Object[] _values) {
        if (this.tableModel == null) {
            this.tableModel = new SSTableModel();
        }
        this.tableModel.setDefaultValues(_columnNumbers, _values);
    }

    public void setDefaultValues(String[] _columnNames, Object[] _values) throws SQLException {
        int[] columnNumbers = null;
        if (this.tableModel == null) {
            this.tableModel = new SSTableModel();
        }
        if (_columnNames != null) {
            columnNumbers = new int[_columnNames.length];
            for (int i = 0; i < _columnNames.length; ++i) {
                columnNumbers[i] = this.rowset.findColumn(_columnNames[i]) - 1;
            }
        }
        this.tableModel.setDefaultValues(columnNumbers, _values);
    }

    public Object getDefaultValue(int _columnNumber) {
        return this.tableModel.getDefaultValue(_columnNumber);
    }

    public Object getDefaultValue(String _columnName) throws SQLException {
        int columnNumber = this.rowset.findColumn(_columnName);
        return this.tableModel.getDefaultValue(columnNumber - 1);
    }

    public void updateUI() {
        super.updateUI();
    }

    public void setPrimaryColumn(int _columnNumber) {
        this.tableModel.setPrimaryColumn(_columnNumber);
    }

    public void setPrimaryColumn(String _columnName) throws SQLException {
        int columnNumber = this.rowset.findColumn(_columnName) - 1;
        this.tableModel.setPrimaryColumn(columnNumber);
    }

    public void setSSDataValue(SSDataValue _dataValue) {
        this.tableModel.setSSDataValue(_dataValue);
    }

    public void setDateRenderer(int _column) {
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn tableColumn = columnModel.getColumn(_column);
        tableColumn.setCellRenderer(new DateRenderer());
        tableColumn.setCellEditor(new DateEditor());
    }

    public void setDateRenderer(String _column) throws SQLException {
        int column = this.rowset.findColumn(_column) - 1;
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn tableColumn = columnModel.getColumn(column);
        tableColumn.setCellRenderer(new DateRenderer());
        tableColumn.setCellEditor(new DateEditor());
    }

    public void setComboRenderer(int _column, Object[] _displayItems, Object[] _underlyingValues) {
        this.setRowHeight(20);
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn tableColumn = columnModel.getColumn(_column);
        tableColumn.setCellRenderer(new ComboRenderer(_displayItems, _underlyingValues));
        tableColumn.setCellEditor(new ComboEditor(_displayItems, _underlyingValues));
        tableColumn.setMinWidth(250);
    }

    public void setComboRenderer(String _column, Object[] _displayItems, Object[] _underlyingValues) throws SQLException {
        int column = this.rowset.findColumn(_column) - 1;
        this.setRowHeight(20);
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn tableColumn = columnModel.getColumn(column);
        tableColumn.setCellRenderer(new ComboRenderer(_displayItems, _underlyingValues));
        tableColumn.setCellEditor(new ComboEditor(_displayItems, _underlyingValues));
        tableColumn.setMinWidth(250);
    }

    public void setHeaders(String[] _headers) {
        this.tableModel.setHeaders(_headers);
        this.isHeaderOn = true;
        if (this.editDataSource != null) {
            this.setDataSource(this.editDataSource);
        }
    }

    public void setAuxHeaders(String _unparsedheaders) {
        String[] _columnDisplay = _unparsedheaders.split(";");
        String[] _headers = new String[_columnDisplay.length];
        for (int i = 0; i < _columnDisplay.length; ++i) {
            int iLoc = _columnDisplay[i].indexOf("=");
            _headers[i] = _columnDisplay[i].substring(iLoc + 1, _columnDisplay[i].length());
        }
        this.setHeaders(_headers);
    }

    public String[] getHeaders() {
        String[] sHeaders = new String[this.tableModel.getColumnCount()];
        for (int i = 0; i < sHeaders.length; ++i) {
            sHeaders[i] = this.tableModel.getColumnName(i);
        }
        return sHeaders;
    }

    public void setUneditableColumns(int[] _columnNumbers) {
        this.tableModel.setUneditableColumns(_columnNumbers);
    }

    public void setUneditableColumns(String[] _columnNames) throws SQLException {
        int[] columnNumbers = null;
        if (_columnNames != null) {
            columnNumbers = new int[_columnNames.length];
            for (int i = 0; i < _columnNames.length; ++i) {
                columnNumbers[i] = this.rowset.findColumn(_columnNames[i]) - 1;
            }
        }
        this.tableModel.setUneditableColumns(columnNumbers);
    }

    public void setHiddenColumns(int[] _columnNumbers) {
        this.hiddenColumns = _columnNumbers;
        this.tableModel.setHiddenColumns(_columnNumbers);
    }

    public void setHiddenColumns(String[] _columnNames) throws SQLException {
        this.hiddenColumns = null;
        if (_columnNames != null) {
            this.hiddenColumns = new int[_columnNames.length];
            for (int i = 0; i < _columnNames.length; ++i) {
                this.hiddenColumns[i] = this.rowset.findColumn(_columnNames[i]) - 1;
            }
            TableColumnModel columnModel = this.getColumnModel();
            for (int j = 0; j < this.hiddenColumns.length; ++j) {
                TableColumn column = columnModel.getColumn(this.hiddenColumns[j]);
                column.setMinWidth(0);
                column.setMaxWidth(0);
                column.setPreferredWidth(0);
            }
            this.updateUI();
        }
        this.tableModel.setHiddenColumns(this.hiddenColumns);
    }

    public void setSSCellEditing(SSCellEditing _cellEditing) {
        this.tableModel.setSSCellEditing(_cellEditing);
    }

    private String dateMask(String str, KeyEvent ke) {
        switch (str.length()) {
            case 1: {
                if (ke.getKeyChar() != '/') break;
                str = "0" + str;
                break;
            }
            case 2: {
                if (ke.getKeyChar() == '/') break;
                str = str + "/";
                break;
            }
            case 4: {
                if (ke.getKeyChar() != '/') break;
                String newStr = str.substring(0, 3);
                str = newStr = newStr + "0" + str.substring(3, 4);
                break;
            }
            case 5: {
                if (ke.getKeyChar() == '/') break;
                str = str + "/";
            }
        }
        return str;
    }

    private class ComboEditor
    extends DefaultCellEditor {
        Object[] underlyingValues;
        int clickCountToStart;

        public ComboEditor(Object[] _items, Object[] _underlyingValues) {
            super(new JComboBox<Object>(_items));
            this.underlyingValues = null;
            this.clickCountToStart = 2;
            this.underlyingValues = _underlyingValues;
        }

        public boolean isCellEditable(EventObject event) {
            if (event instanceof MouseEvent) {
                return ((MouseEvent)event).getClickCount() >= this.clickCountToStart;
            }
            return true;
        }

        public Component getTableCellEditorComponent(JTable _table, Object _value, boolean _selected, int _row, int _column) {
            JComboBox comboBox = (JComboBox)this.getComponent();
            comboBox.setSelectedIndex(this.getIndexOf(_value));
            return comboBox;
        }

        public Object getCellEditorValue() {
            if (this.underlyingValues == null) {
                return new Integer(((JComboBox)this.getComponent()).getSelectedIndex());
            }
            int index = ((JComboBox)this.getComponent()).getSelectedIndex();
            if (index == -1) {
                return this.underlyingValues[0];
            }
            return this.underlyingValues[index];
        }

        private int getIndexOf(Object _value) {
            if (this.underlyingValues == null) {
                return (Integer)_value;
            }
            for (int i = 0; i < this.underlyingValues.length; ++i) {
                if (!this.underlyingValues[i].equals(_value)) continue;
                return i;
            }
            return 0;
        }
    }

    private class ComboRenderer
    extends JComboBox
    implements TableCellRenderer {
        Object[] underlyingValues;

        public ComboRenderer(Object[] _items, Object[] _underlyingValues) {
            super(_items);
            this.underlyingValues = null;
            this.underlyingValues = _underlyingValues;
        }

        public Component getTableCellRendererComponent(JTable _table, Object _value, boolean _selected, boolean _hasFocus, int _row, int _column) {
            if (this.getItemCount() > 0) {
                this.setSelectedIndex(this.getIndexOf(_value));
            } else {
                System.out.println("Combo Renderer: No item in combo that corresponds to " + _value);
            }
            return this;
        }

        private int getIndexOf(Object _value) {
            if (_value == null) {
                return 0;
            }
            if (this.underlyingValues == null) {
                return (Integer)_value;
            }
            for (int i = 0; i < this.underlyingValues.length; ++i) {
                if (!this.underlyingValues[i].equals(_value)) continue;
                return i;
            }
            return 0;
        }
    }

    private class DateRenderer
    extends DefaultTableCellRenderer {
        private DateRenderer() {
        }

        public void setValue(Object value) {
            if (value instanceof Date) {
                Date date = (Date)value;
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(date);
                String strDate = "" + (calendar.get(2) + 1) + "/" + calendar.get(5) + "/" + calendar.get(1);
                this.setHorizontalAlignment(0);
                this.setText(strDate);
            } else {
                super.setValue(value);
            }
        }
    }

    private class DateEditor
    extends DefaultCellEditor {
        public DateEditor() {
            super(new JTextField());
            super.setClickCountToStart(2);
            KeyListener[] keyListeners = this.getComponent().getKeyListeners();
            for (int i = 0; i < keyListeners.length; ++i) {
                this.getComponent().removeKeyListener(keyListeners[i]);
            }
            this.getComponent().addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent ke) {
                }

                public void keyTyped(KeyEvent ke) {
                }

                public synchronized void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == 127 || ke.getKeyCode() == 8 || ke.getKeyCode() == 37 || ke.getKeyCode() == 39 || ke.getKeyCode() == 36 || ke.getKeyCode() == 35 || ke.getKeyCode() == 10) {
                        return;
                    }
                    String str = ((JTextField)DateEditor.this.getComponent()).getText();
                    String newStr = JSSDataGrid.this.dateMask(str, ke);
                    ((JTextField)DateEditor.this.getComponent()).setText(newStr);
                }
            });
        }

        public synchronized Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof Date) {
                Date date = (Date)value;
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(date);
                String strDate = "" + (calendar.get(2) + 1) + "/" + calendar.get(5) + "/" + calendar.get(1);
                return super.getTableCellEditorComponent(table, strDate, isSelected, row, column);
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        public boolean isCellEditable(EventObject event) {
            if (event instanceof MouseEvent) {
                return ((MouseEvent)event).getClickCount() >= this.getClickCountToStart();
            }
            return true;
        }
    }
}

