/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.programmableCompiler;

import ch.abacus.lib.ui.renderer.programmableCompiler.ClassByteLoader;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClassByteFileLoader
implements ClassByteLoader {
    private Vector classPathVector;
    private Hashtable properties;

    public ClassByteFileLoader(Vector classPathVector, Hashtable properties) {
        this.classPathVector = classPathVector;
        this.properties = properties;
    }

    public byte[] get(String name) {
        byte[] classBytes = null;
        File classFile = this.findClassFile(name);
        try {
            FileInputStream classFileInputStream = new FileInputStream(classFile);
            int fileLength = classFileInputStream.available();
            classBytes = new byte[fileLength];
            classFileInputStream.read(classBytes);
            classFileInputStream.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return classBytes;
    }

    public File findClassFile(String fullClassName) {
        File classFile = null;
        String packageSeparator = (String)this.properties.get("packageSeparator");
        String compiledSuffix = (String)this.properties.get("compiledSuffix");
        Enumeration classDirs = this.classPathVector.elements();
        while (classDirs.hasMoreElements()) {
            StringTokenizer st = new StringTokenizer(fullClassName, packageSeparator);
            File packageDir = (File)classDirs.nextElement();
            String s = st.nextToken();
            while (st.hasMoreTokens()) {
                packageDir = new File(packageDir, s);
                s = st.nextToken();
            }
            classFile = new File(packageDir, s + compiledSuffix);
            if (!classFile.exists()) continue;
            break;
        }
        return classFile;
    }
}

