/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import org.comedia.event.CSpinEvent;
import org.comedia.event.CSpinListener;

public class CSpinButton
extends JComponent
implements KeyListener,
AdjustmentListener {
    protected EventListenerList listenerList = new EventListenerList();
    private JScrollBar scrollBar = new JScrollBar(1, 1, 0, 0, 2);
    private int maximum = 100;
    private int minimum = 0;
    private int value = 0;
    static /* synthetic */ Class class$org$comedia$event$CSpinListener;

    public CSpinButton() {
        this.setLayout(new BorderLayout());
        this.setRequestFocusEnabled(true);
        this.setPreferredSize(new Dimension(16, 21));
        this.addKeyListener(this);
        this.add(this.scrollBar);
        this.scrollBar.addAdjustmentListener(this);
        this.scrollBar.setRequestFocusEnabled(false);
    }

    public void addSpinListener(CSpinListener cSpinListener) {
        this.listenerList.add(class$org$comedia$event$CSpinListener == null ? (class$org$comedia$event$CSpinListener = CSpinButton.class$("org.comedia.event.CSpinListener")) : class$org$comedia$event$CSpinListener, cSpinListener);
    }

    public void removeSpinListener(CSpinListener cSpinListener) {
        this.listenerList.remove(class$org$comedia$event$CSpinListener == null ? (class$org$comedia$event$CSpinListener = CSpinButton.class$("org.comedia.event.CSpinListener")) : class$org$comedia$event$CSpinListener, cSpinListener);
    }

    public void fireSpinChanged(CSpinEvent cSpinEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$org$comedia$event$CSpinListener == null ? CSpinButton.class$("org.comedia.event.CSpinListener") : class$org$comedia$event$CSpinListener)) {
                ((CSpinListener)objectArray[n + 1]).spinEventPerformed(cSpinEvent);
            }
            n -= 2;
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isManagingFocus() {
        return true;
    }

    private void performSpinUp() {
        if (this.value < this.maximum) {
            ++this.value;
        }
        this.fireSpinChanged(new CSpinEvent(this, 0));
    }

    private void performSpinDown() {
        if (this.value > this.minimum) {
            --this.value;
        }
        this.fireSpinChanged(new CSpinEvent(this, 1));
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        switch (adjustmentEvent.getValue()) {
            case 0: {
                this.performSpinUp();
                break;
            }
            case 2: {
                this.performSpinDown();
            }
        }
        adjustmentEvent.getAdjustable().setValue(1);
        this.requestFocus();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 38 || n == 33 || n == 36) {
            this.performSpinUp();
            keyEvent.consume();
        } else if (n == 40 || n == 34 || n == 35) {
            this.performSpinDown();
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int n) {
        this.maximum = n;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int n) {
        this.minimum = n;
    }

    public void setEnabled(boolean bl) {
        this.scrollBar.setEnabled(bl);
        super.setEnabled(bl);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Comedia CSpinButton Test");
        final CSpinButton cSpinButton = new CSpinButton();
        final JTextField jTextField = new JTextField("0                 ");
        jFrame.getContentPane().setLayout(new FlowLayout());
        jFrame.getContentPane().add(jTextField);
        jFrame.getContentPane().add(cSpinButton);
        cSpinButton.addSpinListener(new CSpinListener(){

            public void spinEventPerformed(CSpinEvent cSpinEvent) {
                jTextField.setText(new Integer(cSpinButton.getValue()).toString());
            }
        });
        ((Component)jFrame).setLocation(100, 100);
        ((Component)jFrame).setSize(150, 100);
        jFrame.setDefaultCloseOperation(3);
        jFrame.show();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

