/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.comedia.event.CSpinEvent;
import org.comedia.event.CSpinListener;
import org.comedia.text.CNumericDocument;
import org.comedia.ui.CSpinButton;

public class CSpinEdit
extends JComponent
implements CSpinListener,
KeyListener,
ActionListener,
FocusListener {
    private JTextField text = new JTextField();
    private CSpinButton spin = new CInternalSpin();
    private CNumericDocument document = new CNumericDocument();
    private int maximum = 100;
    private int minimum = 0;

    public CSpinEdit() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.text, "Center");
        this.add((Component)this.spin, "East");
        this.setPreferredSize(new Dimension(70, 21));
        this.spin.setRequestFocusEnabled(false);
        this.spin.addSpinListener(this);
        ((JTextComponent)this.text).setDocument(this.document);
        this.text.setText("0");
        this.text.setHorizontalAlignment(4);
        this.text.addKeyListener(this);
        this.text.addActionListener(this);
        this.text.addFocusListener(this);
    }

    private int getTextValue() {
        String string = this.text.getText();
        int n = this.minimum;
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private void setTextValue(int n) {
        if (n > this.maximum) {
            n = this.maximum;
        }
        if (n < this.minimum) {
            n = this.minimum;
        }
        this.text.setText(new Integer(n).toString());
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setTextValue(this.getTextValue());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.getTextValue();
        this.setTextValue(n);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 38 || n == 33 || n == 36) {
            this.spin.keyPressed(keyEvent);
            keyEvent.consume();
        } else if (n == 40 || n == 34 || n == 35) {
            this.spin.keyPressed(keyEvent);
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void spinEventPerformed(CSpinEvent cSpinEvent) {
        int n = this.getTextValue();
        if (cSpinEvent.getSpinCommand() == 0) {
            this.setTextValue(n + 1);
        }
        if (cSpinEvent.getSpinCommand() == 1) {
            this.setTextValue(n - 1);
        }
    }

    public int getValue() {
        return this.getTextValue();
    }

    public void setValue(int n) {
        this.setTextValue(n);
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int n) {
        if (n <= this.minimum) {
            n = this.minimum + 1;
        }
        this.maximum = n;
        this.setTextValue(this.getTextValue());
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int n) {
        if (n >= this.maximum) {
            n = this.maximum - 1;
        }
        this.minimum = n;
        this.setTextValue(this.getTextValue());
    }

    public void setEnabled(boolean bl) {
        this.spin.setEnabled(bl);
        this.text.setEnabled(bl);
        super.setEnabled(bl);
    }

    public JTextField getTextField() {
        return this.text;
    }

    public CSpinButton getSpinButton() {
        return this.spin;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Comedia CSpinButton Test");
        CSpinEdit cSpinEdit = new CSpinEdit();
        cSpinEdit.setValue(50);
        jFrame.getContentPane().setLayout(new FlowLayout());
        jFrame.getContentPane().add(cSpinEdit);
        ((Component)jFrame).setLocation(100, 100);
        ((Component)jFrame).setSize(150, 100);
        jFrame.setDefaultCloseOperation(3);
        jFrame.show();
    }

    private class CInternalSpin
    extends CSpinButton {
        private CInternalSpin() {
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }
}

