/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.comedia.ui.CDataTable;
import org.comedia.ui.CEncodedIcon;

public class CTableScroller
extends JScrollPane
implements ListSelectionListener,
TableModelListener,
ItemListener {
    private static final int HEADER_WIDTH = 18;
    private JTable table = null;
    private JPanel headerPanel = new JPanel();
    private JPanel internalPanel = new JPanel();
    private JComponent corner = null;
    private int lastSelection = 0;

    public CTableScroller() {
        this(null);
    }

    public CTableScroller(JTable jTable) {
        this.setTable(jTable);
        JViewport jViewport = new JViewport();
        this.headerPanel.add(this.internalPanel);
        ((FlowLayout)this.headerPanel.getLayout()).setHgap(0);
        ((FlowLayout)this.headerPanel.getLayout()).setVgap(0);
        jViewport.setView(this.headerPanel);
        this.setRowHeader(jViewport);
        this.corner = this.createBlock();
        this.setCorner("UPPER_LEFT_CORNER", this.corner);
        this.setViewportView(jTable);
        this.updateContent();
    }

    public JTable getTable() {
        return this.table;
    }

    public void setTable(JTable jTable) {
        if (this.table != null) {
            this.table.getSelectionModel().removeListSelectionListener(this);
            this.table.getModel().removeTableModelListener(this);
            this.setViewportView(null);
            if (this.table instanceof CDataTable) {
                ((CDataTable)this.table).removeItemListener(this);
            }
        }
        this.table = jTable;
        this.lastSelection = 0;
        if (this.table != null) {
            this.table.getSelectionModel().addListSelectionListener(this);
            this.table.getModel().addTableModelListener(this);
            this.setViewportView(this.table);
            if (this.table instanceof CDataTable) {
                ((CDataTable)this.table).addItemListener(this);
            }
            this.updateContent();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateContent();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.updateContent();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateContent();
    }

    private JComponent createBlock() {
        JLabel jLabel = new JLabel("");
        jLabel.setOpaque(true);
        jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        jLabel.setPreferredSize(new Dimension(18, this.table != null ? this.table.getRowHeight() : 0));
        jLabel.setHorizontalAlignment(0);
        jLabel.setVerticalAlignment(0);
        return jLabel;
    }

    private void updateContent() {
        int n;
        if (this.table == null) {
            this.internalPanel.removeAll();
            this.validate();
            return;
        }
        this.internalPanel.setLayout(new GridLayout(this.table.getRowCount(), 1));
        while (this.internalPanel.getComponentCount() > this.table.getRowCount()) {
            this.internalPanel.remove(this.internalPanel.getComponent(this.internalPanel.getComponentCount() - 1));
        }
        while (this.internalPanel.getComponentCount() < this.table.getRowCount()) {
            this.internalPanel.add(this.createBlock());
        }
        int n2 = n = this.table.getSelectedRow() >= 0 ? this.table.getSelectedRow() : 0;
        if (this.table.getSelectedRowCount() > 1) {
            n = this.lastSelection;
        } else {
            this.lastSelection = n;
        }
        int n3 = this.table instanceof CDataTable && ((CDataTable)this.table).isInsert() ? this.table.getRowCount() - 1 : -1;
        int n4 = 0;
        while (n4 < this.internalPanel.getComponentCount()) {
            CEncodedIcon cEncodedIcon;
            JLabel jLabel = (JLabel)this.internalPanel.getComponent(n4);
            jLabel.setPreferredSize(new Dimension(18, this.table.getRowHeight()));
            if (n4 == this.table.getEditingRow() && n4 == n && this.table instanceof CDataTable) {
                cEncodedIcon = CEncodedIcon.PEN_SIGN;
                cEncodedIcon.setColor(SystemColor.controlText);
                jLabel.setIcon(cEncodedIcon);
            } else if (n4 == n) {
                cEncodedIcon = CEncodedIcon.BIG_RIGHT_ARROW;
                cEncodedIcon.setColor(SystemColor.controlText);
                jLabel.setIcon(cEncodedIcon);
            } else if (n4 == n3) {
                cEncodedIcon = CEncodedIcon.STAR_SIGN;
                cEncodedIcon.setColor(SystemColor.controlText);
                jLabel.setIcon(cEncodedIcon);
            } else {
                jLabel.setIcon(null);
            }
            ++n4;
        }
        this.validate();
    }

    public void updateUI() {
        super.updateUI();
        if (this.internalPanel != null) {
            this.corner.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            int n = 0;
            while (n < this.internalPanel.getComponentCount()) {
                JLabel jLabel = (JLabel)this.internalPanel.getComponent(n);
                jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                ++n;
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Comedia Data Grid Test");
        JTable jTable = new JTable(new String[][]{{"1x1", "1x2", "1x3"}, {"2x1", "2x2", "2x3"}, {"3x1", "3x2", "3x3"}, {"4x1", "4x2", "4x3"}}, new String[]{"Column 1", "Column 2", "Column 3"});
        CTableScroller cTableScroller = new CTableScroller(jTable);
        jFrame.getContentPane().add((Component)cTableScroller, "Center");
        ((Component)jFrame).setLocation(100, 100);
        ((Component)jFrame).setSize(500, 300);
        jFrame.setDefaultCloseOperation(3);
        jFrame.show();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(cTableScroller);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

