/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.util.scanner;

import org.comedia.util.scanner.CScanner;

public class CPasScanner
extends CScanner {
    protected String[] pasOperators = new String[]{"and", "or", "not", "shr", "shl", "div", "mod"};
    protected String[] pasTypes = new String[]{"integer", "longint", "byte", "char", "string", "boolean", "real", "double", "word"};
    protected String[] pasKeywords = new String[]{"with", "array", "function", "case", "var", "const", "until", "then", "set", "record", "program", "procedure", "packed", "nil", "label", "in", "repeat", "of", "goto", "forward", "for", "while", "file", "else", "downto", "do", "to", "type", "end", "begin", "if", "true", "false", "unit", "interface", "uses", "implementation", "initialization"};

    public CPasScanner() {
        this.operators = this.pasOperators;
        this.types = this.pasTypes;
        this.keywords = this.pasKeywords;
    }

    protected int lowRunLex(CScanner.Lexem lexem) {
        this.innerStartLex(lexem);
        if (lexem.tokenType != 0) {
            return lexem.tokenType;
        }
        char c = lexem.token.charAt(0);
        if (c == '{') {
            while (this.bufferPos < this.bufferLen) {
                c = this.buffer.charAt(this.bufferPos);
                lexem.token = lexem.token + c;
                ++this.bufferPos;
                if (c == '}') break;
                if (c != '\n') continue;
                ++this.bufferLine;
            }
            lexem.tokenType = 1;
            return 1;
        }
        if (c == '(' && this.bufferPos < this.bufferLen && this.buffer.charAt(this.bufferPos) == '*') {
            int n = 0;
            while (this.bufferPos < this.bufferLen) {
                c = this.buffer.charAt(this.bufferPos);
                lexem.token = lexem.token + c;
                ++this.bufferPos;
                if (c == ')' && n == 42 && lexem.token.length() > 3) break;
                if (c == '\n') {
                    ++this.bufferLine;
                }
                n = c;
            }
            lexem.tokenType = 1;
            return 1;
        }
        if (c == '/' && this.bufferPos < this.bufferLen && this.buffer.charAt(this.bufferPos) == '/') {
            return this.innerProcLineComment(lexem);
        }
        if (new String("()[]").indexOf(c) >= 0) {
            lexem.tokenType = 32;
            return 32;
        }
        if (c == ',' || c == '.' || c == ';' || c == ':' && this.bufferPos < this.bufferLen && this.buffer.charAt(this.bufferPos) != '=') {
            lexem.tokenType = 64;
            return 64;
        }
        if (new String(":=+-<>/*^@#").indexOf(c) >= 0) {
            char c2;
            char c3 = c2 = this.bufferPos < this.bufferLen ? this.buffer.charAt(this.bufferPos) : (char)'\u0000';
            if ((c == ':' || c == '>') && c2 == '=' || c == '<' && (c2 == '=' || c2 == '>')) {
                lexem.token = lexem.token + c2;
                ++this.bufferPos;
            }
            lexem.tokenType = 16;
            return 16;
        }
        if (c == '\'') {
            return this.innerProcPasString(lexem);
        }
        this.innerProcIdent(lexem);
        if (lexem.tokenType == 8) {
            if (this.searchForString(lexem.token.toLowerCase(), this.operators)) {
                lexem.tokenType = 16;
                return 16;
            }
            if (this.showType && this.searchForString(lexem.token.toLowerCase(), this.types)) {
                lexem.tokenType = 4;
                return 4;
            }
            if (this.showKeyword && this.searchForString(lexem.token.toLowerCase(), this.keywords)) {
                lexem.tokenType = 2;
                return 2;
            }
        }
        return lexem.tokenType;
    }

    public static String wrapString(String string) {
        String string2 = "'";
        int n = 0;
        while (n < string.length()) {
            string2 = string2 + string.charAt(n);
            if (string.charAt(n) == '\'') {
                string2 = string2 + string.charAt(n);
            }
            ++n;
        }
        return string2 + "'";
    }

    public static String unwrapString(String string) {
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            return "";
        }
        if (string.charAt(n) == '\'') {
            ++n;
        }
        if (string.charAt(n2 - 1) == '\'') {
            --n2;
        }
        if (n2 - n <= 0) {
            return "";
        }
        String string2 = "";
        while (n < n2) {
            char c = string.charAt(n);
            if (c != '\'') {
                string2 = string2 + c;
            } else if (n < n2 - 1 && string.charAt(n + 1) == '\'') {
                string2 = string2 + '\'';
                ++n;
            }
            ++n;
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        System.out.println("*********** Pascal Scanner Test *************");
        CPasScanner cPasScanner = new CPasScanner();
        cPasScanner.setBuffer("while(1.0e2*i := \t\r\n> 'string''')\n// comment\n(*second\ncomment*){xxx}");
        cPasScanner.setShowEol(true);
        cPasScanner.setShowSpace(true);
        cPasScanner.setShowComment(true);
        cPasScanner.setShowKeyword(true);
        cPasScanner.setShowType(true);
        String string = "The test 'string'";
        System.out.println("Start string: " + string);
        string = CPasScanner.wrapString(string);
        System.out.println("Wrapped string: " + string);
        string = CPasScanner.unwrapString(string);
        System.out.println("Unwrapped string: " + string);
        System.out.println();
        System.out.println("Initial string: " + cPasScanner.getBuffer());
        while (cPasScanner.lex() != 32768) {
            switch (cPasScanner.getTokenType()) {
                case 0: {
                    System.out.print("Type: Unknown ");
                    break;
                }
                case 1: {
                    System.out.print("Type: Comment ");
                    break;
                }
                case 2: {
                    System.out.print("Type: Keyword ");
                    break;
                }
                case 4: {
                    System.out.print("Type: Type ");
                    break;
                }
                case 8: {
                    System.out.print("Type: Ident ");
                    break;
                }
                case 14: {
                    System.out.print("Type: Alpha ");
                    break;
                }
                case 16: {
                    System.out.print("Type: Operator ");
                    break;
                }
                case 32: {
                    System.out.print("Type: Brace ");
                    break;
                }
                case 64: {
                    System.out.print("Type: Separator ");
                    break;
                }
                case 128: {
                    System.out.print("Type: Eol ");
                    break;
                }
                case 224: {
                    System.out.print("Type: Lf ");
                    break;
                }
                case 256: {
                    System.out.print("Type: Space ");
                    break;
                }
                case 512: {
                    System.out.print("Type: Int ");
                    break;
                }
                case 1024: {
                    System.out.print("Type: Float ");
                    break;
                }
                case 2048: {
                    System.out.print("Type: String ");
                    break;
                }
                case 4096: {
                    System.out.print("Type: Bool ");
                    break;
                }
                case 32768: {
                    System.out.print("Type: Eof ");
                }
            }
            System.out.println("Value: '" + cPasScanner.getToken() + "' Pos: " + cPasScanner.getPosition() + " Line: " + cPasScanner.getLineNo());
        }
    }
}

