/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.classEditor;

import ch.abacus.designcockpit.classEditor.LizardComboBox;
import ch.abacus.designcockpit.classEditor.LizardMethodComboBoxListener;
import ch.abacus.designcockpit.classEditor.LizardMethodComboBoxModel;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LizardMethodComboBox
extends LizardComboBox {
    LizardMethodComboBoxModel theModel = null;
    MetaMethod theMethod = null;

    public LizardMethodComboBox(LizardMethodComboBoxModel objModel, Object objReceiver) {
        super(objModel, objReceiver);
        this.theModel = objModel;
        this.theReceiver = objReceiver;
        this.setEditable(true);
        this.setMaximumRowCount(10);
        this.addActionListener(new LizardMethodComboBoxListener());
    }

    public void selectMethod(String sMethodName) {
        if (this.theMetaClass != null && !sMethodName.trim().equals("")) {
            MetaMethod theOldMethod = this.theMethod;
            this.theMethod = this.theMetaClass.getMethod(sMethodName, false);
            if (this.theReceiver != null) {
                Class<?> clsReceiver = this.theReceiver.getClass();
                Class[] clsParams = new Class[]{this.theMethod.getClass(), this.theMethod.getClass()};
                try {
                    Method m = clsReceiver.getMethod("selectMethod", clsParams);
                    Object[] objArgList = new Object[]{theOldMethod, this.theMethod};
                    m.invoke(this.theReceiver, objArgList);
                }
                catch (NoSuchMethodException e1) {
                    System.out.println("Method ComboBox Error: Bad Receiver - SelectMethod!");
                }
                catch (InvocationTargetException e2) {
                    System.out.println("Method ComboBox Error: Bad Target Receiver!");
                }
                catch (IllegalAccessException e3) {
                    System.out.println("Method ComboBox Error: Illegal Access!");
                }
            }
        }
    }

    public void Load(MetaClass someClass) {
        this.theMetaClass = someClass;
        this.theModel.Load(someClass);
        this.updateUI();
    }

    public void resetContents() {
        this.theMetaClass = null;
        this.theModel.theMetaClass = null;
        this.updateUI();
    }

    public void Reload(MetaClass someClass) {
        this.theMetaClass = someClass;
        this.theModel.Load(someClass);
    }

    public void selectItem() {
        String sSelectedItem = (String)this.getSelectedItem();
        this.selectItem(sSelectedItem);
    }

    public void appendItem(String sText) {
        this.theMetaClass.setMethod(sText, "", "");
        this.Load(this.theMetaClass);
        this.selectMethod(sText);
    }

    public void selectItem(String sSelectedItem) {
        if (sSelectedItem.trim().length() == 0) {
            return;
        }
        this.configureEditor(this.getEditor(), sSelectedItem);
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!this.getItemAt(i).equals(sSelectedItem)) continue;
            this.selectMethod(sSelectedItem);
            return;
        }
        this.appendItem(sSelectedItem);
    }
}

