/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.classEditor;

import ch.abacus.designcockpit.classEditor.LizardComboBox;
import ch.abacus.designcockpit.classEditor.LizardPropertyComboBoxListener;
import ch.abacus.designcockpit.classEditor.LizardPropertyComboBoxModel;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LizardPropertyComboBox
extends LizardComboBox {
    LizardPropertyComboBoxModel theModel;
    public MetaPropertyDescriptor theProperty;
    MetaClass theMetaClass;
    MetadataDispenser theMetadataDispenser;

    public LizardPropertyComboBox(LizardPropertyComboBoxModel objModel, Object objReceiver, MetadataDispenser theMetadataDispenser) {
        super(objModel, objReceiver);
        this.theModel = objModel;
        this.theMetadataDispenser = theMetadataDispenser;
        this.setEditable(true);
        this.setMaximumRowCount(10);
        this.addActionListener(new LizardPropertyComboBoxListener());
    }

    public void selectProperty(String sPropertyName) {
        if (this.theMetaClass != null && !sPropertyName.trim().equals("") && this.theReceiver != null) {
            MetaPropertyDescriptor theOldProperty = this.theProperty;
            this.theProperty = this.theMetaClass.getProperty(sPropertyName, false);
            try {
                Class<?> clsReceiver = this.theReceiver.getClass();
                Class[] clsParams = new Class[]{this.theProperty.getClass(), this.theProperty.getClass()};
                Method m = clsReceiver.getMethod("selectProperty", clsParams);
                Object[] objArgList = new Object[]{theOldProperty, this.theProperty};
                m.invoke(this.theReceiver, objArgList);
            }
            catch (NoSuchMethodException e1) {
                System.out.println("Property ComboBox Error: Bad Receiver - SelectProperty!");
            }
            catch (InvocationTargetException e2) {
                System.out.println("Property ComboBox Error: Bad Target Receiver!");
            }
            catch (IllegalAccessException e3) {
                System.out.println("Property ComboBox Error: Illegal Access!");
            }
        }
    }

    public void Load(MetaClass someClass) {
        this.theMetaClass = someClass;
        this.theModel.Load(someClass);
        this.updateUI();
    }

    public void resetContents() {
        this.theMetaClass = null;
        this.theModel.theMetaClass = null;
        this.updateUI();
    }

    public void Reload(MetaClass someClass) {
        this.theMetaClass = someClass;
        this.theModel.Load(someClass);
    }

    public void selectItem() {
        String sSelectedItem = (String)this.getSelectedItem();
        this.selectItem(sSelectedItem);
    }

    public void appendItem(String sText) {
        this.theMetaClass.setProperty(this.theMetadataDispenser, sText, "", "", null, "", "", "set" + sText, "get" + sText, "", "", 0);
        this.Load(this.theMetaClass);
        this.selectProperty(sText);
    }

    public void selectItem(String sSelectedItem) {
        if (sSelectedItem.trim().length() == 0) {
            return;
        }
        this.configureEditor(this.getEditor(), sSelectedItem);
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!this.getItemAt(i).equals(sSelectedItem)) continue;
            this.selectProperty(sSelectedItem);
            return;
        }
        this.appendItem(sSelectedItem);
    }
}

