/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.LanguageManager;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JADialog;
import ch.abacus.lib.ui.JAFrame;
import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.JATabbedPane;
import ch.abacus.lib.ui.JATable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class IDEAboutBox
extends JADialog {
    private final SuperDesignCockpit theDesignCockpit;

    public IDEAboutBox(SuperDesignCockpit dc) {
        super((JAFrame)dc, dc.theLanguageManager.getMessage("AboutDialog.label", "About Design Cockpit"), true, false);
        this.theDesignCockpit = dc;
        LanguageManager lm = dc.theLanguageManager;
        if (this.theDesignCockpit.getOpenSourceState()) {
            this.setTitle("Abacus GUI Builder");
        }
        JATabbedPane theAboutBoxPane = new JATabbedPane();
        theAboutBoxPane.setBorder(BorderFactory.createRaisedBevelBorder());
        ProductInformationPanel theProductInfoPanel = new ProductInformationPanel(this.theDesignCockpit);
        SystemInformationPanel theSystemInfoPanel = new SystemInformationPanel(this.theDesignCockpit);
        theAboutBoxPane.addTab(lm.getMessage("AboutDialog.VersionInformation.label", "Version Information"), (Component)((Object)theProductInfoPanel));
        theAboutBoxPane.addTab(lm.getMessage("AboutDialog.SystemInformation.label", "System Information"), (Component)((Object)theSystemInfoPanel));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)theAboutBoxPane, "Center");
        JAPanel theButtonPanel = new JAPanel();
        theButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)theButtonPanel, "South");
        JAButton theButton = new JAButton(lm.getMessage("Dialogs.OK", "OK"));
        theButtonPanel.add((Component)theButton);
        theButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                IDEAboutBox.this.hide();
            }
        });
        this.setResizable(true);
        this.setSize(600, 320);
        this.setLocationRelativeTo(null);
        this.show(null);
    }

    class SystemInformationPanel
    extends JAPanel {
        public SystemInformationPanel(SuperDesignCockpit theDesignCockpit) {
            Properties sysprops = System.getProperties();
            SystemPropertyModel thePropertyModel = new SystemPropertyModel();
            Enumeration<?> e = sysprops.propertyNames();
            while (e.hasMoreElements()) {
                String sPropName = (String)e.nextElement();
                String sPropValue = System.getProperty(sPropName);
                thePropertyModel.addPair(sPropName, sPropValue);
            }
            JATable thePropertyTable = new JATable((TableModel)thePropertyModel);
            this.setLayout(new BorderLayout());
            this.add((Component)new JAScrollPane((Component)thePropertyTable));
        }
    }

    class SystemPropertyModel
    extends AbstractTableModel {
        int iRowCount = 0;
        ArrayList ColumnOneValues = new ArrayList(0);
        ArrayList ColumnTwoValues = new ArrayList(0);

        public void addPair(String sName, String sValue) {
            this.ColumnOneValues.add(sName);
            this.ColumnTwoValues.add(sValue);
        }

        public int getRowCount() {
            return this.ColumnOneValues.size();
        }

        public Object getValueAt(int iRow, int iCol) {
            if (iCol == 0) {
                return this.ColumnOneValues.get(iRow);
            }
            return this.ColumnTwoValues.get(iRow);
        }

        public String getColumnName(int iCol) {
            LanguageManager lm = ((IDEAboutBox)IDEAboutBox.this).theDesignCockpit.theLanguageManager;
            if (iCol == 0) {
                return lm.getMessage("AboutDialog.SystemInformation.PropertyName.label", "Property");
            }
            return lm.getMessage("AboutDialog.SystemInformation.PropertyValue.label", "Value");
        }

        public int getColumnCount() {
            return 2;
        }
    }

    class ProductInformationPanel
    extends JAPanel {
        public ProductInformationPanel(SuperDesignCockpit theDesignCockpit) {
            LanguageManager lm = theDesignCockpit.theLanguageManager;
            this.setLayout(new BorderLayout());
            String sHead = "<HTML><Body><CENTER>";
            String sFoot = "</Body></HTML>";
            String sDefaultToolName = theDesignCockpit.getOpenSourceState() ? "Abacus GUI Builder" : "Abacus Design Cockpit";
            String sCaption = "<B>" + lm.getMessage("AboutDialog.VersionInformation.ToolName.label", sDefaultToolName) + "</b><BR><p>";
            String sVersion = lm.expandMessage("AboutDialog.VersionInformation.ToolVersion.label", "Version: {0}", String.valueOf(0)) + "<P>";
            String sRevision = lm.expandMessage("AboutDialog.VersionInformation.ToolRevision.label", "Revision: {0}", String.valueOf(4)) + "<P>";
            String sSubRevision = lm.expandMessage("AboutDialog.VersionInformation.ToolSubRevision.label", "Sub Revsion: {0}", String.valueOf(9)) + "<P>";
            String sBuild = lm.expandMessage("AboutDialog.VersionInformation.ToolBuild.label", "Build: {0}", String.valueOf(1)) + "<P>";
            this.add((Component)new JALabel(sHead + sCaption + sVersion + sRevision + sSubRevision + sBuild + sFoot, 0), "Center");
        }
    }
}

