/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.CustomizerAlternativeClassesDialog;
import ch.abacus.designcockpit.ide.DesignCockpitPreferences;
import ch.abacus.designcockpit.ide.DesignProject;
import ch.abacus.designcockpit.ide.IDEComponentPalettePane;
import ch.abacus.designcockpit.ide.IDEObjectPopupMenu;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.customizer.CustomizerAvailableClass;
import ch.abacus.lib.ui.customizer.CustomizerDataConnectionInterface;
import ch.abacus.lib.ui.customizer.CustomizerDataElementInterface;
import ch.abacus.lib.ui.customizer.CustomizerDataTableInterface;
import ch.abacus.lib.ui.renderer.common.EnumerateProjectMetaObjectInterface;
import ch.abacus.lib.ui.renderer.common.HammerLanguagePresentation;
import ch.abacus.lib.ui.renderer.common.IDEComponentPaletteNode;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.tree.TreePath;

public class IDECustomizer
implements EnumerateProjectMetaObjectInterface {
    private final SuperDesignCockpit theEditor;
    private final CustomizerDataConnectionInterface theDataConnection;
    private boolean isCreatingSubElements = false;
    private String groupElementName;
    private DesignProject theDesignProject;
    private boolean bCustomizerLogging;
    private static final int CUSTOMIZER_VERSIONED = 314159265;
    private static final int CUSTOMIZER_DATA_VERSION = 2;

    public IDECustomizer(SuperDesignCockpit editor, CustomizerDataConnectionInterface theDataConnection) {
        this.theEditor = editor;
        this.theDataConnection = theDataConnection;
    }

    public void loadFormElements() {
        if (this.theDataConnection != null) {
            IDEComponentPalettePane theComponentPalettePane = this.theEditor.theComponentPalettePane;
            IDEComponentPaletteNode customizerNode = theComponentPalettePane.addCustomizerDataConnection(null, this.theDataConnection);
            this.createTables(customizerNode);
            theComponentPalettePane.theTree.expandPath(new TreePath(customizerNode.getPath()));
        }
    }

    private void createTables(IDEComponentPaletteNode customizerNode) {
        ArrayList tableList = this.theDataConnection.getDataTables();
        if (tableList != null) {
            for (int iTable = 0; iTable < tableList.size(); ++iTable) {
                this.createTable(tableList, iTable, customizerNode);
            }
        }
    }

    private void createTable(ArrayList tableList, int iTable, IDEComponentPaletteNode customizerNode) {
        CustomizerDataTableInterface dataTable = (CustomizerDataTableInterface)tableList.get(iTable);
        if (dataTable.getDataTableCount() > 0) {
            IDEComponentPaletteNode tableNode = this.theEditor.theComponentPalettePane.addCustomizerDataTable(customizerNode, dataTable, false, false);
            ArrayList subTableList = dataTable.getDataTables();
            for (int iSubTable = 0; iSubTable < subTableList.size(); ++iSubTable) {
                this.createTable(subTableList, iSubTable, tableNode);
            }
        } else {
            boolean bDeferDatatableElements = dataTable.getDataElementCount() == 0;
            IDEComponentPaletteNode tableNode = this.theEditor.theComponentPalettePane.addCustomizerDataTable(customizerNode, dataTable, false, bDeferDatatableElements);
            if (!bDeferDatatableElements) {
                this.createElements(dataTable, tableNode);
            } else {
                this.theEditor.theComponentPalettePane.addClass(tableNode, "XXX");
            }
        }
    }

    private void createElements(CustomizerDataTableInterface dataTable, IDEComponentPaletteNode tableNode) {
        ArrayList elementList = dataTable.getDataElements();
        for (int iElement = 0; iElement < elementList.size(); ++iElement) {
            this.createElement(elementList, iElement, tableNode);
        }
    }

    private void createElement(ArrayList elementList, int iElement, IDEComponentPaletteNode tableNode) {
        CustomizerDataElementInterface dataElement = (CustomizerDataElementInterface)elementList.get(iElement);
        MetaClass metaClassElement = this.theEditor.theMetadataDispenser.findClass(dataElement.getImplementingClass());
        IDEComponentPaletteNode elementNode = this.theEditor.theComponentPalettePane.addClass(tableNode, dataElement, metaClassElement);
        this.createSubElements(dataElement, elementNode);
    }

    private void createSubElements(CustomizerDataElementInterface dataElement, IDEComponentPaletteNode elementNode) {
        ArrayList subElementsList = dataElement.getListOfDataElements();
        if (subElementsList != null) {
            for (int iSubElement = 0; iSubElement < subElementsList.size(); ++iSubElement) {
                this.createSubElement(subElementsList, iSubElement, elementNode);
            }
        }
    }

    private void createSubElement(ArrayList subElementsList, int iSubElement, IDEComponentPaletteNode elementNode) {
        CustomizerDataElementInterface subElement = (CustomizerDataElementInterface)subElementsList.get(iSubElement);
        MetaClass metaClassSubElement = this.theEditor.theMetadataDispenser.findClass(subElement.getImplementingClass());
        this.theEditor.theComponentPalettePane.addClass(elementNode, subElement, metaClassSubElement);
    }

    public void setProperties(MetaObject metaObject, CustomizerDataElementInterface dataElement) {
        if (dataElement != null) {
            metaObject.setPropertyValue("DataTableName", 0, 0, (Object)dataElement.getDataTable().getDataTableName(), false);
            metaObject.setPropertyValue("DataColumnName", 0, 0, (Object)dataElement.getDataElementName(), false);
            metaObject.setPropertyValue("DataTableContext", 0, 0, (Object)dataElement.getDataTable().getDataTableContext(), false);
            metaObject.setPropertyValue("Name", 0, 0, (Object)this.getObjectName(dataElement), false);
            if (this.isCreatingSubElements) {
                String sGroupElement = dataElement.getParentDataElement().getDataElementName();
                metaObject.setPropertyValue("ElementGroup", 0, 0, (Object)sGroupElement, false);
            }
        }
    }

    public void newInstanceCreated(CustomizerDataElementInterface dataElement, MetaObject metaObject) {
        dataElement.newInstanceCreated(metaObject, dataElement);
    }

    public String getObjectName(CustomizerDataElementInterface dataElement) {
        String sObjectName = dataElement.getObjectName();
        if (sObjectName == null || sObjectName.equals("")) {
            sObjectName = "component_";
        }
        sObjectName = this.theEditor.getDesignProject().getNewObjectName(sObjectName);
        return sObjectName;
    }

    public void importElement(MetaObject theDesignObject, Point pt, boolean isShiftKeyDown) {
        IDEComponentPaletteNode selectedNode = this.theEditor.theComponentPalettePane.theTree.getSelectedNode();
        CustomizerDataElementInterface dataElement = selectedNode.getCustomizerDataElement();
        if (dataElement != null) {
            if (!selectedNode.isCustomizerDataElementGroup()) {
                this.isCreatingSubElements = false;
                this.theEditor.theViewDisplayer.importObject(theDesignObject, new Point(pt.x, pt.y), isShiftKeyDown, dataElement);
            } else {
                this.isCreatingSubElements = true;
                ArrayList subElementList = dataElement.getListOfDataElements();
                for (int iSubElement = 0; iSubElement < subElementList.size(); ++iSubElement) {
                    CustomizerDataElementInterface dataSubElement = (CustomizerDataElementInterface)subElementList.get(iSubElement);
                    this.theEditor.theViewDisplayer.importObject(theDesignObject, new Point(pt.x, pt.y + iSubElement * 32), isShiftKeyDown, dataSubElement);
                }
            }
            dataElement.setImplementingClass(null);
        }
    }

    public void loadPreferences(DesignCockpitPreferences designCockpitPreferences) {
        block7: {
            ObjectInputStream in = this.theDataConnection.getPreferencesInputStream();
            this.writeToLog("Requested getPreferencesInputStream of the DataConnection. Return = ", in);
            if (in != null) {
                try {
                    boolean bVersioned;
                    boolean bl = bVersioned = in.readInt() == 314159265;
                    if (bVersioned) {
                        int iVersion = in.readInt();
                        if (iVersion == 2) {
                            designCockpitPreferences.setFrameMaximized(in.readBoolean());
                            designCockpitPreferences.setFrameWidth(in.readInt());
                            designCockpitPreferences.setFrameHeight(in.readInt());
                            designCockpitPreferences.setFrameLeft(in.readInt());
                            designCockpitPreferences.setFrameTop(in.readInt());
                            designCockpitPreferences.setWidthColumnOne(in.readInt());
                            designCockpitPreferences.setWidthColumnTwo(in.readInt());
                            designCockpitPreferences.setSplitColumnOne(in.readInt());
                            designCockpitPreferences.setSplitColumnTwo(in.readInt());
                            designCockpitPreferences.setSplitColumnThree(in.readInt());
                            designCockpitPreferences.iSizeBoxHeight = in.readInt();
                            designCockpitPreferences.iSizeBoxWidth = in.readInt();
                            designCockpitPreferences.iViewDisplayerGridY = in.readInt();
                            designCockpitPreferences.iViewDisplayerGridX = in.readInt();
                            designCockpitPreferences.bDisplayGrid = in.readBoolean();
                            designCockpitPreferences.bSnapToGrid = in.readBoolean();
                            this.theDataConnection.preferencesLoaded(true);
                        } else {
                            this.writeToLog("loadPreference failed as data version not supported");
                        }
                        break block7;
                    }
                    this.writeToLog("loadPreference failed as data version not in data stream");
                }
                catch (IOException e) {
                    this.theDataConnection.preferencesLoaded(false);
                }
            } else {
                this.theDataConnection.preferencesLoaded(false);
            }
        }
    }

    public void savePreferences(DesignCockpitPreferences designCockpitPreferences) {
        ObjectOutputStream out = this.theDataConnection.getPreferencesOutputStream();
        this.writeToLog("Requested getPreferencesOutputStream of the DataConnection. Return = ", out);
        if (out != null) {
            try {
                out.writeInt(314159265);
                out.writeInt(2);
                out.writeBoolean(this.theEditor.theFramePlacement.isMaximized());
                Dimension frameSize = this.theEditor.theFramePlacement.getNormalSize();
                Point frameLocation = this.theEditor.theFramePlacement.getNormalLocation();
                out.writeInt(frameSize.width);
                out.writeInt(frameSize.height);
                out.writeInt(frameLocation.x);
                out.writeInt(frameLocation.y);
                out.writeInt(designCockpitPreferences.getWidthColumnOne());
                out.writeInt(designCockpitPreferences.getWidthColumnTwo());
                out.writeInt(designCockpitPreferences.getSplitColumnOne());
                out.writeInt(designCockpitPreferences.getSplitColumnTwo());
                out.writeInt(designCockpitPreferences.getSplitColumnThree());
                out.writeInt(designCockpitPreferences.iSizeBoxHeight);
                out.writeInt(designCockpitPreferences.iSizeBoxWidth);
                out.writeInt(designCockpitPreferences.iViewDisplayerGridY);
                out.writeInt(designCockpitPreferences.iViewDisplayerGridX);
                out.writeBoolean(designCockpitPreferences.bDisplayGrid);
                out.writeBoolean(designCockpitPreferences.bSnapToGrid);
                this.theDataConnection.preferencesSaved(true);
            }
            catch (IOException e) {
                this.theDataConnection.preferencesSaved(false);
            }
        } else {
            this.theDataConnection.preferencesSaved(false);
        }
    }

    public String getCustomizerTitle() {
        return this.theDataConnection.getCustomizerTitle();
    }

    public void selectElementGroupElements() {
        this.theDesignProject = this.theEditor.getDesignProject();
        int iSelectedObjectCount = this.theDesignProject.getSelectedObjectCount();
        for (int i = 0; i < iSelectedObjectCount; ++i) {
            MetaPropertyValueEx prop;
            MetaObject selectedObject = this.theDesignProject.getSelectedObject(i);
            if (selectedObject == null || (prop = selectedObject.getPropertyValue("ElementGroup", 0)) == null) continue;
            this.selectObjectsWithGroupElement(prop.getStringValue());
        }
    }

    private void selectObjectsWithGroupElement(String sGroupElementName) {
        this.groupElementName = sGroupElementName;
        MetaProject metaProject = this.theDesignProject.theMetaProject;
        MetaObject theDesignObject = this.theDesignProject.getFirstObject().getFirstChild();
        metaProject.enumerateObjects((EnumerateProjectMetaObjectInterface)this, theDesignObject);
    }

    public void callbackProjectMetaObject(MetaObject metaObject) {
        MetaPropertyValueEx prop = metaObject.getPropertyValue("ElementGroup", 0);
        if (prop != null && prop.getStringValue().equals(this.groupElementName) && !this.theDesignProject.isSelected(metaObject)) {
            this.theEditor.SelectObject(metaObject, true);
        }
    }

    public OutputStream getSaveProjectOutputStream() {
        OutputStream outputStream = this.theDataConnection.getSaveProjectOutputStream();
        this.writeToLog("Requesting getSaveProjectOutputStream from the Data Connection. Return = ", outputStream);
        return outputStream;
    }

    public void projectSaved(boolean ok) {
        this.writeToLog("Sending projectSaved to the Data Connection. Boolean OK = " + ok);
        this.theDataConnection.projectSaved(ok);
    }

    public InputStream getLoadProjectIntputStream() {
        InputStream inputStream = this.theDataConnection.getLoadProjectInputStream();
        this.writeToLog("Requesting getLoadProjectInputStream from the Data Connection. Return = ", inputStream);
        return inputStream;
    }

    public void projectLoaded(MetaProject metaProject, boolean ok) {
        metaProject.setGenerateAccessor(false);
        metaProject.setNLSTranslation(false);
        this.writeToLog("Sending projectLoaded to the Data Connection. Boolean OK = " + ok);
        this.theDataConnection.projectLoaded(ok);
    }

    void doEnumProjectMetaObjects(MetaProject metaProject) {
        PostLoadMetaObjectsEnumerator projectMetaObjectsEnumerator = new PostLoadMetaObjectsEnumerator(this);
        MetaObject theDesignObject = metaProject.getFirstObject().getFirstChild();
        metaProject.enumerateObjects((EnumerateProjectMetaObjectInterface)projectMetaObjectsEnumerator, theDesignObject);
    }

    public void addToContextMenu(IDEObjectPopupMenu menu, MetaObject metaObject) {
        if (metaObject.getPropertyMetadata("DataTableName") != null) {
            this.theDataConnection.addToContextMenu(menu, metaObject);
        }
    }

    public int querySaveOnExit() {
        this.writeToLog("Requesting querySaveOnExit of the DataConnection");
        return this.theDataConnection.querySaveOnExit();
    }

    public boolean populateDeferredDataElements(CustomizerDataTableInterface dataTable, IDEComponentPaletteNode tableNode) {
        boolean bPopulated = dataTable.populateDeferredDataElements();
        if (bPopulated) {
            tableNode.remove(0);
            this.createElements(dataTable, tableNode);
        }
        return bPopulated;
    }

    private void writeToLog(String sMessage) {
        if (this.bCustomizerLogging) {
            this.theEditor.theLogFile.doLogEntry("Customizer", sMessage);
        }
    }

    private void writeToLog(String sMessage, Object object) {
        if (this.bCustomizerLogging) {
            if (object != null) {
                this.writeToLog(sMessage + object.getClass());
            } else {
                this.writeToLog(sMessage + "(NULL)");
            }
        }
    }

    public void setCustomizerLogging(boolean bLogging) {
        this.bCustomizerLogging = bLogging;
    }

    public void languageChanged(int ilanguageId) {
        this.writeToLog("Language Changed To " + HammerLanguagePresentation.getLanguageName((int)ilanguageId));
        this.theDataConnection.languageChanged(ilanguageId);
    }

    public Icon getInstanceIcon(MetaObject metaObject) {
        Icon instanceIcon = this.theDataConnection.getInstanceIcon(metaObject);
        this.writeToLog("getInstanceIcon returns ", instanceIcon);
        return instanceIcon;
    }

    public String getProzName() {
        String sName = this.theDataConnection.getProzName();
        if (sName == null || sName.equalsIgnoreCase("")) {
            sName = "Customizer.proz";
        }
        this.writeToLog("getProzName returns ", sName);
        return sName;
    }

    public void removeFiles(String sOutputDirectoryName, String sClassName) {
        if (this.theDataConnection.canDeleteCompilerFiles()) {
            if (!sOutputDirectoryName.endsWith(File.separator)) {
                sOutputDirectoryName = sOutputDirectoryName + File.separator;
            }
            try {
                File file = new File(sOutputDirectoryName + sClassName + ".class");
                file.delete();
                file = new File(sOutputDirectoryName + sClassName + ".java");
                file.delete();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    public String getCompilerOutputDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public String getProjectDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public String getImplementingClass(CustomizerDataElementInterface dataElement) {
        CustomizerAvailableClass[] classes = dataElement.getAvailableImplementingClasses();
        if (classes == null) {
            return dataElement.getImplementingClass();
        }
        String[] sClassToCreate = new String[1];
        String sCaption = this.theEditor.theLanguageManager.getMessage("SelectAlternativeClassDialog.label", "Select Class");
        CustomizerAlternativeClassesDialog dialog = new CustomizerAlternativeClassesDialog(this.theEditor, sCaption, classes);
        dialog.setModal(true);
        dialog.show();
        sClassToCreate[0] = dialog.getSelectedClassName();
        dataElement.setImplementingClass(sClassToCreate[0]);
        return sClassToCreate[0];
    }

    public String getObjectDisplayName(MetaObject metaObject) {
        String sDisplayName = this.theDataConnection.getObjectDisplayName(metaObject);
        return sDisplayName;
    }

    class PostLoadMetaObjectsEnumerator
    implements EnumerateProjectMetaObjectInterface {
        private final IDECustomizer ideCustomizer;

        public PostLoadMetaObjectsEnumerator(IDECustomizer ideCustomizer) {
            this.ideCustomizer = ideCustomizer;
        }

        public void callbackProjectMetaObject(MetaObject metaObject) {
            this.ideCustomizer.theDataConnection.postLoadMetaObjectEnumerator(metaObject);
        }
    }
}

