/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.external.IDEFocusRequester;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.renderer.common.IDEComponentPaletteNode;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;

public class IDEViewDisplayerComponentMouseListener
implements MouseListener {
    MetaObject theDesignObject;
    MetaObject theDragAxisObject;
    Component theComponent;
    Cursor savedCursor = null;
    SuperDesignCockpit theDesignCockpit = null;

    public IDEViewDisplayerComponentMouseListener(MetaObject objDesignObject, MetaObject objDragAxisObject, SuperDesignCockpit theDesignCockpit, Component objComponent) {
        this.theDesignObject = objDesignObject;
        this.theDragAxisObject = objDragAxisObject;
        this.theComponent = objComponent;
        this.theDesignCockpit = theDesignCockpit;
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        if (this.theDesignCockpit.getMouseSelectState() && !evt.isShiftDown()) {
            if (evt.getButton() == 1) {
                boolean bCtrl = evt.isControlDown();
                if (!bCtrl) {
                    this.theDesignCockpit.deselectObjects();
                    this.theDesignCockpit.SelectObject(this.theDesignObject, bCtrl);
                    IDEFocusRequester.requestFocus(this.theDesignObject.theVisualObject);
                } else if (this.theDesignCockpit.getDesignProject().isSelected(this.theDesignObject)) {
                    this.theDesignCockpit.deselectObject(this.theDesignObject);
                } else {
                    this.theDesignCockpit.SelectObject(this.theDesignObject, bCtrl);
                }
            }
            this.theDragAxisObject.ptDrag = evt.getPoint();
            if (!evt.isPopupTrigger()) {
                this.savedCursor = this.theDesignObject.theVisualObject.getCursor();
                this.theDesignObject.theVisualObject.setCursor(new Cursor(12));
            }
            this.theDesignObject.bDragged = false;
            this.showPopup(evt);
        } else {
            IDEComponentPaletteNode selectedNode;
            Point pt = evt.getPoint();
            Point ptViewDisplayerScreen = this.theDesignCockpit.theViewDisplayer.getLocationOnScreen();
            Point ptObjectLocation = this.theDesignObject.theVisualObject.getLocationOnScreen();
            pt.x += ptObjectLocation.x - ptViewDisplayerScreen.x;
            pt.y += ptObjectLocation.y - ptViewDisplayerScreen.y;
            if (this.theDesignCockpit.importManager.test(evt.getWhen()) && (selectedNode = this.theDesignCockpit.theComponentPalettePane.theTree.getSelectedNode()) != null) {
                if (selectedNode.isCustomizerDataElement()) {
                    this.theDesignCockpit.theCustomizer.importElement(this.theDesignObject, pt, evt.isShiftDown());
                } else {
                    this.theDesignCockpit.theViewDisplayer.importObject(this.theDesignObject, pt, evt.isShiftDown(), null);
                }
            }
            this.theDesignCockpit.setMouseSelectState(true);
            IDEFocusRequester.requestFocus(this.theDesignObject.theVisualObject);
        }
    }

    public void mouseReleased(MouseEvent evt) {
        this.theDesignCockpit.theViewDisplayer.setMouseCoordinates(evt.getX(), evt.getY());
        if (this.theDesignCockpit.getMouseSelectState()) {
            this.theDesignObject.theVisualObject.setCursor(this.savedCursor);
            this.showPopup(evt);
        }
        if (this.theDesignObject.bDragged) {
            this.endDragging(this.theDesignObject);
        }
        this.theDesignCockpit.allowDragging(true);
    }

    private void showPopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.theDesignCockpit.theLastPopupMenu = this.theDesignCockpit.theViewDisplayer.thePopupMenu;
            Point pt = evt.getPoint();
            Point ptViewDisplayerScreen = this.theDesignCockpit.theViewDisplayer.getLocationOnScreen();
            Point ptObjectLocation = this.theDesignObject.theVisualObject.getLocationOnScreen();
            this.theDesignCockpit.theViewDisplayer.thePopupMenu.ptActualStrikePoint = new Point(pt.x, pt.y);
            pt.x += ptObjectLocation.x - ptViewDisplayerScreen.x;
            pt.y += ptObjectLocation.y - ptViewDisplayerScreen.y;
            this.theDesignCockpit.theViewDisplayer.thePopupMenu.ptLastPopupLocation = new Point(pt.x, pt.y);
            this.theDesignCockpit.theViewDisplayer.thePopupMenu.show((Component)((Object)this.theDesignCockpit.theViewDisplayer), pt.x, pt.y, this.theDesignObject);
        }
    }

    void beginResizing(MetaObject theMetaObject) {
        theMetaObject.bResizing = true;
        this.theDesignCockpit.getDesignProject().theUndoRedoController.createChangeSizeEvent(theMetaObject);
    }

    void beginDragging(MetaObject theMetaObject) {
        int iSelectedObjectCount = this.theDesignCockpit.getDesignProject().getSelectedObjectCount();
        ArrayList<MetaObject> theObjects = new ArrayList<MetaObject>(iSelectedObjectCount);
        for (int i = 0; i < iSelectedObjectCount; ++i) {
            theObjects.add(this.theDesignCockpit.getDesignProject().getSelectedObject(i));
        }
        this.theDesignCockpit.getDesignProject().theUndoRedoController.createChangeLocationEvent(theObjects);
        theMetaObject.bDragged = true;
    }

    void endResizing(MetaObject theMetaObject) {
        theMetaObject.bResizing = false;
    }

    void endDragging(MetaObject theMetaObject) {
        theMetaObject.doEndDrag();
    }
}

