/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide.propertyinspector;

import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.propertyinspector.display.renderer.ColorIcon;
import ch.abacus.lib.ui.propertyinspector.display.renderer.PropertyValueRenderer;
import ch.abacus.lib.ui.renderer.common.HammerClassCustomLoader;
import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ColorPropertyValueRenderer
extends PropertyValueRenderer {
    protected JALabel m_label = new JALabel();
    private String m_typeConstants;
    private SuperDesignCockpit m_superDesignCockpit;

    public ColorPropertyValueRenderer(SuperDesignCockpit superDesignCockpit, String sTypeConstants) {
        this.m_superDesignCockpit = superDesignCockpit;
        this.m_typeConstants = sTypeConstants;
        this.m_label.setOpaque(true);
    }

    public JComponent getComponent() {
        return this.m_label;
    }

    public void setValue(Object value) {
        Color currentColor = null;
        ColorIcon currentIcon = null;
        if (value != null) {
            currentColor = this.getItemColor((String)value);
            currentIcon = new ColorIcon(currentColor);
        }
        this.m_label.setText(value == null ? "" : value.toString());
        this.m_label.setIcon((Icon)currentIcon);
    }

    Color getItemColor(String avalue) {
        Object theResolvedValue = null;
        MetadataDispenser metadataDispenser = this.m_superDesignCockpit.theMetadataDispenser;
        MetaConstantGroupCollection theConstantTableGroup = metadataDispenser.findConstantGroupCollection(this.m_typeConstants);
        String nv = theConstantTableGroup.get(avalue);
        try {
            HammerClassCustomLoader loader = this.m_superDesignCockpit.getClassLoader().getLoader();
            theResolvedValue = MetaConstantGroup.resolve((Object)nv, (MetadataDispenser)metadataDispenser, (ClassLoader)loader);
        }
        catch (HammerException e) {
            e.printStackTrace();
        }
        return (Color)theResolvedValue;
    }
}

