/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.designcockpit.metadataEditor.ManageClassDialog;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JACheckBox;
import ch.abacus.lib.ui.JAComboBox;
import ch.abacus.lib.ui.JADialog;
import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JATextField;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ManageClassPropertyDialog
extends JADialog {
    final ManageClassDialog theDialog;
    protected MetaPropertyDescriptor theProperty;
    private boolean dialogModified = false;
    JATextField propertyName;
    PropertyClasses propertyClass;
    JATextField propertyGetMethod;
    JATextField propertySetMethod;
    ConstantGroups propertyConstantGroup;
    Defaults propertyDefaultValue;
    JACheckBox propertyVisible;
    JACheckBox propertyArray;
    JACheckBox propertyLanguages;
    JACheckBox propertyReadOnly;
    HelperClasses propertyHelperClass;
    MetaPropertyDescriptor theParentProperty = null;
    TreeSet theHelperClasses = new TreeSet();
    TreeSet thePropertyTypes = new TreeSet();
    TreeSet theDefaults = new TreeSet();

    public ManageClassPropertyDialog(ManageClassDialog dialog, MetaPropertyDescriptor metaProperty, MetaPropertyDescriptor parentProperty) {
        super((JADialog)dialog, null, true, false);
        this.theDialog = dialog;
        this.theProperty = metaProperty;
        this.theParentProperty = parentProperty;
        this.createLists();
        this.initDisplay();
        this.populateDisplay();
    }

    public ManageClassPropertyDialog(ManageClassDialog dialog, MetaPropertyDescriptor metaProperty) {
        this(dialog, metaProperty, null);
    }

    public boolean isDialogModified() {
        return this.dialogModified;
    }

    private void populateDisplay() {
        this.propertyName.setText(this.theProperty.getName());
        this.propertyClass.selectPropertyClass(this.theProperty.getClassName());
        this.propertyGetMethod.setText(this.theProperty.getGetMethod());
        this.propertySetMethod.setText(this.theProperty.getSetMethod());
        this.propertyConstantGroup.selectConstant(this.theProperty.getIncludeTypeConstants());
        this.propertyDefaultValue.selectDefault(this.theProperty.getDefaultValue());
        this.propertyVisible.setSelected(this.theProperty.bVisible);
        this.propertyArray.setSelected(this.theProperty.bAllowMultipleValues);
        this.propertyLanguages.setSelected(this.theProperty.bAllowMultipleLanguages);
        this.propertyReadOnly.setSelected(this.theProperty.isReadOnly());
        this.propertyHelperClass.selectHelperClass(this.theProperty.getHelperClass());
    }

    private void updateProperty() {
        this.theProperty.setName(this.propertyName.getText());
        this.theProperty.setClassName((String)this.propertyClass.getSelectedItem());
        this.theProperty.setGetMethod(this.propertyGetMethod.getText());
        this.theProperty.setSetMethod(this.propertySetMethod.getText());
        this.theProperty.setSimpleDefaultValue((String)this.propertyDefaultValue.getSelectedItem());
        this.theProperty.bVisible = this.propertyVisible.isSelected();
        this.theProperty.bAllowMultipleValues = this.propertyArray.isSelected();
        this.theProperty.bAllowMultipleLanguages = this.propertyLanguages.isSelected();
        this.theProperty.setReadOnly(this.propertyReadOnly.isSelected());
        this.theProperty.setHelperClass((String)this.propertyHelperClass.getSelectedItem());
        String sConstantGroup = (String)this.propertyConstantGroup.getSelectedItem();
        if (sConstantGroup.equals("<none>")) {
            sConstantGroup = null;
        }
        this.theProperty.setIncludeTypeConstants(sConstantGroup);
    }

    private void initDisplay() {
        this.propertyName = new JATextField();
        this.propertyClass = new PropertyClasses();
        this.propertyGetMethod = new JATextField();
        this.propertySetMethod = new JATextField();
        this.propertyConstantGroup = new ConstantGroups();
        this.propertyDefaultValue = new Defaults();
        this.propertyVisible = new JACheckBox("Visible");
        this.propertyArray = new JACheckBox("Array");
        this.propertyLanguages = new JACheckBox("languages");
        this.propertyReadOnly = new JACheckBox("Read-Only");
        this.propertyHelperClass = new HelperClasses();
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JAPanel pnlComponents = new JAPanel((LayoutManager)new GridBagLayout());
        pnlComponents.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pnlComponents.add((Component)new JALabel("Property Name"), (Object)c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        pnlComponents.add((Component)this.propertyName, (Object)c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pnlComponents.add((Component)new JALabel("Property's Class"), (Object)c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        pnlComponents.add((Component)((Object)this.propertyClass), (Object)c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pnlComponents.add((Component)new JALabel("Get Method"), (Object)c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        pnlComponents.add((Component)this.propertyGetMethod, (Object)c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pnlComponents.add((Component)new JALabel("Set Method"), (Object)c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        pnlComponents.add((Component)this.propertySetMethod, (Object)c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pnlComponents.add((Component)new JALabel("Constant Group"), (Object)c);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        pnlComponents.add((Component)((Object)this.propertyConstantGroup), (Object)c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pnlComponents.add((Component)new JALabel("Default Value"), (Object)c);
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        pnlComponents.add((Component)((Object)this.propertyDefaultValue), (Object)c);
        c.gridx = 1;
        c.gridy = 6;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pnlComponents.add((Component)this.propertyVisible, (Object)c);
        c.gridy = 7;
        pnlComponents.add((Component)this.propertyArray, (Object)c);
        c.gridy = 8;
        pnlComponents.add((Component)this.propertyLanguages, (Object)c);
        c.gridy = 9;
        pnlComponents.add((Component)this.propertyReadOnly, (Object)c);
        c.gridx = 0;
        c.gridy = 10;
        pnlComponents.add((Component)new JALabel("Helper Class"), (Object)c);
        c.gridx = 1;
        c.gridy = 10;
        c.gridwidth = 3;
        c.weightx = 1.0;
        pnlComponents.add((Component)((Object)this.propertyHelperClass), (Object)c);
        JAPanel pnlDialogButtons = new JAPanel((LayoutManager)new FlowLayout(2, 5, 5));
        pnlDialogButtons.setBorder((Border)BorderFactory.createTitledBorder(""));
        JAButton btnOK = new JAButton("OK");
        JAButton btnCancel = new JAButton("Cancel");
        btnOK.addActionListener((ActionListener)new OkAction(this));
        btnCancel.addActionListener((ActionListener)new CancelAction(this));
        pnlDialogButtons.add((Component)btnOK);
        pnlDialogButtons.add((Component)btnCancel);
        pane.add((Component)pnlComponents, "North");
        pane.add((Component)pnlDialogButtons, "South");
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CancelAction cancelAction = new CancelAction(ManageClassPropertyDialog.this);
                cancelAction.actionPerformed(new ActionEvent(this, 0, ""));
            }
        });
        String sTitle = this.theProperty.getName() == null ? (this.theParentProperty != null ? "Create new Subproperty" : "Create new Property") : "Edit the \"" + this.theProperty.getName() + "\" Property";
        this.setTitle(sTitle);
    }

    private void createLists() {
        ArrayList classes = new ArrayList();
        MetaClass firstClass = this.theDialog.theEditor.theMetadataDispenser.getFirstClass();
        this.enumerateClasses(firstClass, classes);
        for (MetaClass metaClass : classes) {
            for (MetaPropertyDescriptor property = metaClass.getMetadata().theFirstProperty; property != null; property = property.getNextProperty()) {
                String sDefault;
                String sDataType;
                String sHelperClass = property.getHelperClass();
                if (sHelperClass != null && !sHelperClass.equals("")) {
                    this.theHelperClasses.add(sHelperClass);
                }
                if ((sDataType = property.getClassName()) != null) {
                    this.thePropertyTypes.add(sDataType);
                }
                if ((sDefault = property.getDefaultValue()) == null) continue;
                this.theDefaults.add(sDefault);
            }
        }
    }

    void enumerateClasses(MetaClass theFirstClass, ArrayList classes) {
        for (MetaClass currClass = theFirstClass; currClass != null; currClass = currClass.getNextSibling()) {
            classes.add(currClass);
            if (currClass.getFirstClass() == null) continue;
            this.enumerateClasses(currClass.getFirstClass(), classes);
        }
    }

    class Defaults
    extends JAComboBox {
        public Defaults() {
            this.setEditable(true);
            this.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    Object selection = Defaults.this.getSelectedItem();
                    Defaults.this.setAppropriateModel();
                    Defaults.this.setSelectedItem(selection);
                }

                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }
            });
        }

        void setAppropriateModel() {
            Object[] constants = ManageClassPropertyDialog.this.propertyConstantGroup.getConstants();
            if (constants != null) {
                this.setModel(new DefaultComboBoxModel<Object>(constants));
            } else {
                this.setModel(new DefaultComboBoxModel<Object>(ManageClassPropertyDialog.this.theDefaults.toArray()));
            }
        }

        public void selectDefault(String sDefault) {
            this.setSelectedItem(sDefault);
        }
    }

    class HelperClasses
    extends JAComboBox {
        public HelperClasses() {
            super(ManageClassPropertyDialog.this.theHelperClasses.toArray());
            this.setEditable(true);
        }

        public void selectHelperClass(String sClass) {
            this.setSelectedItem(sClass);
        }
    }

    class PropertyClasses
    extends JAComboBox {
        public PropertyClasses() {
            super(ManageClassPropertyDialog.this.thePropertyTypes.toArray());
            this.setEditable(true);
        }

        public void selectPropertyClass(String sClass) {
            this.setSelectedItem(sClass);
        }
    }

    class ConstantGroups
    extends JAComboBox {
        public ConstantGroups() {
            Object[] groups = this.getConstantGroups();
            this.setModel(new DefaultComboBoxModel<Object>(groups));
        }

        Object[] getConstantGroups() {
            ArrayList<String> groups = new ArrayList<String>();
            groups.add("<none>");
            MetaConstantGroupCollection collection = ManageClassPropertyDialog.this.theDialog.theEditor.theMetadataDispenser.getFirstMetaConstantGroupCollection();
            while (collection != null) {
                groups.add(collection.sClassName);
                collection = collection.theNextSibling;
            }
            MetaConstantGroup group = ManageClassPropertyDialog.this.theDialog.theEditor.theMetadataDispenser.getFirstMetaConstantGroup();
            while (group != null) {
                groups.add(group.sClassName);
                group = group.theNextSibling;
            }
            return groups.toArray();
        }

        public void selectConstant(String sConstant) {
            if (sConstant == null || sConstant.equals("")) {
                sConstant = "<none>";
            }
            this.setSelectedItem(sConstant);
        }

        private boolean isGroupSelected() {
            return this.getSelectedItem() != "<none>";
        }

        Object[] getConstants() {
            if (this.isGroupSelected()) {
                String selectedItem = (String)this.getSelectedItem();
                MetaConstantGroupCollection collection = ManageClassPropertyDialog.this.theDialog.theEditor.theMetadataDispenser.findConstantGroupCollection(selectedItem);
                if (collection != null) {
                    return collection.getConstantList().toArray();
                }
                MetaConstantGroup group = ManageClassPropertyDialog.this.theDialog.theEditor.theMetadataDispenser.findConstantGroup(selectedItem);
                return group.getConstantList().toArray();
            }
            return null;
        }
    }

    class OkAction
    implements ActionListener {
        private final ManageClassPropertyDialog dialog;

        public OkAction(ManageClassPropertyDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            ManageClassPropertyDialog.this.dialogModified = true;
            this.dialog.updateProperty();
            this.dialog.hide();
        }
    }

    class CancelAction
    implements ActionListener {
        private final ManageClassPropertyDialog dialog;

        public CancelAction(ManageClassPropertyDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.dialog.dialogModified) {
                String sConfirmationText = "All changes will be lost. Are you sure you want to cancel ?";
                String sConfirmationTitle = "Cancel Changes";
                int optionType = 0;
                int messageType = 3;
                int iChoice = JOptionPane.showConfirmDialog((Component)((Object)this.dialog), sConfirmationText, sConfirmationTitle, optionType, messageType);
                if (iChoice == 0) {
                    this.dialog.dialogModified = false;
                    this.dialog.hide();
                }
            } else {
                ManageClassPropertyDialog.this.hide();
            }
        }
    }
}

