/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.designcockpit.metadataEditor.BufferedAction;
import ch.abacus.designcockpit.metadataEditor.MetadataEditor;
import ch.abacus.designcockpit.metadataEditor.MetadataEditorPageClasses;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JADialog;
import ch.abacus.lib.ui.JAFrame;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JATree;
import ch.abacus.lib.ui.renderer.common.IDEComponentPaletteNode;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaClassDetail;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import ch.abacus.lib.ui.validation.ValidationStaticMethods;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ManageClassesDialog
extends JADialog {
    final MetadataEditor editor;
    JATree treClasses = null;
    ArrayList bufferedActionCollection = new ArrayList();
    MetaClass theInitialSelectedMetaClass;
    MetadataEditorPageClasses.TableModel tableModel = null;
    DefaultTreeModel theTreeModel;
    IDEComponentPaletteNode baseClass = null;
    private IDEComponentPaletteNode theInitialSelectedMetaClassNode;

    public ManageClassesDialog(MetadataEditorPageClasses pageClasses, MetaClass selectedMetaClass) {
        super((JAFrame)pageClasses.editor, "Manage Classes", true, false);
        ValidationStaticMethods.setValidationEnabled((boolean)false);
        this.treClasses = new JATree();
        this.editor = pageClasses.editor;
        this.theInitialSelectedMetaClass = selectedMetaClass;
        this.initInterface();
        this.populateInterface();
    }

    private void initInterface() {
        MetaClass theFirstClass = this.editor.theMetadataDispenser.getFirstClass();
        this.theInitialSelectedMetaClassNode = this.baseClass = new IDEComponentPaletteNode(theFirstClass);
        this.theTreeModel = new DefaultTreeModel((TreeNode)this.baseClass);
        this.treClasses.setModel((TreeModel)this.theTreeModel);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JAPanel pnlConstants = new JAPanel((LayoutManager)new BorderLayout());
        pnlConstants.setBorder((Border)BorderFactory.createTitledBorder("Classes"));
        pnlConstants.add((Component)new JScrollPane((Component)this.treClasses), (Object)"Center");
        JAButton btnAdd = new JAButton("Add");
        JAButton btnRename = new JAButton("Rename");
        JAButton btnDelete = new JAButton("Delete");
        btnAdd.addActionListener((ActionListener)new AddClassAction(this));
        btnRename.addActionListener((ActionListener)new RenameClassAction(this));
        btnDelete.addActionListener((ActionListener)new DeleteClassAction(this));
        JAPanel pnlButtons = new JAPanel((LayoutManager)new FlowLayout(0, 5, 5));
        pnlButtons.add((Component)btnAdd);
        pnlButtons.add((Component)btnRename);
        pnlButtons.add((Component)btnDelete);
        pnlConstants.add((Component)pnlButtons, (Object)"South");
        pane.add((Component)pnlConstants, "Center");
        JAPanel pnlDialogButtons = new JAPanel((LayoutManager)new FlowLayout(2, 5, 5));
        JAButton btnOK = new JAButton("OK");
        JAButton btnCancel = new JAButton("Cancel");
        btnOK.addActionListener((ActionListener)new OkAction(this));
        btnCancel.addActionListener((ActionListener)new CancelAction(this));
        pnlDialogButtons.add((Component)btnOK);
        pnlDialogButtons.add((Component)btnCancel);
        pane.add((Component)pnlDialogButtons, "South");
        this.setSize(640, 480);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CancelAction cancelAction = new CancelAction(ManageClassesDialog.this);
                cancelAction.actionPerformed(new ActionEvent(this, 0, ""));
            }
        });
    }

    boolean loadClass(MetaClass theFirstClass, IDEComponentPaletteNode thisNode) {
        for (MetaClass currClass = theFirstClass; currClass != null; currClass = currClass.getNextSibling()) {
            IDEComponentPaletteNode theNewNode = new IDEComponentPaletteNode(currClass);
            if (currClass == this.theInitialSelectedMetaClass) {
                this.theInitialSelectedMetaClassNode = theNewNode;
            }
            if (thisNode == null) {
                this.theTreeModel.insertNodeInto((MutableTreeNode)theNewNode, (MutableTreeNode)this.baseClass, this.baseClass.getChildCount());
            } else {
                this.theTreeModel.insertNodeInto((MutableTreeNode)theNewNode, (MutableTreeNode)thisNode, thisNode.getChildCount());
            }
            if (currClass.getFirstClass() == null) continue;
            this.loadClass(currClass.getFirstClass(), theNewNode);
        }
        return true;
    }

    public TreePath getTreePath(IDEComponentPaletteNode node) {
        ArrayList<IDEComponentPaletteNode> list = new ArrayList<IDEComponentPaletteNode>();
        while (node != null) {
            list.add(node);
            node = (IDEComponentPaletteNode)node.getParent();
        }
        Collections.reverse(list);
        return new TreePath(list.toArray());
    }

    private void populateInterface() {
        MetaClass theFirstClass = this.editor.theMetadataDispenser.getFirstClass();
        this.loadClass(theFirstClass.getFirstClass(), this.baseClass);
        if (this.theInitialSelectedMetaClassNode == this.baseClass) {
            this.treClasses.expandRow(0);
        }
        TreePath treePath = this.getTreePath(this.theInitialSelectedMetaClassNode);
        this.treClasses.setSelectionPath(treePath);
        this.treClasses.makeVisible(treePath);
        this.treClasses.scrollPathToVisible(treePath);
    }

    class OkAction
    implements ActionListener {
        private final ManageClassesDialog dialog;

        public OkAction(ManageClassesDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            MetadataDispenser theMetadataDispenser = this.dialog.editor.theMetadataDispenser;
            if (this.dialog.bufferedActionCollection.size() == 0) {
                return;
            }
            ManageClassesDialog.this.editor.setMetadataModified(true);
            block5: for (int iAction = 0; iAction < this.dialog.bufferedActionCollection.size(); ++iAction) {
                BufferedAction bufferedAction = (BufferedAction)this.dialog.bufferedActionCollection.get(iAction);
                switch (bufferedAction.getActionType()) {
                    case 1: {
                        MetaClass metaClass = theMetadataDispenser.findClass(bufferedAction.getOldName());
                        if (metaClass != null) {
                            metaClass.getMetadata().sClassName = bufferedAction.getNewName();
                            continue block5;
                        }
                        System.out.println("Cannot Rename Class " + bufferedAction.getOldName() + ", as it cannot be found");
                        continue block5;
                    }
                    case 3: {
                        MetaClass metaSuperclass = theMetadataDispenser.findClass(bufferedAction.getOldName());
                        if (metaSuperclass == null) continue block5;
                        this.createSubclass(metaSuperclass, bufferedAction.getNewName());
                        continue block5;
                    }
                    case 2: {
                        MetaClass metaClass = theMetadataDispenser.findClass(bufferedAction.getOldName());
                        if (metaClass != null) {
                            metaClass.DeleteClass();
                            continue block5;
                        }
                        System.out.println("Cannot Delete Class \"" + bufferedAction.getOldName() + "\", as it cannot be found");
                        continue block5;
                    }
                }
            }
            this.dialog.hide();
        }

        public MetaClass createSubclass(MetaClass metaSuperclass, String sClassName) {
            MetadataDispenser theMetadataDispenser = this.dialog.editor.theMetadataDispenser;
            String sNewFullClassName = metaSuperclass.theMetadata.sFullClassName.substring(0, metaSuperclass.theMetadata.sFullClassName.lastIndexOf(".")) + "." + sClassName;
            MetaClassDetail theClass = new MetaClassDetail(sClassName, sNewFullClassName);
            MetaClass theMetaClass = new MetaClass(theClass, metaSuperclass, theMetadataDispenser, true);
            String sSuperClassName = metaSuperclass.theMetadata.sClassName;
            String sFullPathName = metaSuperclass.theMetadata.sFullClassName;
            theClass.setSuperClass(sSuperClassName, sFullPathName);
            theClass.setDisplayClass(sNewFullClassName);
            theClass.containerType = metaSuperclass.theMetadata.containerType;
            metaSuperclass.addClass(theMetaClass);
            return theMetaClass;
        }
    }

    class CancelAction
    implements ActionListener {
        private final ManageClassesDialog dialog;

        public CancelAction(ManageClassesDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.dialog.bufferedActionCollection.size() > 0) {
                String sConfirmationText = "All changes will be lost. Are you sure you want to cancel ?";
                String sConfirmationTitle = "Cancel Changes";
                int optionType = 0;
                int messageType = 3;
                int iChoice = JOptionPane.showConfirmDialog((Component)((Object)this.dialog), sConfirmationText, sConfirmationTitle, optionType, messageType);
                if (iChoice == 0) {
                    this.dialog.hide();
                }
            } else {
                ManageClassesDialog.this.hide();
            }
        }
    }

    class DeleteClassAction
    implements ActionListener {
        private final ManageClassesDialog dialog;

        public DeleteClassAction(ManageClassesDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            int messageType;
            int optionType;
            String sConfirmationTitle;
            IDEComponentPaletteNode node = (IDEComponentPaletteNode)ManageClassesDialog.this.treClasses.getLastSelectedPathComponent();
            if (node == null) {
                JOptionPane.showMessageDialog((Component)((Object)this.dialog), "You must select a class before you can delete it.", "No Class Selected", 0);
                return;
            }
            String sClassName = (String)node.getUserObject();
            String sConfirmationText = "Are you sure you want to delete the class  \"" + sClassName + "\" and all its subclasses ?";
            int iChoice = JOptionPane.showConfirmDialog((Component)((Object)this.dialog), sConfirmationText, sConfirmationTitle = "Delete Class", optionType = 0, messageType = 3);
            if (iChoice == 0) {
                this.addBufferedAction(sClassName);
                IDEComponentPaletteNode nextNode = (IDEComponentPaletteNode)node.getNextSibling();
                node.removeFromParent();
                ManageClassesDialog.this.treClasses.updateUI();
                if (nextNode != null) {
                    ManageClassesDialog.this.treClasses.setSelectionPath(ManageClassesDialog.this.getTreePath(nextNode));
                } else {
                    ManageClassesDialog.this.treClasses.setSelectionRow(0);
                }
            }
        }

        void addBufferedAction(String sClassName) {
            BufferedAction bufferedAction = new BufferedAction();
            bufferedAction.setActionDelete(sClassName);
            ManageClassesDialog.this.bufferedActionCollection.add(bufferedAction);
        }
    }

    class AddClassAction
    implements ActionListener {
        private final ManageClassesDialog dialog;

        public AddClassAction(ManageClassesDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            IDEComponentPaletteNode parentNode = (IDEComponentPaletteNode)ManageClassesDialog.this.treClasses.getLastSelectedPathComponent();
            if (parentNode == null) {
                JOptionPane.showMessageDialog((Component)((Object)this.dialog), "You must select a Superclass before you can add a class.", "No Superclass Selected", 0);
                return;
            }
            String sSuperclass = (String)parentNode.getUserObject();
            String sNewName = JOptionPane.showInputDialog("Add New Subclass of " + sSuperclass + ":");
            if (sNewName != null) {
                this.addBufferedAction(sSuperclass, sNewName);
                IDEComponentPaletteNode subclassNode = new IDEComponentPaletteNode(sNewName);
                ManageClassesDialog.this.theTreeModel.insertNodeInto((MutableTreeNode)subclassNode, (MutableTreeNode)parentNode, parentNode.getChildCount());
                TreePath treePath = ManageClassesDialog.this.getTreePath(subclassNode);
                ManageClassesDialog.this.treClasses.setSelectionPath(treePath);
                ManageClassesDialog.this.treClasses.scrollPathToVisible(treePath);
                ManageClassesDialog.this.treClasses.updateUI();
            }
        }

        void addBufferedAction(String sSuperclass, String sSubclass) {
            BufferedAction bufferedAction = new BufferedAction();
            bufferedAction.setActionAdd(sSuperclass, sSubclass);
            ManageClassesDialog.this.bufferedActionCollection.add(bufferedAction);
        }
    }

    class RenameClassAction
    implements ActionListener {
        private final ManageClassesDialog dialog;

        public RenameClassAction(ManageClassesDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            IDEComponentPaletteNode node = (IDEComponentPaletteNode)ManageClassesDialog.this.treClasses.getLastSelectedPathComponent();
            if (node == null) {
                JOptionPane.showMessageDialog((Component)((Object)this.dialog), "You must select a class before you can rename it.", "No Class Selected", 0);
                return;
            }
            String sOldName = (String)node.getUserObject();
            String sNewName = JOptionPane.showInputDialog("Rename Class \"" + sOldName + "\"\n\nPlease enter new name:");
            if (sNewName != null) {
                this.addBufferedAction(sOldName, sNewName);
                node.setUserObject((Object)sNewName);
                ManageClassesDialog.this.treClasses.updateUI();
            }
        }

        void addBufferedAction(String sOldName, String sNewName) {
            BufferedAction bufferedAction = new BufferedAction();
            bufferedAction.setActionRename(sOldName, sNewName);
            ManageClassesDialog.this.bufferedActionCollection.add(bufferedAction);
        }
    }
}

