/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.designcockpit.metadataEditor.BufferedAction;
import ch.abacus.designcockpit.metadataEditor.MetadataEditor;
import ch.abacus.designcockpit.metadataEditor.MetadataEditorPageConstantCollections;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JAList;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class ManageConstantCollectionsDialog
extends JDialog {
    final MetadataEditor editor;
    JAList lstCollection = null;
    ArrayList bufferedActionCollection = new ArrayList();
    ManageConstantCollectionsDialog thisObject;

    public ManageConstantCollectionsDialog(MetadataEditorPageConstantCollections pageCollections, String sCaption, String sCollectionTitle) {
        super((Frame)((Object)pageCollections.editor), sCaption, true);
        this.lstCollection = new JAList();
        this.editor = pageCollections.editor;
        this.initDisplay(sCollectionTitle, (JComponent)this.lstCollection);
        this.displayCollections(this.getCollections(), (String)pageCollections.lstCollections.getSelectedValue());
        this.thisObject = this;
    }

    private void initDisplay(String sCaption, JComponent list) {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JAPanel pnlConstants = new JAPanel((LayoutManager)new BorderLayout());
        pnlConstants.setBorder((Border)BorderFactory.createTitledBorder(sCaption));
        pnlConstants.add((Component)new JScrollPane(list), (Object)"Center");
        JAButton btnAdd = new JAButton("Add");
        JAButton btnRename = new JAButton("Rename");
        JAButton btnDelete = new JAButton("Delete");
        btnAdd.addActionListener((ActionListener)new AddCollectionAction(this));
        btnRename.addActionListener((ActionListener)new RenameCollectionAction(this));
        btnDelete.addActionListener((ActionListener)new DeleteCollectionAction(this));
        JAPanel pnlButtons = new JAPanel((LayoutManager)new FlowLayout(0, 5, 5));
        pnlButtons.add((Component)btnAdd);
        pnlButtons.add((Component)btnRename);
        pnlButtons.add((Component)btnDelete);
        pnlConstants.add((Component)pnlButtons, (Object)"South");
        pane.add((Component)pnlConstants, "Center");
        JAPanel pnlDialogButtons = new JAPanel((LayoutManager)new FlowLayout(2, 5, 5));
        JAButton btnOK = new JAButton("OK");
        JAButton btnCancel = new JAButton("Cancel");
        btnOK.addActionListener((ActionListener)new OkAction(this));
        btnCancel.addActionListener((ActionListener)new CancelAction(this));
        pnlDialogButtons.add((Component)btnOK);
        pnlDialogButtons.add((Component)btnCancel);
        pane.add((Component)pnlDialogButtons, "South");
        this.setSize(400, 300);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CancelAction cancelAction = new CancelAction(ManageConstantCollectionsDialog.this.thisObject);
                cancelAction.actionPerformed(new ActionEvent(this, 0, ""));
            }
        });
    }

    Object[] getCollections() {
        ArrayList<String> collections = new ArrayList<String>();
        MetaConstantGroupCollection collection = this.editor.theMetadataDispenser.getFirstMetaConstantGroupCollection();
        while (collection != null) {
            collections.add(collection.sClassName);
            collection = collection.theNextSibling;
        }
        return collections.toArray();
    }

    void displayCollections(Object[] collections, String selectedCollection) {
        this.lstCollection.setListData(collections);
        if (selectedCollection != null) {
            this.lstCollection.setSelectedValue((Object)selectedCollection, true);
        } else if (this.lstCollection.getModel().getSize() > 0) {
            this.lstCollection.setSelectedIndex(0);
        }
    }

    class OkAction
    implements ActionListener {
        private final ManageConstantCollectionsDialog dialog;

        public OkAction(ManageConstantCollectionsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            MetadataDispenser theMetadataDispenser = this.dialog.editor.theMetadataDispenser;
            if (this.dialog.bufferedActionCollection.size() == 0) {
                return;
            }
            block5: for (int iAction = 0; iAction < this.dialog.bufferedActionCollection.size(); ++iAction) {
                BufferedAction bufferedAction = (BufferedAction)this.dialog.bufferedActionCollection.get(iAction);
                switch (bufferedAction.getActionType()) {
                    case 1: {
                        MetaConstantGroupCollection collection = theMetadataDispenser.findConstantGroupCollection(bufferedAction.getOldName());
                        if (collection != null) {
                            collection.sClassName = bufferedAction.getNewName();
                            continue block5;
                        }
                        System.out.println("Cannot Rename Collection " + bufferedAction.getOldName() + ", as it cannot be found");
                        continue block5;
                    }
                    case 3: {
                        MetaConstantGroupCollection collection = new MetaConstantGroupCollection(bufferedAction.getNewName(), theMetadataDispenser);
                        collection.theNextSibling = null;
                        MetaConstantGroupCollection theLastCollection = theMetadataDispenser.getLastMetaConstantGroupCollection();
                        if (theLastCollection == null) {
                            theMetadataDispenser.setFirstMetaConstantGroupCollection(collection);
                        } else {
                            theLastCollection.theNextSibling = collection;
                            collection.thePreviousSibling = theLastCollection;
                        }
                        theMetadataDispenser.setLastMetaConstantGroupCollection(collection);
                        continue block5;
                    }
                    case 2: {
                        MetaConstantGroupCollection collection = theMetadataDispenser.findConstantGroupCollection(bufferedAction.getOldName());
                        if (collection != null) {
                            MetaConstantGroupCollection theFirstCollection = theMetadataDispenser.getFirstMetaConstantGroupCollection();
                            MetaConstantGroupCollection theLastCollection = theMetadataDispenser.getLastMetaConstantGroupCollection();
                            if (collection == theFirstCollection) {
                                theMetadataDispenser.setFirstMetaConstantGroupCollection(theFirstCollection.theNextSibling);
                                if (theFirstCollection != theLastCollection) {
                                    theMetadataDispenser.getFirstMetaConstantGroupCollection().thePreviousSibling = null;
                                } else {
                                    theMetadataDispenser.setLastMetaConstantGroupCollection(null);
                                }
                                collection = null;
                                continue block5;
                            }
                            if (collection == theLastCollection) {
                                theMetadataDispenser.setLastMetaConstantGroupCollection(theLastCollection.thePreviousSibling);
                                theMetadataDispenser.getLastMetaConstantGroupCollection().theNextSibling = null;
                                collection = null;
                                continue block5;
                            }
                            collection.thePreviousSibling.theNextSibling = collection.theNextSibling;
                            collection.theNextSibling.thePreviousSibling = collection.thePreviousSibling;
                            collection = null;
                            continue block5;
                        }
                        System.out.println("Cannot Delete Collection \"" + bufferedAction.getOldName() + "\", as it cannot be found");
                        continue block5;
                    }
                }
            }
            this.dialog.hide();
        }
    }

    class CancelAction
    implements ActionListener {
        private final ManageConstantCollectionsDialog dialog;

        public CancelAction(ManageConstantCollectionsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.dialog.bufferedActionCollection.size() > 0) {
                String sConfirmationText = "All changes will be lost. Are you sure you want to cancel ?";
                String sConfirmationTitle = "Cancel Changes";
                int optionType = 0;
                int messageType = 3;
                int iChoice = JOptionPane.showConfirmDialog(this.dialog, sConfirmationText, sConfirmationTitle, optionType, messageType);
                if (iChoice == 0) {
                    this.dialog.hide();
                }
            } else {
                ManageConstantCollectionsDialog.this.hide();
            }
        }
    }

    class DeleteCollectionAction
    implements ActionListener {
        private final ManageConstantCollectionsDialog dialog;

        public DeleteCollectionAction(ManageConstantCollectionsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            int messageType;
            int optionType;
            String sConfirmationTitle;
            int iSelectedIndex = this.dialog.lstCollection.getSelectedIndex();
            if (iSelectedIndex == -1) {
                JOptionPane.showMessageDialog(this.dialog, "You must select a collection before you can delete it.", "No Collection Selected", 0);
                return;
            }
            String sOldName = (String)this.dialog.lstCollection.getSelectedValue();
            String sConfirmationText = "Are you sure you want to delete the collection  \"" + sOldName + "\" ?";
            int iChoice = JOptionPane.showConfirmDialog(this.dialog, sConfirmationText, sConfirmationTitle = "Delete Constant-Group Collection", optionType = 0, messageType = 3);
            if (iChoice == 0) {
                this.addBufferedAction(sOldName);
                int iNumNames = this.dialog.lstCollection.getModel().getSize();
                Object[] names = new String[iNumNames - 1];
                int iName = 0;
                for (int iLoop = 0; iLoop < iNumNames; ++iLoop) {
                    if (iLoop == iSelectedIndex) continue;
                    names[iName] = (String)this.dialog.lstCollection.getModel().getElementAt(iLoop);
                    ++iName;
                }
                String sCollectionToSelect = null;
                if (iSelectedIndex != iNumNames - 1) {
                    sCollectionToSelect = (String)this.dialog.lstCollection.getModel().getElementAt(iSelectedIndex + 1);
                }
                ManageConstantCollectionsDialog.this.displayCollections(names, sCollectionToSelect);
            }
        }

        void addBufferedAction(String sOldName) {
            BufferedAction bufferedAction = new BufferedAction();
            bufferedAction.setActionDelete(sOldName);
            ManageConstantCollectionsDialog.this.bufferedActionCollection.add(bufferedAction);
        }
    }

    class AddCollectionAction
    implements ActionListener {
        private final ManageConstantCollectionsDialog dialog;

        public AddCollectionAction(ManageConstantCollectionsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            String sNewName = JOptionPane.showInputDialog("Add New Collection:");
            if (sNewName != null) {
                this.addBufferedAction(sNewName);
                int iNumNames = this.dialog.lstCollection.getModel().getSize();
                Object[] names = new String[iNumNames + 1];
                for (int iName = 0; iName < iNumNames; ++iName) {
                    names[iName] = (String)this.dialog.lstCollection.getModel().getElementAt(iName);
                }
                names[iNumNames] = sNewName;
                ManageConstantCollectionsDialog.this.displayCollections(names, sNewName);
            }
        }

        void addBufferedAction(String sNewName) {
            BufferedAction bufferedAction = new BufferedAction();
            bufferedAction.setActionAdd(sNewName);
            ManageConstantCollectionsDialog.this.bufferedActionCollection.add(bufferedAction);
        }
    }

    class RenameCollectionAction
    implements ActionListener {
        private final ManageConstantCollectionsDialog dialog;

        public RenameCollectionAction(ManageConstantCollectionsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            int iSelectedIndex = this.dialog.lstCollection.getSelectedIndex();
            if (iSelectedIndex == -1) {
                JOptionPane.showMessageDialog(this.dialog, "You must select a collection before you can rename it.", "No Collection Selected", 0);
                return;
            }
            String sOldName = (String)this.dialog.lstCollection.getSelectedValue();
            String sNewName = JOptionPane.showInputDialog("Rename Collection \"" + sOldName + "\"\n\nPlease enter new name:");
            if (sNewName != null) {
                this.addBufferedAction(sOldName, sNewName);
                int iNumNames = this.dialog.lstCollection.getModel().getSize();
                Object[] names = new String[iNumNames];
                for (int iName = 0; iName < iNumNames; ++iName) {
                    names[iName] = (String)this.dialog.lstCollection.getModel().getElementAt(iName);
                }
                names[iSelectedIndex] = sNewName;
                ManageConstantCollectionsDialog.this.displayCollections(names, sNewName);
            }
        }

        void addBufferedAction(String sOldName, String sNewName) {
            BufferedAction bufferedAction = new BufferedAction();
            bufferedAction.setActionRename(sOldName, sNewName);
            ManageConstantCollectionsDialog.this.bufferedActionCollection.add(bufferedAction);
        }
    }
}

