/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.designcockpit.ide.DesignCockpitPreferences;
import ch.abacus.designcockpit.metadataEditor.ActionManager;
import ch.abacus.designcockpit.metadataEditor.JarModifier;
import ch.abacus.designcockpit.metadataEditor.MenuBar;
import ch.abacus.designcockpit.metadataEditor.MetadataEditorPageClasses;
import ch.abacus.designcockpit.metadataEditor.MetadataEditorPageConstantCollections;
import ch.abacus.designcockpit.metadataEditor.MetadataEditorPageConstants;
import ch.abacus.designcockpit.metadataEditor.MetadataEditorPageGeneral;
import ch.abacus.designcockpit.metadataEditor.MetadataEditorUser;
import ch.abacus.lib.ui.JAFrame;
import ch.abacus.lib.ui.JATabbedPane;
import ch.abacus.lib.ui.renderer.common.AbaMetaDataUser;
import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import ch.abacus.lib.ui.renderer.common.MetadataDocumentGenerator;
import ch.abacus.lib.ui.validation.ValidationStaticMethods;
import ch.abacus.lib.util.GlobalInterface;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.ParseException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class MetadataEditor
extends JAFrame {
    MetadataEditor editor = null;
    Document document = null;
    Element xmlSystemRoot = null;
    String DesignBorderDefinition = null;
    ActionManager theActionManager = new ActionManager(this);
    MenuBar mainMenu = new MenuBar(this.theActionManager);
    MetadataEditorUser theMetadataEditorUser = new MetadataEditorUser();
    MetadataEditorPageGeneral pageGeneral = null;
    MetadataEditorPageConstants pageConstants = null;
    MetadataEditorPageConstantCollections pageCollections = null;
    private MetadataEditorPageClasses pageClasses = null;
    public MetadataDispenser theMetadataDispenser;
    public GlobalInterface theGlobalInterface = null;
    private final int iVersionNumber = 1;
    private final int iRevisionNumber = 0;
    private final int iSubRevisionNumber = 4;
    private final int iBuildNumber = 3;
    String sImageDirectory = "";
    File metaDataFile = null;
    public DesignCockpitPreferences thePreferences = null;
    private boolean metadataModified;

    public MetadataEditor(String sConfigurationPath, String sConfigurationDoc, String sMetadataDocument) {
        super(false);
        ValidationStaticMethods.setValidationEnabled((boolean)false);
        this.editor = this;
        this.setMinimumFrameSize(JAFrame.FRAME_MINIMUM_SIZE_MEDIUM);
        this.setSize(900, 700);
        this.setTitle("Maintain Metadata");
        this.setLocationRelativeTo(null);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MetadataEditor.this.exitApplication();
            }
        });
        this.loadMetadata(sConfigurationPath, sConfigurationDoc, sMetadataDocument);
        this.setJMenuBar((JMenuBar)((Object)this.mainMenu));
        JATabbedPane workarea = new JATabbedPane();
        workarea.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.pageGeneral = new MetadataEditorPageGeneral(this);
        this.pageConstants = new MetadataEditorPageConstants(this);
        this.pageCollections = new MetadataEditorPageConstantCollections(this);
        this.pageClasses = new MetadataEditorPageClasses(this);
        workarea.addTab("General", (Component)((Object)this.pageGeneral));
        workarea.addTab("Constants", (Component)((Object)this.pageConstants));
        workarea.addTab("Constant Collections", (Component)((Object)this.pageCollections));
        workarea.addTab("Classes", (Component)((Object)this.pageClasses));
        pane.add((Component)workarea, "Center");
        this.setContentPane(pane);
    }

    private void openFile(String sFile) {
        System.out.println("file=" + sFile);
        File file = new File(sFile);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        BufferedInputStream theMetadataStream = new BufferedInputStream(in);
        try {
            this.document = new Document((InputStream)theMetadataStream);
            this.xmlSystemRoot = this.document.getRoot();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    void saveMetadata() {
        boolean bMetaInJar;
        this.pageGeneral.save();
        String sMetadataFile = null;
        String sMetadataEntryName = null;
        String sMetadataJarName = null;
        boolean bl = bMetaInJar = this.theMetadataDispenser.theMetadataDocument.mode == 2;
        if (bMetaInJar) {
            sMetadataEntryName = this.theMetadataDispenser.theMetadataDocument.sJarEntryName;
            sMetadataJarName = this.theMetadataDispenser.theMetadataDocument.sJarName;
            try {
                File jarDirectory = new File(sMetadataJarName).getParentFile();
                sMetadataFile = File.createTempFile("metadata_", ".meta", jarDirectory).getPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            sMetadataFile = this.theMetadataDispenser.theMetadataDocument.sFullPathName;
        }
        MetadataDocumentGenerator theGenerator = null;
        try {
            theGenerator = new MetadataDocumentGenerator(sMetadataFile, this.theMetadataDispenser.getFirstClass(), this.theMetadataDispenser.getLastClass());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (bMetaInJar) {
                File metadataFile = new File(sMetadataFile);
                File inUseFile = new File(sMetadataJarName + "_temp");
                JarModifier jarModifier = new JarModifier(new File(sMetadataJarName), inUseFile);
                File backupFile = new File(sMetadataJarName + "_orig");
                this.makeFileBackup(sMetadataJarName, backupFile.getPath());
                theGenerator.GenerateFromMetadata(this.theMetadataDispenser);
                jarModifier.replaceFile(new File(sMetadataEntryName), metadataFile);
                metadataFile.delete();
                JOptionPane.showConfirmDialog((Component)((Object)this), "The metadata file has been saved in the JAR.\n\n(The original file has been renamed as \"" + backupFile.getName() + "\")", "Metadata Saved", -1, 1);
            } else {
                File metaFile = new File(sMetadataFile);
                File backupFile = new File(sMetadataFile + "_orig");
                if (backupFile.exists()) {
                    backupFile.delete();
                }
                metaFile.renameTo(new File(sMetadataFile + "_orig"));
                theGenerator.GenerateFromMetadata(this.theMetadataDispenser);
                JOptionPane.showConfirmDialog((Component)((Object)this), "The metadata file has been saved.\n\n(The original file has been renamed as \"" + backupFile.getName() + "\")", "Metadata Saved", -1, 1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.metadataModified = false;
    }

    private void makeFileBackup(String sMetadataFile, String sNewName) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(sMetadataFile);
        FileOutputStream out = new FileOutputStream(sNewName);
        File newFile = new File(sNewName);
        newFile.delete();
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public void setMetadataModified(boolean bModified) {
        this.metadataModified = bModified;
    }

    public boolean isMetadataModified() {
        return this.metadataModified;
    }

    public int getVersionNumber() {
        return 1;
    }

    public int getRevisionNumber() {
        return 0;
    }

    public int getSubRevisionNumber() {
        return 4;
    }

    public int getBuildNumber() {
        return 3;
    }

    private void loadMetadata(String sConfigurationPath, String sConfigurationDocument, String sMetadataDocument) {
        if (sConfigurationPath == null) {
            sConfigurationPath = "ch.abacus.lib.ui.renderer.deploy.";
        }
        if (sConfigurationDocument == null) {
            sConfigurationDocument = "hammer-configuration.xml";
        }
        if (sMetadataDocument == null) {
            sMetadataDocument = "metadata.meta";
        }
        this.theMetadataEditorUser.setSystemConfigurationPathName(sConfigurationPath);
        this.theMetadataEditorUser.setSystemConfigurationDocumentName(sConfigurationDocument);
        this.theMetadataEditorUser.setSystemMetadataDocumentName(sMetadataDocument);
        try {
            String systemDocumentPath = sConfigurationPath + sMetadataDocument;
            this.theMetadataDispenser = new MetadataDispenser((AbaMetaDataUser)this.theMetadataEditorUser, null, 1);
            this.theMetadataDispenser.theMetadataDocument.loadMeta(systemDocumentPath);
        }
        catch (HammerException e) {
            e.printStackTrace();
        }
    }

    void exitApplication() {
        if (this.isMetadataModified()) {
            String sConfirmationText = "All changes will be lost. Are you sure you want to exit the application ?";
            String sConfirmationTitle = "Unsaved Changes";
            int optionType = 0;
            int messageType = 3;
            int iChoice = JOptionPane.showConfirmDialog((Component)((Object)this), sConfirmationText, sConfirmationTitle, optionType, messageType);
            if (iChoice == 0) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        String sMeta = null;
        if (args.length > 0) {
            sMeta = args[0];
        }
        MetadataEditor editor = new MetadataEditor(null, null, sMeta);
        editor.show();
    }
}

