/*
 * Decompiled with CFR 0.152.
 */
package electric.util;

import electric.util.reflect.Wrappers;
import java.lang.reflect.Array;

public final class ArrayUtil {
    private static final Class BYTE_ARRAY = new byte[0].getClass();

    public static Object addElement(Object object, Object object2) {
        int n = Array.getLength(object);
        Object object3 = Array.newInstance(object.getClass().getComponentType(), n + 1);
        System.arraycopy(object, 0, object3, 0, n);
        Array.set(object3, n, object2);
        return object3;
    }

    public static int[] addElement(int[] nArray, int n) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2 + 1];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        nArray2[n2] = n;
        return nArray2;
    }

    public static Object addElements(Object object, Object object2) {
        int n = Array.getLength(object);
        int n2 = Array.getLength(object2);
        Object object3 = Array.newInstance(object.getClass().getComponentType(), n + n2);
        System.arraycopy(object, 0, object3, 0, n);
        System.arraycopy(object2, 0, object3, n, n2);
        return object3;
    }

    public static Object grow(Object object, int n) {
        int n2 = Array.getLength(object);
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n);
        System.arraycopy(object, 0, object2, 0, n2);
        return object2;
    }

    public static Object insertElement(Object object, Object object2) {
        return ArrayUtil.insertElementAt(object, object2, 0);
    }

    public static Object insertElementAt(Object object, Object object2, int n) {
        int n2 = Array.getLength(object);
        Object object3 = Array.newInstance(object.getClass().getComponentType(), n2 + 1);
        if (n > 0) {
            System.arraycopy(object, 0, object3, 0, n);
        }
        Array.set(object3, n, object2);
        System.arraycopy(object, n, object3, n + 1, n2 - n);
        return object3;
    }

    public static Object removeElement(Object object, Object object2) {
        int n = Array.getLength(object);
        int n2 = 0;
        while (n2 < n) {
            if (object2.equals(Array.get(object, n2))) {
                return ArrayUtil.removeElementAt(object, n2);
            }
            ++n2;
        }
        return object;
    }

    public static Object removeElements(Object object, Object object2) {
        int n = Array.getLength(object2);
        int n2 = 0;
        while (n2 < n) {
            object = ArrayUtil.removeElement(object, Array.get(object2, n2));
            ++n2;
        }
        return object;
    }

    public static Object removeElementIdentity(Object object, Object object2) {
        int n = Array.getLength(object);
        int n2 = 0;
        while (n2 < n) {
            if (object2 == Array.get(object, n2)) {
                return ArrayUtil.removeElementAt(object, n2);
            }
            ++n2;
        }
        return object;
    }

    public static Object removeElementAt(Object object, int n) {
        int n2 = Array.getLength(object);
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n2 - 1);
        System.arraycopy(object, 0, object2, 0, n);
        System.arraycopy(object, n + 1, object2, n, n2 - n - 1);
        return object2;
    }

    public static int indexOf(int n, int[] nArray) {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static int indexOf(Object object, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (ArrayUtil.equals(objectArray[n], object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int indexOfIdentity(Object object, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (object == objectArray[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static boolean contains(Object object, Object[] objectArray) {
        return ArrayUtil.indexOf(object, objectArray) != -1;
    }

    public static boolean equals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (!ArrayUtil.equals(objectArray[n], objectArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static byte[] toBytes(Object object) {
        if (BYTE_ARRAY.isInstance(object)) {
            return (byte[])object;
        }
        if (object == null) {
            return "null".getBytes();
        }
        return object.toString().getBytes();
    }

    public static boolean isPrimitiveArray(Object object) {
        return ArrayUtil.isPrimitiveArray(object.getClass());
    }

    public static boolean isPrimitiveArray(Class clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz.isPrimitive();
    }

    public static Object convertToWrapperArray(Object object) {
        int[] nArray = new int[]{};
        Class<?> clazz = object.getClass();
        while (clazz.isArray()) {
            nArray = ArrayUtil.addElement(nArray, 0);
            clazz = clazz.getComponentType();
        }
        Object object2 = Array.newInstance(Wrappers.getWrapperClass(clazz), nArray);
        return ArrayUtil.copyArray(object, object2);
    }

    public static Object convertToPrimitiveArray(Object object) {
        int[] nArray = new int[]{};
        Class<?> clazz = object.getClass();
        while (clazz.isArray()) {
            nArray = ArrayUtil.addElement(nArray, 0);
            clazz = clazz.getComponentType();
        }
        Object object2 = Array.newInstance(Wrappers.getPrimitiveClass(clazz), nArray);
        return ArrayUtil.copyArray(object, object2);
    }

    private static Object copyArray(Object object, Object object2) {
        int n = Array.getLength(object);
        if (n != Array.getLength(object2)) {
            object2 = Array.newInstance(object2.getClass().getComponentType(), n);
        }
        int n2 = 0;
        while (n2 < n) {
            Object object3 = Array.get(object, n2);
            if (object3.getClass().isArray()) {
                Object object4 = Array.get(object2, n2);
                if (object4 == null) {
                    object4 = Array.newInstance(object2.getClass().getComponentType().getComponentType(), Array.getLength(object3));
                }
                object3 = ArrayUtil.copyArray(object3, object4);
            }
            Array.set(object2, n2, object3);
            ++n2;
        }
        return object2;
    }

    public static int getNumberOfDimensions(Object object) {
        return ArrayUtil.getNumberOfDimensions(object.getClass());
    }

    public static int getNumberOfDimensions(Class clazz) {
        int n = 0;
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++n;
        }
        return n;
    }

    public static Class getBaseClass(Object object) {
        return ArrayUtil.getBaseClass(object.getClass());
    }

    public static Class getBaseClass(Class clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }
}

