/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.Lex;
import electric.xml.Child;
import electric.xml.NodeWriter;
import electric.xml.Parent;
import java.io.IOException;
import org.w3c.dom.ProcessingInstruction;

public class Instruction
extends Child
implements ProcessingInstruction {
    static final String START = "<?";
    static final String STOP = "?>";
    protected String target;
    protected String content;

    public Instruction(String string, String string2) {
        this.target = string;
        this.content = string2;
    }

    public Instruction(Instruction instruction) {
        this.target = instruction.target;
        this.content = instruction.content;
    }

    protected Instruction() {
    }

    protected Instruction(Parent parent) {
        super(parent);
    }

    Instruction(Lex lex, Parent parent) throws IOException {
        super(parent);
        lex.skip(START.length());
        this.target = lex.readToken();
        this.content = lex.readToPattern(STOP, 3);
    }

    public Object clone() {
        return new Instruction(this);
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void write(NodeWriter nodeWriter) throws IOException {
        nodeWriter.writeIndent();
        nodeWriter.write(START);
        nodeWriter.write(this.target);
        nodeWriter.write(' ');
        nodeWriter.write(this.getContent());
        nodeWriter.write(STOP);
    }

    public short getNodeType() {
        return 7;
    }

    public String getNodeName() {
        return this.getTarget();
    }

    public String getNodeValue() {
        return this.getContent();
    }

    public void setNodeValue(String string) {
        this.setContent(string);
    }

    public String getData() {
        return this.getContent();
    }

    public void setData(String string) {
        this.setContent(string);
    }
}

