// copyright 2001-2002 by The Mind Electric

package electric.util.interceptor;

import java.io.*;
import electric.util.*;
import electric.xml.*;
import electric.xml.io.*;
import electric.xml.io.encoded.*;
import electric.xml.io.literal.*;
import electric.soap.*;

/**
 * <tt>ReceiveThreadContext</tt>
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class ReceiveThreadContext implements ISOAPInterceptor
  {
  private String name;
  private boolean encoded;

  // ********** CONSTRUCTION ************************************************

  /**
   * @param name
   */
  public ReceiveThreadContext( String name )
    {
    this( name, true );
    }

  /**
   * @param name
   * @param encoded
   */
  public ReceiveThreadContext( String name, boolean encoded )
    {
    this.name = name;
    this.encoded = encoded;
    }

  // ********** NAME ********************************************************

  /**
   *
   */
  public String getName()
    {
    return name;
    }

  /**
   * @param name
   */
  public void setName( String name )
    {
    this.name = name;
    }

  // ********** ENCODED/LITERAL *********************************************

  /**
   *
   */
  public boolean getEncoded()
    {
    return encoded;
    }

  /**
   * @param encoded
   */
  public void setEncoded( boolean encoded )
    {
    this.encoded = encoded;
    }

  // ********** INTERCEPT ***************************************************

  /**
   * @param message
   * @param context
   */
  public void intercept( SOAPMessage message, Context context )
    {
    Element headerElement = message.getHeaderElement( name );

    if( headerElement == null )
      {
      Context.thread().setProperty( name, null );
      return;
      }

    IReader reader = null;

    if( encoded )
      reader = new EncodedReader( headerElement );
    else
      reader = new LiteralReader( headerElement );

    try
      {
      Object property = reader.readObject();
      Context.thread().setProperty( name, property );
      }
    catch( IOException exception )
      {
      message.setException( exception );
      }
    }
  }