// copyright 2001-2002 by The Mind Electric

package electric.util.io;

import java.io.*;

/**
 * <tt>FastReader</tt> is a fast version of StringReader.
 */

public final class FastReader extends Reader
  {
  private String string;
  private int length;
  private int next = 0;
  private int mark = 0;

  // ********** CONSTRUCTION ************************************************

  /**
   * @param string
   */
  public FastReader( String string )
    {
    this.string = string;
    this.length = string.length();
    }

  // ********** I/O *********************************************************

  /**
   *
   */
  public int read()
    {
    return (next >= length ? -1 : string.charAt( next++ ));
    }

  /**
   * @param cbuf
   * @param offset
   * @param length
   */
  public int read( char cbuf[], int offset, int length )
    {
    if( length == 0 )
      return 0;

    if( next >= length )
      return -1;

    int n = Math.min( length - next, length );
    string.getChars( next, next + n, cbuf, offset );
    next += n;
    return n;
    }

  /**
   * @param amount
   */
  public long skip( long amount )
    {
    if( next >= length )
      return 0;

    long n = Math.min( length - next, amount );
    next += n;
    return n;
    }

  /**
   *
   */
  public boolean ready()
    {
    return true;
    }

  /**
   *
   */
  public boolean markSupported()
    {
    return true;
    }

  /**
   * @param readAheadLimit
   */
  public void mark( int readAheadLimit )
    {
    mark = next;
    }

  /**
   *
   */
  public void reset()
    {
    next = mark;
    }

  /**
   *
   */
  public void close()
    {
    string = null;
    }
  }