// copyright 2001-2002 by The Mind Electric

package electric.util.log;

import java.util.*;

/**
 * <tt>ILogger</tt> declares methods that are implemented by all loggers.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public interface ILogger
  {
  /**
   * Return the mask that defines which events I should log.
   */
  long getMask();

  /**
   * Set the mask that defines the events which I should log.
   * @param mask
   */
  void setMask( long mask );

  /**
   * Start logging events of the specified category.
   * @param category The category.
   */
  void startLogging( String category );

  /**
   * Stop logging events of the specified category.
   * @param category The category.
   */
  void stopLogging( String category );

  /**
   * Enable this particular logger.
   */
  public void enable();

  /**
   * Disable this logger.
   */
  public void disable();

  /**
   * If enabled, log an event of the specified category.
   * @param category The category.
   * @param event The event, which is often just a simple string.
   * @param timestamp The time of the event was logged.
   */
  void event( String category, Object event, Date timestamp );
  }