// copyright 2001-2002 by The Mind Electric

package electric.xml;

/**
 * <tt>CharacterData</tt>.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public abstract class CharacterData extends Child implements org.w3c.dom.CharacterData
  {
  protected String string;

  // ********** CONSTRUCTION ************************************************

  /**
   * Construct a CharacterData with the specified parent.
   * @param parent The parent.
   */
  public CharacterData( Parent parent )
    {
    super( parent );
    }

  /**
   * Construct a CharacterData with the specified string.
   * @param string The string.
   */
  public CharacterData( String string )
    {
    this.string = string;
    }

  // ********** DOM *********************************************************

  /**
   * Return the string.
   */
  public String getNodeValue()
    {
    return string;
    }

  /**
   * Set the string to the specified value.
   * @param nodeValue The new string.
   */
  public void setNodeValue( String nodeValue )
    {
    string = nodeValue;
    }

  /**
   * Return my string.
   */
  public String getData()
    {
    return string;
    }

  /**
   * Return the length of the string.
   */
  public int getLength()
    {
    return string.length();
    }

  /**
   * Set the new string.
   * @param string The new string.
   */
  public void setData( String string )
    {
    this.string = string;
    }

  /**
   * Append the string to the end of the character data of this node.
   * @param arg The string to append.
   */
  public void appendData( String arg )
    {
    string = string + arg;
    }

  /**
   * Remove a range of characters from the node.
   * @param offset The offset from which to start removing.
   * @param count The number of characters to delete. If the sum of offset
   * and count exceeds length then all characters units from offset to the end
   * of the data are deleted.
   * @throws DOMException If the specified offset is negative or greater than
   * the number of characters, or if the specified count is negative.
   */
  public void deleteData( int offset, int count )
    throws org.w3c.dom.DOMException
    {
    if( offset < 0 || offset > string.length() || count < 0 )
      throw new org.w3c.dom.DOMException( org.w3c.dom.DOMException.INDEX_SIZE_ERR, "offset = " + offset + ", count = " + count + ", string = " + string );

    if( offset + count >= string.length() )
      string = string.substring( 0, offset );
    else
      string = string.substring( 0, offset ) + string.substring( offset + count );
    }

  /**
   * Insert a string at the specified offset.
   * @param offset The character offset at which to insert.
   * @param arg The string to insert.
   * @throws DOMException If the specified offset is negative or greater
   * than the length of the data.
   */
  public void insertData( int offset, String arg )
    throws org.w3c.dom.DOMException
    {
    if( offset < 0 || offset > string.length() )
      throw new org.w3c.dom.DOMException( org.w3c.dom.DOMException.INDEX_SIZE_ERR, "offset = " + offset + ", string = " + string );

    string = string.substring( 0, offset ) + arg + string.substring( offset );
    }

  /**
   * Replace the characters starting at the specified offset with the specified string.
   * @param offset The offset from which to start replacing.
   * @param count The number of characters to replace. If the sum of offset and
   * count exceeds length, then all characters to the end of the data are
   * replaced; (i.e., the effect is the same as a remove method call with the
   * same range, followed by an append method invocation).
   * @param arg The string with which the range must be replaced.
   * @throws DOMException If the specified offset is negative or greater than
   * the number of characters in data, or if the specified count is negative.
   */
  public void replaceData( int offset, int count, String arg )
    throws org.w3c.dom.DOMException
    {
    if( offset < 0 || offset > string.length() || count < 0 )
      throw new org.w3c.dom.DOMException( org.w3c.dom.DOMException.INDEX_SIZE_ERR, "offset = " + offset + ", count = " + count + ", string = " + string );

    if( offset + count >= string.length() )
      string = string.substring( 0, offset ) + arg;
    else
      string = string.substring( 0, offset ) + arg + string.substring( offset + count );
    }

  /**
   * Return the specified substring. If the sum of offset and count exceeds
   * the length, then all characters to the end of the data are returned.
   * @param offset The offset of substring to extract.
   * @param count The number of characters to extract.
   * @throws DOMException If the specified offset is negative or greater
   * than the number of characters in data, or if the specified count is negative.
   */
  public String substringData( int offset, int count )
    throws org.w3c.dom.DOMException
    {
    if( offset < 0 || offset > string.length() || count < 0 )
      throw new org.w3c.dom.DOMException( org.w3c.dom.DOMException.INDEX_SIZE_ERR, "offset = " + offset + ", count = " + count + ", string = " + string );

    if( offset + count >= string.length() )
      return string.substring( offset );
    else
      return string.substring( offset, offset + count );
    }
  }