// copyright 2001-2002 by The Mind Electric

package electric.xml;

import java.io.*;
import electric.util.*;

/**
 * <tt>Comment</tt> represents an XML comment.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

final public class Comment extends CharacterData implements org.w3c.dom.Comment
  {
  static final String START = "<!--";
  static final String STOP = "-->";

  // ********** CONSTRUCTION ************************************************

  /**
   * Construct a Comment with the specified string.
   * @param string The comment string.
   */
  public Comment( String string )
    {
    super( string );
    }

  /**
   * Construct a copy of the specified Comment.
   * @param The Comment to copy.
   */
  public Comment( Comment comment )
    {
    super( comment.string );
    }

  /**
   * Construct a Comment from the specified lexical analyzer.
   * @param lex The lexical analyzer.
   * @param parent The parent of this Comment.
   * @throws IOException If an error occurs during parsing.
   */
  Comment( Lex lex, Parent parent )
    throws IOException
    {
    super( parent );
    lex.skip( START.length() );
    string = lex.readToPattern( STOP, Lex.CONSUME );
    }

  // ********** CLONING *****************************************************

  /**
   * Return a clone of this Comment.
   */
  public Object clone()
    {
    return new Comment( this );
    }

  // ********** COMMENT STRING **********************************************

  /**
   * Return my string.
   */
  public String getString()
    {
    return string;
    }

  /**
   * Set my string.
   * @param string The new string value.
   */
  public void setString( String string )
    {
    this.string = string;
    }

  // ********** WRITING *****************************************************

  /**
   * Write myself to the specified writer.
   * @param writer The nodeWriter.
   * @throws IOException If an I/O exception occurs.
   */
  public void write( NodeWriter writer )
    throws IOException
    {
    writer.writeIndent();
    writer.write( START );
    writer.write( string );
    writer.write( STOP );
    }

  // ********** DOM *********************************************************

  /**
   * Return COMMENT_NODE;
   */
  public short getNodeType()
    {
    return COMMENT_NODE;
    }

  /**
   * Return "#comment".
   */
  public String getNodeName()
    {
    return "#comment";
    }
  }