// copyright 2001-2002 by The Mind Electric

package electric.xml;

import java.io.*;
import electric.util.*;

/**
 * <tt>ElementDecl</tt> represents an XML ELEMENT declaration.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

final public class ElementDecl extends Child
  {
  static final String START = "<!ELEMENT";
  static final String STOP = ">";

  private String content;

  // ********** CONSTRUCTION ************************************************

  /**
   * Construct an ElementDecl with the specified content.
   * @param content The content.
   */
  public ElementDecl( String content )
    {
    this.content = content;
    }

  /**
   * Construct a copy of the specified ElementDecl.
   * @param elementDecl The ElementDecl to copy.
   */
  public ElementDecl( ElementDecl elementDecl )
    {
    this.content = elementDecl.content;
    }

  /**
   * Construct an ElementDecl from the specified lexical analyzer.
   * @param lex The lexical analyzer.
   * @param parent The parent of this ElementDecl.
   * @throws IOException If an error occurs during parsing.
   */
  ElementDecl( Lex lex, Parent parent )
    throws IOException
    {
    super( parent );
    lex.skip( START.length() );
    String token = lex.readToPattern( STOP, Lex.CONSUME | Lex.INCLUDE | Lex.QUOTES );
    content = token.substring( 0, token.length() - STOP.length() );
    }

  // ********** CLONING *****************************************************

  /**
   * Return a clone of this ElementDecl.
   */
  public Object clone()
    {
    return new ElementDecl( this );
    }

  // ********** CONTENT *****************************************************

  /**
   * Return my content.
   */
  public String getContent()
    {
    return content;
    }

  /**
   * Set my content.
   * @param content The new content value.
   */
  public void setContent( String content )
    {
    this.content = content;
    }

  // ********** WRITING *****************************************************

  /**
   * Write myself to the specified writer.
   * @param writer The nodeWriter.
   * @throws IOException If an I/O exception occurs.
   */
  public void write( NodeWriter writer )
    throws IOException
    {
    writer.writeIndent();
    writer.write( START );
    writer.write( content );
    writer.write( STOP );
    }
  }