// copyright 2001-2002 by The Mind Electric

package electric.xml;

/**
 * <tt>IXPath</tt>.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public interface IXPath
  {
  /**
   * @param element
   * @throws XPathException
   */
  Attributes getAttributes( Element element )
    throws XPathException;

  /**
   * @param element
   * @throws XPathException
   */
  Attribute getAttribute( Element element )
    throws XPathException;

  /**
   * @param parent
   * @throws XPathException
   */
  Elements getElements( Parent parent )
    throws XPathException;

  /**
   * @param parent
   * @throws XPathException
   */
  Element getElement( Parent parent )
    throws XPathException;

  /**
   * @param prefix
   * @param namespace
   * @throws XPathException
   */
  void setNamespace( String prefix, String namespace )
    throws XPathException;
  }
