// copyright 2001-2002 by The Mind Electric

package electric.xml.io.collections.net;

import java.io.*;
import java.util.*;
import electric.xml.*;
import electric.xml.io.*;
import electric.xml.io.schema.*;
import electric.util.Value;

/**
 * <tt>HashSetType</tt>
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class HashSetType extends CollectionType
  {
  // ********** SCHEMA ******************************************************

  /**
   * @param schema
   * @throws SchemaException
   */
  public void writeSchema( Element schema )
    throws SchemaException
    {
    Type type = getType( OBJECT_ARRAY_CLASS );
    String xsdPrefix = Namespaces.getPrefix( schema, SchemaProperties.getDefaultSchema() , "xsd" );

    Element complexType = schema.addElement( xsdPrefix, "complexType" );
    complexType.setAttribute( "name", "HashSet" );
    Element sequence = complexType.addElement( xsdPrefix, "sequence" );

    Element objects = sequence.addElement( xsdPrefix, "element" );
    objects.setAttribute( "name", "elements" );
    objects.setAttribute( "type", getName( type.getNamespace(), type.getName(), objects ) );
    }

  // ********** XML SERIALIZATION *******************************************

  /**
   * @param writer
   * @param object
   * @throws IOException
   */
  public void writeObject( IWriter writer, Object object )
    throws IOException
    {
    writeArray( writer, "elements", ((HashSet) object).toArray() );
    }

  /**
   * @param reader
   * @param value
   * @throws IOException
   */
  public void readObject( IReader reader, Value value )
    throws IOException
    {
    HashSet set = (HashSet) value.getObject();

    if( set == null )
      {
      set = new HashSet();
      value.setObject( set );
      }

    Object[] array = readArray( reader, "elements" );

    for( int i = 0; i < array.length; i++ )
      set.add( array[ i ] );
    }
  }