// copyright 2001-2002 by The Mind Electric
// based on source code contributed by the jaxen group, http://www.jaxen.org

package electric.xml.jaxen;

import org.jaxen.XPath;
import org.jaxen.*;
import org.jaxen.util.*;
import org.saxpath.SAXPathException;
import electric.xml.*;
import java.io.File;
import java.util.*;

/**
 * <tt>DocumentNavigator</tt>
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class DocumentNavigator extends DefaultNavigator
  {
  private static DocumentNavigator documentNavigator = new DocumentNavigator();

  // ********** SINGLETON ACCESS ********************************************

 /**
  * Retrieve the singleton instance of this <code>DocumentNavigator</code>.
  */
  public static DocumentNavigator getInstance()
    {
    return documentNavigator;
    }

  // ********** PARSING ******************************************************

  /**
   * Returns a parsed form of the given xpath string, which will be suitable
   * for queries on EXML documents.
   * @param xpath
   * @throws SAXPathException
   */
  public XPath parseXPath( String xpath )
    throws SAXPathException
    {
    return new JaxenXPath( xpath );
    }

  // ********** PROCESSING INSTRUCTIONS *************************************

  /**
   * @param object
   */
  public boolean isProcessingInstruction( Object object )
    {
    return (object instanceof Instruction);
    }

  /**
   * @param object
   */
  public String getProcessingInstructionTarget( Object object )
    {
    return ((Instruction) object).getTarget();
    }

  /**
   * @param object
   */
  public String getProcessingInstructionData( Object object )
    {
    return ((Instruction) object).getContent();
    }

  // ********** COMMENTS ****************************************************

  /**
   * @param object
   */
  public boolean isComment( Object object )
    {
    return (object instanceof Comment);
    }

  /**
   * @param object
   */
  public String getCommentStringValue( Object object )
    {
    return ((Comment) object).getString();
    }

  // ********** TEXT ********************************************************

  /**
   * @param object
   */
  public boolean isText( Object object )
    {
    return (object instanceof Text);
    }

  /**
   * @param object
   */
  public String getTextStringValue( Object object )
    {
    return ((Text) object).getString();
    }

  // ********** ELEMENTS ****************************************************

  /**
   * @param object
   */
  public boolean isElement( Object object )
    {
    return (object instanceof Element);
    }

  /**
   * @param object
   */
  public String getElementName( Object object )
    {
    return ((Element) object).getName();
    }

  /**
   * @param object
   */
  public String getElementNamespaceUri( Object object )
    {
    return ((Element) object).getNamespace();
    }

  /**
   * @param object
   */
  public String getElementQName( Object object )
    {
    return ((Element) object).getQName();
    }

  /**
   * @param object
   */
  public String getElementStringValue( Object object )
    {
    return getStringValue( (Element) object );
    }

  /**
   * @param element
   */
  private String getStringValue( Element element )
    {
    StringBuffer buf = new StringBuffer();
    Children children = element.getChildren();
    Child eachChild = null;

    while( (eachChild = children.next()) != null )
      {
      if( eachChild instanceof Element )
        buf.append( getStringValue( (Element) eachChild ) );
      else if( eachChild instanceof Text )
        buf.append( ((Text) eachChild).getString() );
      }

    return buf.toString();
    }

  // ********** ATTRIBUTES **************************************************

  /**
   * @param object
   */
  public boolean isAttribute( Object object )
    {
    return (object instanceof Attribute);
    }

  /**
   * @param object
   */
  public String getAttributeQName( Object object )
    {
    return ((Attribute) object).getQName();
    }

  /**
   * @param object
   */
  public String getAttributeStringValue( Object object )
    {
    return ((Attribute) object).getValue();
    }

  /**
   * @param object
   */
  public String getAttributeName( Object object )
    {
    return ((Attribute) object).getName();
    }

  /**
   * @param object
   */
  public String getAttributeNamespaceUri( Object object )
    {
    return ((Attribute) object).getNamespace();
    }

  // ********** DOCUMENTS ***************************************************

  /**
   * @param object
   */
  public boolean isDocument( Object object )
    {
    return (object instanceof Document);
    }

  /**
   * @param contextNode
   */
  public Object getDocumentNode( Object contextNode )
    {
    if( contextNode instanceof Document )
      return contextNode;
    else
      return ((Element) contextNode).getDocument();
    }

  /**
   * @param url
   * @throws FunctionCallException
   */
  public Object getDocument( String url )
    throws FunctionCallException
    {
    try
      {
      return new Document( new File( url ) );
      }
    catch( ParseException exception )
      {
      throw new FunctionCallException( exception.getMessage() );
      }
    }

  // ********** NAMESPACES **************************************************

  /**
   * @param object
   */
  public boolean isNamespace( Object object )
    {
    return (object instanceof Namespace);
    }

  /**
   * @param object
   */
  public String getNamespacePrefix( Object object )
    {
    return ((Namespace) object).getPrefix();
    }

  /**
   * @param object
   */
  public String getNamespaceStringValue( Object object )
    {
    return ((Namespace) object).getURI();
    }

  /**
   * @param prefix
   * @param context
   */
  public String translateNamespacePrefixToUri( String prefix, Object context )
    {
    if( context instanceof Element )
      return ((Element) context).getNamespace( prefix );
    else
      return null;
    }

  // ********** ITERATORS ****************************************************

  /**
   * @param contextNode
   */
  public Iterator getChildAxisIterator( Object contextNode )
    {
    if( contextNode instanceof Parent )
      return new ChildrenIterator( ((Parent) contextNode).getChildren() );
    else
      return null;
    }

  /**
   * @param contextNode
   */
  public Iterator getNamespaceAxisIterator( Object contextNode )
    {
    if( !(contextNode instanceof Element) )
      return null;

    Element elem = (Element) contextNode;
    Map nsMap = new HashMap();
    Element current = elem;

    while( current != null )
      {
      Dictionary namespaces = current.getNamespaces();

      if( namespaces != null )
        {
        Enumeration keys = namespaces.keys();

        while( keys.hasMoreElements() )
          {
          String prefix = (String) keys.nextElement();

          if( !nsMap.containsKey( prefix ) )
            {
            String uri = (String) namespaces.get( prefix );
            nsMap.put( prefix, new Namespace( elem, prefix, uri ) );
            }
          }
        }

      Parent parent = current.getParent();

      if( parent instanceof Element )
        current = (Element) parent;
      else
        break;
      }

    Namespace xml =  new Namespace( elem, "xml", "http://www.w3.org/XML/1998/namespace" );
    nsMap.put( "xml", xml );
    return nsMap.values().iterator();
    }

  /**
   * @param contextNode
   */
  public Iterator getParentAxisIterator( Object contextNode )
    {
    Object parent = null;

    if( contextNode instanceof Document )
      {
      parent = contextNode;
      }
    else if( contextNode instanceof Element )
      {
      parent = ((Element) contextNode).getParent();

      if( parent == null )
        parent = ((Element) contextNode).getDocument();
      }
    else if( contextNode instanceof Attribute )
      {
      parent = ((Attribute) contextNode).getElement();
      }
    else if( contextNode instanceof Instruction )
      {
      parent = ((Instruction) contextNode).getParent();
      }
    else if( contextNode instanceof Text )
      {
      parent = ((Text) contextNode).getParent();
      }
    else if( contextNode instanceof Comment )
      {
      parent = ((Text) contextNode).getParent();
      }
    else if( contextNode instanceof Namespace )
      {
      parent = ((Namespace) contextNode).getElement();
      }

    if( parent != null )
      return new SingleObjectIterator( parent );
    else
      return null;
    }

  /**
   * @param contextNode
   */
  public Iterator getAttributeAxisIterator( Object contextNode )
    {
    if( !(contextNode instanceof Element) )
      return null;

    Element elem = (Element) contextNode;
    return new AttributesIterator( elem.getAttributeObjects() );
    }
  }